/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import java.util.Objects;
import util.corpus.wrappers.AmrConcept;
import util.corpus.wrappers.AmrRole;

public class AmrProposition
implements Comparable<AmrProposition> {
    private AmrConcept predicate;
    private AmrConcept argument;
    private AmrRole role;

    public AmrProposition() {
    }

    public AmrProposition(AmrConcept predicate, AmrRole role) {
        this.predicate = predicate;
        this.role = role;
    }

    public AmrProposition(AmrConcept predicate, AmrConcept argument) {
        this.predicate = predicate;
        this.argument = argument;
    }

    public AmrProposition(AmrConcept predicate, AmrConcept argument, AmrRole role) {
        this.predicate = predicate;
        this.argument = argument;
        this.role = role;
    }

    public AmrProposition(String raw) {
        String[] ar = raw.split(",");
        if (ar.length == 3) {
            this.predicate = new AmrConcept(ar[0]);
            this.argument = new AmrConcept(ar[1]);
            this.role = new AmrRole(ar[2]);
        } else {
            this.predicate = new AmrConcept("N/A");
            this.argument = new AmrConcept("N/A");
            this.role = new AmrRole(":unk");
        }
    }

    public void setPredicate(AmrConcept predicate) {
        this.predicate = predicate;
    }

    public AmrConcept getPredicate() {
        return this.predicate;
    }

    public void setArgument(AmrConcept argument) {
        this.argument = argument;
    }

    public AmrConcept getArgument() {
        return this.argument;
    }

    public void setRole(AmrRole role) {
        this.role = role;
    }

    public AmrRole getRole() {
        return this.role;
    }

    public boolean roleNameEquals(String name) {
        return this.role.getName().equals(name);
    }

    public boolean isEmpty() {
        return this.predicate == null && this.argument == null && this.role == null;
    }

    public boolean equals(Object obj) {
        assert (obj instanceof AmrProposition);
        AmrProposition o = (AmrProposition)obj;
        return this.predicate.equals(o.predicate) && this.argument.equals(o.argument) && this.role.equals(o.role);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.predicate);
        hash = 17 * hash + Objects.hashCode(this.argument);
        hash = 17 * hash + Objects.hashCode(this.role);
        return hash;
    }

    public String toString() {
        return String.format("%s,%s,%s", this.predicate.name, this.argument.name, this.role == null ? ":unk" : this.role.name);
    }

    @Override
    public int compareTo(AmrProposition o) {
        return 1;
    }
}

