/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.LexedTokenFactory;
import edu.stanford.nlp.process.PTBTokenizer;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import util.corpus.wrappers.AmrLinearizedSentence;
import util.corpus.wrappers.AmrSentence;
import util.corpus.wrappers.Dictionaries;
import util.corpus.wrappers.JamrAlignment;

public class AmrWrapper {
    protected final List<AmrSentence> amrSentences = new ArrayList<AmrSentence>();
    private final boolean isLinearize;
    private final Map<String, Map<String, JamrAlignment>> jamrAlignments;
    protected final Dictionaries dictionaries;
    protected final String linearizeType;
    protected final String[] lines;

    public AmrWrapper(String linearizeType, boolean isLinearize, Map<String, Map<String, JamrAlignment>> jamrAlignments, Dictionaries dictionaries, String[] lines) {
        this.linearizeType = linearizeType;
        this.isLinearize = isLinearize;
        this.jamrAlignments = jamrAlignments;
        this.dictionaries = dictionaries;
        this.lines = lines;
    }

    public List<AmrSentence> getAmrSentences() {
        return this.amrSentences;
    }

    public void parse() {
        for (int i = 2; i < this.lines.length; ++i) {
            String[] tokens = this.lines[i].substring(2).split("::");
            if (tokens[1].startsWith("id")) {
                String id = tokens[1].substring(2).trim();
                if (this.lines[++i].substring(2).startsWith("::snt") || this.lines[i].substring(2).startsWith("::tok")) {
                    String sentence = AmrWrapper.normalize(this.lines[i].substring(2).startsWith("::snt") ? AmrWrapper.tokenize(this.lines[i].substring(8)) : this.lines[i].substring(8));
                    if (this.lines[++i].startsWith("# ::zh")) {
                        ++i;
                    }
                    ++i;
                    StringBuilder str = new StringBuilder();
                    while (i < this.lines.length && !this.lines[i].equals("")) {
                        str.append(this.lines[i++]).append("\n");
                    }
                    AmrSentence candSent = this.isLinearize ? new AmrLinearizedSentence(id, sentence, this.jamrAlignments.getOrDefault(id, Collections.EMPTY_MAP), this.linearizeType) : new AmrSentence(id, sentence);
                    candSent.parseAmr(id, str.toString(), this.dictionaries);
                    if (candSent.getAmr().isEmpty()) continue;
                    this.amrSentences.add(candSent);
                    continue;
                }
                System.err.println("Could not find sentence!");
                continue;
            }
            System.err.println("Could not find id!");
        }
    }

    public static String tokenize(String input) {
        StringBuilder str = new StringBuilder();
        PTBTokenizer ptbt = new PTBTokenizer((Reader)new StringReader(input), (LexedTokenFactory)new CoreLabelTokenFactory(), "ptb3Escaping=false");
        ptbt.tokenize().stream().forEach(label -> {
            if (!label.toString().equals("\"") && !label.toString().equals("\\")) {
                str.append(label).append(" ");
            }
        });
        return str.toString().trim();
    }

    public static String normalize(String input) {
        StringBuilder str = new StringBuilder();
        String[] toks = Arrays.asList(input.split(" ")).stream().filter(token -> !token.equals("")).collect(Collectors.toList()).toArray(new String[0]);
        int i = 0;
        for (String tok : toks) {
            if (i == toks.length - 1 && tok.endsWith(".") && tok.length() > 1) {
                int index = tok.indexOf(".");
                if (index == tok.lastIndexOf(".")) {
                    str.append(tok.substring(0, index)).append(" ").append(tok.substring(index));
                } else {
                    index = tok.lastIndexOf("..");
                    if (index != -1) {
                        str.append(tok.substring(0, index)).append(". .");
                    } else {
                        str.append(tok).append(" ");
                    }
                }
            } else if (tok.matches("[a-zA-z0-9]+[.]{2,}+")) {
                int index = tok.indexOf(".");
                str.append(tok.substring(0, index)).append(" ... ");
            } else if (tok.matches("[.]{2,}+[a-zA-z0-9]+")) {
                int index = tok.indexOf(".");
                str.append("... ").append(tok.substring(0, index));
            } else if (tok.matches("[a-zA-z0-9\"]+[.]{2,}+[a-zA-z0-9)?\"]+")) {
                int index = tok.indexOf(".");
                str.append(tok.substring(0, index)).append(" ... ").append(tok.substring(tok.lastIndexOf(".") + 1));
            } else if (!(!tok.contains("/") || tok.equals("@/@") || tok.contains("http") || tok.contains("www") || tok.contains(".com") || tok.contains(".uk") || tok.length() <= 2)) {
                String[] ar = tok.split("/");
                for (int k = 0; k < ar.length - 1; ++k) {
                    str.append(ar[k]).append(" @/@ ");
                }
                str.append(ar[ar.length - 1]).append(" ");
            } else {
                switch (tok) {
                    case "'": {
                        str.append("\" ");
                        break;
                    }
                    case ".'": {
                        str.append("\" . ");
                        break;
                    }
                    case "'.": {
                        str.append("\" . ");
                        break;
                    }
                    case "';": {
                        str.append("\" ; ");
                        break;
                    }
                    case "\".": {
                        str.append("\" . ");
                        break;
                    }
                    case ".\"": {
                        str.append(". \" ");
                        break;
                    }
                    case "',": {
                        str.append("\" , ");
                        break;
                    }
                    case "\",": {
                        str.append("\" , ");
                        break;
                    }
                    case "''": {
                        str.append("\" ");
                        break;
                    }
                    case "\u201c": {
                        str.append("\" ");
                        break;
                    }
                    case "\u201d": {
                        str.append("\" ");
                        break;
                    }
                    case "``": {
                        str.append("\" ");
                        break;
                    }
                    case "\"...": {
                        str.append("\" ... ");
                        break;
                    }
                    case "/": {
                        str.append("@/@ ");
                        break;
                    }
                    case "\\\\": 
                    case "#": {
                        break;
                    }
                    default: {
                        str.append(tok.replaceAll("\\\\", "").replaceAll("#", "").replaceAll("''", "")).append(" ");
                    }
                }
            }
            ++i;
        }
        return str.toString().trim();
    }
}

