/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import util.corpus.wrappers.AmrAnonymizationAlignment;
import util.corpus.wrappers.AmrRole;
import util.utils.HistMap;
import util.utils.Settings;

public class Dictionaries {
    private Settings settings;
    private final String corpus;
    private final String exportType;
    private Set<String> linearizedFilter = null;
    private Set<String> amrNeConcepts = null;
    private Set<String> amrQuantityConcepts = null;
    private Set<String> amrValueConcepts = null;
    private Set<String> amrDateRoles = null;
    private Set<String> mrsFeatures = null;
    private Map<String, String> amrNeClusters = null;
    private Map<AmrRole, Integer> amrRoles;
    private Map<String, String> amrAnonymizationAlignments = null;
    private Map<String, String> neNlAmrAlignments = null;
    private Map<String, Integer> amrNlVocabulary = null;
    private int[] numOfNlNeTokens = null;
    private HistMap<String> neTokens = null;

    public Dictionaries(Settings settings, boolean verbose, String corpus, boolean annotationUseNeClusters) {
        this.settings = settings;
        this.corpus = corpus;
        this.exportType = settings.getProperty(corpus + ".export.type");
        switch (corpus) {
            case "amr": {
                switch (this.exportType) {
                    case "linearize": {
                        this.preLoadLinearizeDictionaries(verbose);
                    }
                }
                break;
            }
            case "mrs": {
                this.preLoadLinearizeMrsDictionaries(verbose);
                break;
            }
            case "gigaword": {
                this.numOfNlNeTokens = new int[2];
                this.neTokens = new HistMap();
                this.preLoadLinearizeDictionariesGiga(verbose, annotationUseNeClusters);
                break;
            }
            default: {
                this.preLoadLinearizeDictionariesAnonymize(verbose, annotationUseNeClusters);
            }
        }
    }

    private void preLoadLinearizeDictionaries(boolean verbose) {
        this.amrNeConcepts = this.readHashSet(this.settings.getProperty(this.corpus + ".concepts.ne"));
        if (verbose) {
            System.out.println("Read " + this.amrNeConcepts.size() + " NE concepts from propreties.");
        }
        this.amrNeClusters = this.readNeClusters(this.settings.getProperty(this.corpus + ".concepts.neClusters"));
        this.amrQuantityConcepts = this.readHashSet(this.settings.getProperty(this.corpus + ".concepts.quantity"));
        if (verbose) {
            System.out.println("Read " + this.amrQuantityConcepts.size() + " Quantity concepts from propreties.");
        }
        this.amrValueConcepts = this.readHashSet(this.settings.getProperty(this.corpus + ".concepts.value"));
        if (verbose) {
            System.out.println("Read " + this.amrValueConcepts.size() + " Value concepts from propreties.");
        }
        this.amrDateRoles = this.readHashSet(this.settings.getProperty(this.corpus + ".roles.date"));
        if (verbose) {
            System.out.println("Read " + this.amrDateRoles.size() + " Date roles from propreties.");
        }
        this.linearizedFilter = this.readHashSet(this.settings.getProperty(this.corpus + ".linearize.filter"));
        if (verbose) {
            System.out.println("Read " + this.linearizedFilter.size() + " concepts/roles to filter from propreties.");
        }
        this.linearizedFilter.addAll(this.amrNeConcepts);
        this.linearizedFilter.addAll(this.amrQuantityConcepts);
        this.linearizedFilter.addAll(this.amrValueConcepts);
        this.amrRoles = new HashMap<AmrRole, Integer>();
        Random rnd = new Random(1234L);
        try {
            String path = this.settings.getProperty(this.corpus + ".roles.path");
            if (path != null && !path.equals("")) {
                int i;
                boolean reentrancesRoles = this.settings.getProperty(this.corpus + ".down.reentrancesRoles").equals("true");
                List roles = reentrancesRoles ? Files.lines(Paths.get(path, new String[0])).map(line -> line.split("\t")[0].toLowerCase()).collect(Collectors.toList()) : Files.lines(Paths.get(path, new String[0])).filter(line -> !line.split("\t")[0].toLowerCase().contains("-r")).map(line -> line.split("\t")[0].toLowerCase()).collect(Collectors.toList());
                roles.add("<unk>");
                ArrayList<Integer> ids = new ArrayList<Integer>(roles.size());
                for (i = 0; i < roles.size(); ++i) {
                    ids.add(i);
                }
                Collections.shuffle(ids, rnd);
                for (i = 0; i < roles.size(); ++i) {
                    this.amrRoles.put(new AmrRole((String)roles.get(i)), (Integer)ids.get(i));
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("Couldn't read roles file");
        }
    }

    private void preLoadLinearizeMrsDictionaries(boolean verbose) {
        this.preLoadLinearizeDictionaries(verbose);
        this.mrsFeatures = this.readHashSet(this.settings.getProperty("mrs.roles.features"));
        if (verbose) {
            System.out.println("Read " + this.mrsFeatures.size() + " MRS features from propreties.");
        }
    }

    private void preLoadLinearizeDictionariesGiga(boolean verbose, boolean annotationUseNeClusters) {
        this.amrNeConcepts = this.readHashSet(this.settings.getProperty("amr.concepts.ne"));
        if (verbose) {
            System.out.println("Read " + this.amrNeConcepts.size() + " NE concepts from propreties.");
        }
        this.amrNeClusters = this.readNeClusters(this.settings.getProperty("amr.concepts.neClusters"));
        this.amrAnonymizationAlignments = this.readNeAmrAlignments(this.settings.getProperty(this.corpus + ".down.amrAnonymization"), annotationUseNeClusters);
        this.neNlAmrAlignments = this.readNeNlAmrAlignments(this.settings.getProperty(this.corpus + ".down.amrAnonymization"));
        this.amrNlVocabulary = this.readHistMap(this.settings.getProperty(this.corpus + ".down.amrVocabulary"));
    }

    private void preLoadLinearizeDictionariesAnonymize(boolean verbose, boolean annotationUseNeClusters) {
        this.amrNeConcepts = this.readHashSet(this.settings.getProperty("amr.concepts.ne"));
        if (verbose) {
            System.out.println("Read " + this.amrNeConcepts.size() + " NE concepts from propreties.");
        }
        this.amrNeClusters = this.readNeClusters(this.settings.getProperty("amr.concepts.neClusters"));
        this.amrAnonymizationAlignments = this.readNeAmrAlignments(this.settings.getProperty("gigaword.down.amrAnonymization"), annotationUseNeClusters);
        this.neNlAmrAlignments = this.readNeNlAmrAlignments(this.settings.getProperty("gigaword.down.amrAnonymization"));
    }

    private Map<String, Integer> readHistMap(String path) {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]));){
            stream.forEach(line -> {
                String[] wordFreq = line.split("\t");
                out.put(wordFreq[0], Integer.valueOf(wordFreq[1]));
            });
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        return out;
    }

    private Set<String> readHashSet(String str) {
        return str == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(str.split(",")));
    }

    private Map<String, String> readNeClusters(String str) {
        HashMap<String, String> out = new HashMap<String, String>();
        if (str == null) {
            return out;
        }
        Arrays.asList(str.split("#")).stream().forEach(cluster -> {
            String[] nameToks = cluster.split(":");
            Arrays.asList(nameToks[1].split(",")).stream().forEach(ne -> out.put((String)ne, nameToks[0]));
        });
        return out;
    }

    private Map<String, String> readNeAmrAlignments(String path, boolean annotationUseNeClusters) {
        HashMap<String, String> out = new HashMap<String, String>();
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]));){
            stream.forEach(example -> {
                String[] nameAlignments = example.split("\t");
                if (nameAlignments.length > 1) {
                    Arrays.asList(nameAlignments[1].split(" # ")).stream().forEach(alignment -> {
                        AmrAnonymizationAlignment a = new AmrAnonymizationAlignment((String)alignment);
                        if (!a.isEmpty() && a.getAnonymizedToken().contains("name")) {
                            String anonymizedEntity = a.getAnonymizedToken().substring(0, a.getAnonymizedToken().indexOf("_"));
                            String ne = annotationUseNeClusters ? this.amrNeClusters.get(anonymizedEntity) : anonymizedEntity;
                            String nl = a.nlToString().toLowerCase();
                            if (!nl.isEmpty()) {
                                out.put(nl, ne);
                                if (this.numOfNlNeTokens != null && this.neTokens != null) {
                                    this.numOfNlNeTokens[0] = this.numOfNlNeTokens[0] + a.getNlTokens().size();
                                    a.getNlTokens().stream().forEach(this.neTokens::add);
                                }
                            }
                            String amrToken = a.getRawAmrToken().toLowerCase();
                            out.put(amrToken.substring(amrToken.indexOf("_") + 1, amrToken.length()).replaceAll("_", " "), ne);
                        }
                    });
                }
            });
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        return out;
    }

    private Map<String, String> readNeNlAmrAlignments(String path) {
        HashMap<String, String> out = new HashMap<String, String>();
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]));){
            stream.forEach(example -> {
                String[] nameAlignments = example.split("\t");
                if (nameAlignments.length > 1) {
                    Arrays.asList(nameAlignments[1].split(" # ")).stream().forEach(alignment -> {
                        String nl;
                        AmrAnonymizationAlignment a = new AmrAnonymizationAlignment((String)alignment);
                        if (!a.isEmpty() && !(nl = a.nlToString().toLowerCase()).isEmpty()) {
                            String amrToken = a.getRawAmrToken();
                            out.put(nl, amrToken.substring(amrToken.indexOf("_") + 1, amrToken.length()).replaceAll("_", " "));
                        }
                    });
                }
            });
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        return out;
    }

    public Set<String> getAmrDateRoles() {
        return this.amrDateRoles;
    }

    public Map<String, String> getAmrNeClusters() {
        return this.amrNeClusters;
    }

    public Set<String> getAmrNeConcepts() {
        return this.amrNeConcepts;
    }

    public Set<String> getAmrQuantityConcepts() {
        return this.amrQuantityConcepts;
    }

    public Set<String> getAmrValueConcepts() {
        return this.amrValueConcepts;
    }

    public Set<String> getLinearizedFilter() {
        return this.linearizedFilter;
    }

    public Map<AmrRole, Integer> getAmrRoles() {
        return this.amrRoles;
    }

    public Integer getAmrRoleOrderId(AmrRole role) {
        return this.amrRoles.getOrDefault(role, 0);
    }

    public Map<String, String> getAmrAnonymizationAlignments() {
        return this.amrAnonymizationAlignments;
    }

    public Map<String, String> getNeNlAmrAlignments() {
        return this.neNlAmrAlignments;
    }

    public Map<String, Integer> getAmrNlVocabulary() {
        return this.amrNlVocabulary;
    }

    public int[] getNumOfNlNeTokens() {
        return this.numOfNlNeTokens;
    }

    public HistMap<String> getNeTokens() {
        return this.neTokens;
    }

    public Set<String> getMrsFeatures() {
        return this.mrsFeatures;
    }
}

