/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import edu.berkeley.nlp.util.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.text.WordUtils;
import util.corpus.GigawordCorpus;
import util.corpus.wrappers.AmrAnonymizationAlignment;
import util.corpus.wrappers.NerSentence;
import util.server.NamedEntityRecognizerClient;
import util.utils.NamedEntityRecognizer;
import util.utils.NamedEntityRecognizerInterface;

public class GigawordWrapper {
    private final boolean verbose = false;
    private final GigawordCorpus corpus;
    private NamedEntityRecognizerInterface namedEntityRecognizer;
    private final List<NerSentence> annotatedSentences = new ArrayList<NerSentence>();
    private static int nameCounter = 0;
    private static int dateCounter = 0;
    private static int numberCounter = 0;
    private static int nlIdOffset = 0;
    private final boolean useNeClusters;
    private final boolean filterVocabulary;
    private final boolean processingGigaCorpus;
    private final Map<String, String> amrNeAnonymization;
    private final Map<String, String> neNlAmrAlignments;
    private final Set<String> amrNlVocabulary;
    private static final Pattern ORDINAL_PATTERN = Pattern.compile("[st|nd|rd|th]");
    private static final Pattern NUMBER_ORDINAL_PATTERN = Pattern.compile("[0-9]+[st|nd|rd|th]");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");
    private static final Set<String> NUMBERS = new HashSet<String>(Arrays.asList("one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"));
    private static final Set<String> DATE_MODIFIERS = new HashSet<String>(Arrays.asList("next", "previous", "last"));
    private static final Set<String> WEEKDAYS = new HashSet<String>(Arrays.asList("monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "mon", "tue", "wed", "thu", "fri", "sat", "sun", "mon.", "tue.", "wed.", "thu.", "fri.", "sat.", "sun."));
    private static final Set<String> MONTHS = new HashSet<String>(Arrays.asList("january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "jan", "feb", "mar", "apr", "jun", "jul", "aug", "sep", "sept", "oct", "nov", "dec", "jan.", "feb.", "mar.", "apr.", "jun.", "jul.", "aug.", "sep.", "sept.", "oct.", "nov.", "dec."));

    public GigawordWrapper(String path, String annotationType, Map<String, String> amrNes, Map<String, Integer> amrNlVocabulary, Map<String, String> neNlAmrAlignments, GigawordCorpus corpus) {
        this.amrNeAnonymization = amrNes;
        this.neNlAmrAlignments = neNlAmrAlignments;
        this.amrNlVocabulary = new HashSet<String>(amrNlVocabulary.keySet());
        this.corpus = corpus;
        this.useNeClusters = corpus.isAnnotationUseNeClusters();
        this.filterVocabulary = corpus.isFilterVocabulary();
        this.processingGigaCorpus = corpus.getInfix().equals("giga");
        this.namedEntityRecognizer = new NamedEntityRecognizer(false);
        this.parse(path, annotationType);
    }

    public GigawordWrapper(Map<String, String> amrNes, Map<String, String> neNlAmrAlignments, boolean useNeClusters) {
        this.amrNeAnonymization = amrNes;
        this.neNlAmrAlignments = neNlAmrAlignments;
        this.amrNlVocabulary = null;
        this.corpus = null;
        this.useNeClusters = useNeClusters;
        this.filterVocabulary = false;
        this.processingGigaCorpus = false;
        try {
            this.namedEntityRecognizer = new NamedEntityRecognizerClient(4444);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void terminateNerClient() {
        this.namedEntityRecognizer.processToString("terminate_client");
    }

    private void parse(String path, String annotationType) {
        System.out.println("Processing sentences from " + path);
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]));){
            stream.map(line -> this.route((String)line, annotationType)).map(this::normalize).filter(this::filterRawSentence).forEach(sentence -> {
                NerSentence candidate = this.parseSentence((String)sentence, annotationType);
                if (this.filterSentence(candidate)) {
                    this.annotatedSentences.add(candidate);
                    this.corpus.writeLinearize(this.annotatedSentences, true, false);
                }
            });
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    public NerSentence anonymizeRaw(String raw) {
        return this.parseSentence(this.route(raw, "raw"), "raw");
    }

    private String route(String raw, String annotationType) {
        switch (annotationType) {
            default: {
                return raw;
            }
            case "raw": {
                return this.namedEntityRecognizer.processToString(this.normalizeBeforeNer(raw));
            }
            case "rawWithId": 
        }
        String[] idRaw = raw.split("\t");
        return idRaw[0] + "\t" + this.namedEntityRecognizer.processToString(this.normalizeBeforeNer(idRaw[1]));
    }

    private NerSentence parseSentence(String raw, String annotationType) {
        switch (annotationType) {
            case "ner": 
            case "raw": {
                return this.parseNer(raw, "Example_", true);
            }
            case "rawWithId": {
                String[] idRaw = raw.split("\t");
                return this.parseNer(idRaw[1], idRaw[0], false);
            }
        }
        throw new UnsupportedOperationException("Not supported yet");
    }

    private NerSentence parseNer(String raw, String id, boolean generateId) {
        nameCounter = 0;
        dateCounter = 0;
        numberCounter = 0;
        nlIdOffset = 0;
        HashMap<List<String>, AmrAnonymizationAlignment> neMap = new HashMap<List<String>, AmrAnonymizationAlignment>();
        raw = !this.processingGigaCorpus ? this.preprocessDates(raw) : raw;
        String[] ar = raw.split(" ");
        ArrayList<String> sentence = new ArrayList<String>(ar.length);
        ArrayList<String> anonSentence = new ArrayList<String>(ar.length);
        for (int pos = 0; pos < ar.length; ++pos) {
            int index = ar[pos].lastIndexOf("/");
            String word = ar[pos].substring(0, index);
            String ne = ar[pos].substring(index + 1);
            try {
                String[] nextWordNe;
                if (ne.equals("O")) {
                    sentence.add(word);
                    anonSentence.add(word);
                    continue;
                }
                ArrayList<String> multiNes = new ArrayList<String>();
                ArrayList<Integer> multiNesIds = new ArrayList<Integer>();
                multiNes.add(word);
                multiNesIds.add(nlIdOffset + pos);
                int j = pos + 1;
                while (j < ar.length && (nextWordNe = ar[j].split("/"))[1].equals(ne)) {
                    multiNes.add(nextWordNe[0]);
                    multiNesIds.add(nlIdOffset + j++);
                }
                pos = j - 1;
                this.anonymizeEntity(multiNes, ne, neMap, multiNesIds, sentence, anonSentence);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return new NerSentence(id, generateId, sentence, anonSentence, neMap.values());
    }

    public List<NerSentence> getAnnotatedSentences() {
        return this.annotatedSentences;
    }

    private boolean filterRawSentence(String raw) {
        return !this.processingGigaCorpus || !raw.contains(";/O") && !raw.isEmpty();
    }

    private boolean filterSentence(NerSentence sentence) {
        return !(this.processingGigaCorpus && sentence.getTokens().size() <= 1 || this.filterVocabulary && !this.amrNlVocabulary.containsAll(sentence.getTokens()));
    }

    private String normalizeBeforeNer(String raw) {
        return raw.replaceAll("@:@", ":").replaceAll("@-@", "-");
    }

    private String normalize(String raw) {
        boolean hasId;
        String[] idRaw = raw.split("\t");
        boolean bl = hasId = idRaw.length == 2;
        if (hasId) {
            raw = idRaw[1];
        }
        String out = Arrays.stream(raw.split(" ")).filter(token -> {
            int index = token.indexOf("/");
            if (index <= 0) {
                return false;
            }
            String word = token.substring(0, index);
            return !word.equals("#") && !word.equals("^") && !word.equals("\\");
        }).map(token -> {
            int index = token.lastIndexOf("/");
            String word = token.substring(0, index);
            String ne = token.substring(index + 1);
            if (GigawordWrapper.isAllUpperCase(word)) {
                word = WordUtils.capitalizeFully((String)word);
            }
            switch (word) {
                case "-LRB-": 
                case "-LCB-": {
                    word = "(";
                    break;
                }
                case "-RRB-": 
                case "-RCB-": {
                    word = ")";
                    break;
                }
                case "``": 
                case "'": 
                case "''": {
                    word = "\"";
                    break;
                }
                case "_": {
                    word = "--";
                }
            }
            return word + "/" + ne;
        }).collect(Collectors.joining(" "));
        return hasId ? idRaw[0] + "\t" + out : out;
    }

    public static boolean isAllUpperCase(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void anonymizeEntity(List<String> multiNes, String namedEntity, Map<List<String>, AmrAnonymizationAlignment> identifiedNeMap, List<Integer> sentenceIds, List<String> sentence, List<String> anonSentence) {
        int anonSentencePos = anonSentence.size();
        AmrAnonymizationAlignment alignment = identifiedNeMap.get(multiNes);
        if (alignment != null) {
            sentence.addAll(multiNes);
            anonSentence.add(alignment.getAnonymizedToken());
            return;
        }
        String anonToken = "unk_0";
        switch (namedEntity) {
            case "PERSON": {
                anonToken = this.getNeAnnotation(multiNes, "person_name_");
                break;
            }
            case "ORGANIZATION": {
                anonToken = this.getNeAnnotation(multiNes, "organization_name_");
                break;
            }
            case "LOCATION": {
                anonToken = this.getNeAnnotation(multiNes, "location_name_");
                break;
            }
            case "NUMBER": {
                String numCand = multiNes.get(0);
                anonToken = NUMBER_PATTERN.matcher(numCand).find() || NUMBERS.contains(numCand) ? "num_" + numberCounter++ : null;
                break;
            }
            case "MISC": {
                anonToken = this.disambiguateMisc(multiNes);
                break;
            }
            case "TIME": 
            case "SET": 
            case "DURATION": 
            case "__MISSING_NER_ANNOTATION__": {
                anonToken = null;
                break;
            }
            case "ORDINAL": {
                anonToken = this.processOrdinal(multiNes, sentenceIds, identifiedNeMap, sentence, anonSentence, 0);
                break;
            }
            case "PERCENT": {
                anonToken = this.processPercent(multiNes, sentenceIds, identifiedNeMap, sentence, anonSentence);
                break;
            }
            case "MONEY": {
                anonToken = this.processMoney(multiNes, sentenceIds, identifiedNeMap, sentence, anonSentence);
                break;
            }
            case "DATE": {
                anonToken = this.processDate(multiNes, sentenceIds, identifiedNeMap, sentence, anonSentence);
                break;
            }
            default: {
                System.out.println("unexpected NE: " + namedEntity + " NL: " + String.join((CharSequence)" ", multiNes));
            }
        }
        if (anonToken != null) {
            sentence.addAll(multiNes);
            alignment = new AmrAnonymizationAlignment(anonToken, this.nlToAmr(multiNes), multiNes, sentenceIds, anonSentencePos);
            identifiedNeMap.put(multiNes, alignment);
            anonSentence.add(alignment.getAnonymizedToken());
        } else if (!(namedEntity.equals("ORDINAL") || namedEntity.equals("PERCENT") || namedEntity.equals("MONEY") || namedEntity.equals("DATE"))) {
            sentence.addAll(multiNes);
            anonSentence.addAll(multiNes);
        }
    }

    private String disambiguateMisc(List<String> multiNes) {
        String ne = this.amrNeAnonymization.get(String.join((CharSequence)" ", multiNes).toLowerCase());
        if (ne == null) {
            return null;
        }
        return ne + "_name_" + nameCounter++;
    }

    private String preprocessDates(String raw) {
        String[] ar = raw.split(" ");
        ArrayList<String> out = new ArrayList<String>();
        if (ar.length == 5 && ar[0].endsWith("DATE") && ar[1].equals("-/O") && ar[2].endsWith("DATE") && ar[3].equals("-/O") && ar[4].endsWith("DATE")) {
            return String.format("%s %s %s", ar[0], ar[2], ar[4]);
        }
        for (String tok : ar) {
            int index = tok.lastIndexOf("/");
            String word = tok.substring(0, index);
            String ne = tok.substring(index + 1);
            String format = "";
            String day = "";
            String month = "";
            String year = "";
            if (word.matches("[0-9]{6}")) {
                format = "f1";
                String firstDigit = word.substring(0, 1);
                year = (firstDigit.equals("0") ? "20" : "19") + word.substring(0, 2);
                month = word.substring(2, 4);
                day = word.substring(5, 6);
            } else if (word.matches("[0-9]{8}")) {
                format = "f2";
                year = word.substring(0, 4);
                month = word.substring(4, 6);
                day = word.substring(6, 8);
            } else if (word.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}")) {
                format = "f3";
                year = word.substring(0, 4);
                month = word.substring(5, 7);
                day = word.substring(8, 10);
            }
            if (!format.equals("")) {
                out.add(String.format("%s/DATE", day));
                out.add(String.format("%s/DATE", month));
                out.add(String.format("%s/DATE", year));
                continue;
            }
            out.add(tok);
        }
        return String.join((CharSequence)" ", out);
    }

    private String getNeAnnotation(List<String> multiNes, String defaultNe) {
        String ne;
        if (!this.useNeClusters && (ne = this.disambiguateMisc(multiNes)) != null) {
            return ne;
        }
        return defaultNe + nameCounter++;
    }

    private String processOrdinal(List<String> multiNes, List<Integer> sentenceIds, Map<List<String>, AmrAnonymizationAlignment> neMap, List<String> sentence, List<String> anonSentence, int posInMultiNe) {
        if (multiNes.size() == 1) {
            String word = multiNes.get(0);
            String anonToken = "ordinal-entity_num_" + numberCounter++;
            if (NUMBER_ORDINAL_PATTERN.matcher(word).find()) {
                Matcher m = ORDINAL_PATTERN.matcher(word);
                if (m.find()) {
                    String number = word.substring(0, m.start());
                    String suffix = word.substring(m.start());
                    ++nlIdOffset;
                    for (int i = posInMultiNe + 1; i < sentenceIds.size(); ++i) {
                        sentenceIds.set(i, sentenceIds.get(i) + 1);
                    }
                    AmrAnonymizationAlignment alignment = new AmrAnonymizationAlignment(anonToken, this.nlToAmr(Lists.newList((Object[])new String[]{number})), Lists.newList((Object[])new String[]{number}), Lists.newList((Object[])new Integer[]{sentenceIds.get(posInMultiNe)}), anonSentence.size());
                    neMap.put(Lists.newList((Object[])new String[]{number}), alignment);
                    sentence.add(number);
                    sentence.add(suffix);
                    anonSentence.add(anonToken);
                    anonSentence.add(suffix);
                }
            } else {
                if (!multiNes.get(0).equals("and") && !multiNes.get(0).equals("to")) {
                    AmrAnonymizationAlignment alignment = new AmrAnonymizationAlignment(anonToken, this.nlToAmr(multiNes), multiNes, sentenceIds, anonSentence.size());
                    neMap.put(multiNes, alignment);
                } else {
                    anonToken = word;
                }
                anonSentence.add(anonToken);
                sentence.add(word);
            }
        } else {
            for (int i = 0; i < multiNes.size(); ++i) {
                this.processOrdinal(Lists.newList((Object[])new String[]{multiNes.get(i)}), sentenceIds, neMap, sentence, anonSentence, i);
            }
        }
        return null;
    }

    private String processPercent(List<String> multiNes, List<Integer> sentenceIds, Map<List<String>, AmrAnonymizationAlignment> neMap, List<String> sentence, List<String> anonSentence) {
        boolean processedSuccesfully = false;
        for (int i = 0; i < multiNes.size(); ++i) {
            String word = multiNes.get(i);
            if (word.matches(".*\\d+.*")) {
                String anonToken = "percentage-entity_num_" + numberCounter++;
                this.processAlignment(anonToken, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                processedSuccesfully = true;
                continue;
            }
            anonSentence.add(word);
            sentence.add(word);
        }
        if (!processedSuccesfully) {
            // empty if block
        }
        return null;
    }

    private String processMoney(List<String> multiNes, List<Integer> sentenceIds, Map<List<String>, AmrAnonymizationAlignment> neMap, List<String> sentence, List<String> anonSentence) {
        boolean processedSuccesfully = false;
        for (int i = 0; i < multiNes.size(); ++i) {
            String word = multiNes.get(i);
            if (word.matches(".*\\d+.*") || NUMBERS.contains(word.toLowerCase())) {
                String anonToken = "monetary-quantity_num_" + numberCounter++;
                this.processAlignment(anonToken, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                processedSuccesfully = true;
                continue;
            }
            anonSentence.add(word);
            sentence.add(word);
        }
        if (!processedSuccesfully) {
            // empty if block
        }
        return null;
    }

    private String processDate(List<String> multiNes, List<Integer> sentenceIds, Map<List<String>, AmrAnonymizationAlignment> neMap, List<String> sentence, List<String> anonSentence) {
        boolean processedSuccesfully;
        boolean foundMonth = false;
        boolean foundYear = false;
        boolean foundDate = false;
        boolean foundCentury = false;
        boolean foundModifier = false;
        for (int i = 0; i < multiNes.size(); ++i) {
            String word = multiNes.get(i);
            if (word.matches(".*\\d+.*")) {
                String anonToken;
                if (word.length() == 4) {
                    int number;
                    if (NUMBER_ORDINAL_PATTERN.matcher(word).find()) {
                        String anonToken2 = "ordinal-entity_num_" + numberCounter++;
                        this.processAlignment(anonToken2, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                        foundCentury = true;
                        continue;
                    }
                    if (!word.matches("\\d{4}") || (number = Integer.valueOf(word).intValue()) <= 999 || number >= 10000) continue;
                    anonToken = "year_date-entity_" + dateCounter;
                    this.processAlignment(anonToken, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                    foundYear = true;
                    continue;
                }
                if (word.length() == 5 && word.endsWith("s")) {
                    String anonToken3 = "year_date-entity_" + dateCounter;
                    this.processAlignment(anonToken3, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                    foundYear = true;
                    continue;
                }
                if (!word.matches("\\d+") || word.length() != 2 && word.length() != 1) continue;
                try {
                    int number = Integer.valueOf(word);
                    if (foundMonth && number > 0 && number <= 31) {
                        anonToken = "day_date-entity_" + dateCounter;
                        this.processAlignment(anonToken, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                        foundDate = true;
                        continue;
                    }
                    if (number > 0 && number <= 12) {
                        anonToken = "month_date-entity_" + dateCounter;
                        this.processAlignment(anonToken, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                        foundMonth = true;
                        continue;
                    }
                    if (number <= 1 || number > 31) continue;
                    anonToken = "day_date-entity_" + dateCounter;
                    this.processAlignment(anonToken, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                    foundDate = true;
                }
                catch (Exception e) {
                    System.out.println("here");
                }
                continue;
            }
            if (WEEKDAYS.contains(word.toLowerCase())) {
                String anonToken = "weekday_date-entity_" + dateCounter;
                this.processAlignment(anonToken, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                foundDate = true;
                continue;
            }
            if (MONTHS.contains(word.toLowerCase())) {
                String anonToken = "month_name_date-entity_" + dateCounter;
                this.processAlignment(anonToken, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                foundMonth = true;
                continue;
            }
            if (DATE_MODIFIERS.contains(word.toLowerCase())) {
                String anonToken = "mod_date-entity";
                this.processAlignment(anonToken, sentenceIds.get(i), word, neMap, sentence, anonSentence);
                foundModifier = true;
                continue;
            }
            anonSentence.add(word);
            sentence.add(word);
        }
        if (foundYear || foundMonth || foundDate) {
            ++dateCounter;
        }
        boolean bl = processedSuccesfully = foundYear || foundMonth || foundDate || foundCentury || foundModifier;
        if (!processedSuccesfully) {
            // empty if block
        }
        return null;
    }

    private void processAlignment(String anonToken, int posInSentence, String partialNamedEntity, Map<List<String>, AmrAnonymizationAlignment> neMap, List<String> sentence, List<String> anonSentence) {
        AmrAnonymizationAlignment alignment = new AmrAnonymizationAlignment(anonToken, this.nlToAmr(Lists.newList((Object[])new String[]{partialNamedEntity})), Lists.newList((Object[])new String[]{partialNamedEntity}), Lists.newList((Object[])new Integer[]{posInSentence}), anonSentence.size());
        neMap.put(Lists.newList((Object[])new String[]{partialNamedEntity}), alignment);
        anonSentence.add(anonToken);
        sentence.add(partialNamedEntity);
    }

    private String nlToAmr(List<String> multiNes) {
        String key = String.join((CharSequence)" ", multiNes);
        return this.neNlAmrAlignments.getOrDefault(key.toLowerCase(), key);
    }
}

