/*
 * Decompiled with CFR 0.152.
 */
package util.metrics;

import edu.berkeley.nlp.mt.BatchBleuScorer;
import edu.cmu.meteor.scorer.MeteorConfiguration;
import edu.cmu.meteor.scorer.MeteorScorer;
import edu.cmu.meteor.scorer.MeteorStats;
import fig.basic.Fmt;
import fig.basic.Pair;
import fig.basic.StopWatchSet;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Properties;
import util.metrics.Hypothesis;
import util.utils.Utils;

public class GenerationPerformance {
    public static final DecimalFormat METRICS_FORMATTER = new DecimalFormat("#.####");
    private String experimentName;
    BatchBleuScorer bleuScorer;
    BatchBleuScorer bleuAnonymizedScorer;
    MeteorScorer meteorScorer;
    MeteorScorer meteorAnonymizedScorer;
    MeteorStats meteorAggStats;
    MeteorStats meteorAnonymizedAggStats;
    int total;
    int generated;

    public GenerationPerformance(String experimentName) {
        System.err.println("Loading Performance Metrics...");
        this.experimentName = experimentName;
        this.bleuScorer = new BatchBleuScorer();
        this.bleuAnonymizedScorer = new BatchBleuScorer();
        Properties meteorProperties = new Properties();
        meteorProperties.setProperty("paraFile", "lib/models/meteor-1.5/paraphrase-en.gz");
        meteorProperties.setProperty("norm", "false");
        this.meteorScorer = new MeteorScorer(new MeteorConfiguration(meteorProperties));
        this.meteorAggStats = new MeteorStats();
        this.meteorAnonymizedScorer = new MeteorScorer(new MeteorConfiguration(meteorProperties));
        this.meteorAnonymizedAggStats = new MeteorStats();
        this.total = 0;
        this.generated = 0;
    }

    public void reset() {
        this.bleuScorer = new BatchBleuScorer();
        this.bleuAnonymizedScorer = new BatchBleuScorer();
        this.meteorAggStats = new MeteorStats();
        this.meteorAnonymizedAggStats = new MeteorStats();
        this.total = 0;
        this.generated = 0;
    }

    public void add(Hypothesis reference, Hypothesis prediction) {
        if (reference == null) {
            return;
        }
        if (prediction.equals(Hypothesis.newEmptyHypothesis())) {
            ++this.total;
            return;
        }
        String predAnonStr = prediction.anonymizedToString().toLowerCase();
        String predStr = prediction.deAnonymizedToString().toLowerCase();
        String trueAnonStr = reference.anonymizedToString().toLowerCase();
        String trueStr = reference.deAnonymizedToString().toLowerCase();
        double bleuScore = this.bleuScorer.evaluateBleu(predStr, trueStr);
        double bleuAnonymizedScore = this.bleuAnonymizedScorer.evaluateBleu(predAnonStr, trueAnonStr);
        MeteorStats meteorStats = this.meteorScorer.getMeteorStats(predStr, trueStr);
        this.meteorAggStats.addStats(meteorStats);
        MeteorStats meteorAnonStats = this.meteorAnonymizedScorer.getMeteorStats(predAnonStr, trueAnonStr);
        this.meteorAnonymizedAggStats.addStats(meteorAnonStats);
        prediction.setMetric(Metrics.BLEU, bleuScore);
        prediction.setMetric(Metrics.BLEU_ANONYMIZED, bleuAnonymizedScore);
        prediction.setMetric(Metrics.METEOR, meteorStats.score);
        prediction.setMetric(Metrics.METEOR_ANONYMIZED, meteorAnonStats.score);
        ++this.total;
        ++this.generated;
    }

    public String output() {
        this.meteorScorer.computeMetrics(this.meteorAggStats);
        this.meteorAnonymizedScorer.computeMetrics(this.meteorAnonymizedAggStats);
        String out = String.format("Generation Experiment: %s\n\n", this.experimentName);
        out = out + String.format("Generated %s out of %s examples.\n", this.generated, this.total);
        out = out + "\n----------------------\n";
        out = out + "Performance statistics";
        out = out + "\n----------------------\n";
        out = out + StopWatchSet.getStats().toString();
        out = out + "\n\n-----------\n";
        out = out + "BLEU scores";
        out = out + "\n-----------\n";
        out = out + this.bleuScorer.getScore().toString();
        out = out + "\n\nAnonymized BLEU scores";
        out = out + "\n-----------\n";
        out = out + this.bleuAnonymizedScorer.getScore().toString();
        out = out + "\n\nMETEOR scores";
        out = out + "\n-------------";
        out = out + "\nTest words:\t\t" + this.meteorAggStats.testLength;
        out = out + "\nReference words:\t" + this.meteorAggStats.referenceLength;
        out = out + "\nChunks:\t\t\t" + this.meteorAggStats.chunks;
        out = out + "\nPrecision:\t\t" + this.meteorAggStats.precision;
        out = out + "\nRecall:\t\t\t" + this.meteorAggStats.recall;
        out = out + "\nf1:\t\t\t" + this.meteorAggStats.f1;
        out = out + "\nfMean:\t\t\t" + this.meteorAggStats.fMean;
        out = out + "\nFragmentation penalty:\t" + this.meteorAggStats.fragPenalty;
        out = out + "\n";
        out = out + "\nFinal score:\t\t" + Fmt.D((double)this.meteorAggStats.score);
        out = out + "\n-----------\n";
        out = out + "\n\nAnonymized METEOR scores";
        out = out + "\n-------------";
        out = out + "\nTest words:\t\t" + this.meteorAnonymizedAggStats.testLength;
        out = out + "\nReference words:\t" + this.meteorAnonymizedAggStats.referenceLength;
        out = out + "\nChunks:\t\t\t" + this.meteorAnonymizedAggStats.chunks;
        out = out + "\nPrecision:\t\t" + this.meteorAnonymizedAggStats.precision;
        out = out + "\nRecall:\t\t\t" + this.meteorAnonymizedAggStats.recall;
        out = out + "\nf1:\t\t\t" + this.meteorAnonymizedAggStats.f1;
        out = out + "\nfMean:\t\t\t" + this.meteorAnonymizedAggStats.fMean;
        out = out + "\nFragmentation penalty:\t" + this.meteorAnonymizedAggStats.fragPenalty;
        out = out + "\n";
        out = out + "\nFinal score:\t\t" + Fmt.D((double)this.meteorAnonymizedAggStats.score);
        return out;
    }

    public double getAccuracy() {
        this.meteorScorer.computeMetrics(this.meteorAggStats);
        return this.meteorAggStats.score;
    }

    public String getNameMetricsShortHeader(boolean multiBleu) {
        return "Experiment Name\tBLEU\tBLEU anonymized\tMETEOR\tMETEOR anonymized" + (multiBleu ? "\tMULTI-BLEU\n" : "\n");
    }

    public String[] getMetricsNames(boolean multiBleu) {
        String[] stringArray;
        if (multiBleu) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "BLEU";
            stringArray2[1] = "BLEU anonymized";
            stringArray2[2] = "METEOR";
            stringArray2[3] = "METEOR anonymized";
            stringArray = stringArray2;
            stringArray2[4] = "multiBLEU";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "BLEU";
            stringArray3[1] = "BLEU anonymized";
            stringArray3[2] = "METEOR";
            stringArray = stringArray3;
            stringArray3[3] = "METEOR anonymized";
        }
        return stringArray;
    }

    public Pair<String, double[]> getMetrics(double multiBleu) {
        this.meteorScorer.computeMetrics(this.meteorAggStats);
        this.meteorAnonymizedScorer.computeMetrics(this.meteorAnonymizedAggStats);
        if (multiBleu == -1.0) {
            return new Pair((Object)this.experimentName, (Object)new double[]{this.bleuScorer.getScore().getScore(), this.bleuAnonymizedScorer.getScore().getScore(), this.meteorAggStats.score, this.meteorAnonymizedAggStats.score});
        }
        return new Pair((Object)this.experimentName, (Object)new double[]{this.bleuScorer.getScore().getScore(), this.bleuAnonymizedScorer.getScore().getScore(), this.meteorAggStats.score, this.meteorAnonymizedAggStats.score, multiBleu});
    }

    public String getNameMetricsShort() {
        return this.getNameMetricsShort(null);
    }

    public String getNameMetricsShort(String multiBleuScore) {
        this.meteorScorer.computeMetrics(this.meteorAggStats);
        this.meteorAnonymizedScorer.computeMetrics(this.meteorAnonymizedAggStats);
        if (multiBleuScore == null) {
            return String.format("%s\t%s\t%s\t%s\t%s\n", this.experimentName, this.bleuScorer.getScore().getScore(), this.bleuAnonymizedScorer.getScore().getScore(), this.meteorAggStats.score, this.meteorAnonymizedAggStats.score);
        }
        return String.format("%s\t%s\t%s\t%s\t%s\t%s\n", this.experimentName, this.bleuScorer.getScore().getScore(), this.bleuAnonymizedScorer.getScore().getScore(), this.meteorAggStats.score, this.meteorAnonymizedAggStats.score, multiBleuScore);
    }

    public void writeToFile(String path) {
        Utils.write(path, this.output());
    }

    public void writeToFile(PrintWriter writer) {
        writer.println(this.output());
    }

    public static String stripPunctuationFromEnd(String sentence) {
        int lastId = sentence.lastIndexOf(".");
        return lastId == -1 ? sentence : sentence.substring(0, lastId).trim();
    }

    public void setExperimentName(String experimentName) {
        this.experimentName = experimentName;
    }

    public static enum Metrics {
        BLEU,
        BLEU_ANONYMIZED,
        METEOR,
        METEOR_ANONYMIZED,
        POS;

    }
}

