/*
 * Decompiled with CFR 0.152.
 */
package util.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import util.corpus.wrappers.AnonymizationAlignment;
import util.metrics.GenerationPerformance;
import util.metrics.Token;

public class Hypothesis {
    private static final Pattern anonymizedEntityMatcher = Pattern.compile(".+_[0-9]+$");
    private final List<Token> tokens = new ArrayList<Token>();
    private final List<Token> deanonymizedTokens = new ArrayList<Token>();
    private List<String> lastDeAnonymizedWord = new ArrayList<String>();
    private boolean endingWithEOS;
    private boolean startingWithSOS;
    private boolean lastTokenDeAnonymized;
    private final Map<GenerationPerformance.Metrics, Double> metrics = new HashMap<GenerationPerformance.Metrics, Double>();

    private Hypothesis() {
    }

    public Hypothesis(String raw) {
        this();
        this.tokens.addAll(Arrays.stream(raw.split(" ")).map(token -> new Token(-1, (String)token)).collect(Collectors.toList()));
    }

    public Hypothesis(String raw, String rawAnonymized) {
        this();
        this.deanonymizedTokens.addAll(Arrays.stream(rawAnonymized.split(" ")).map(token -> new Token(-1, (String)token)).collect(Collectors.toList()));
        this.tokens.addAll(Arrays.stream(rawAnonymized.split(" ")).map(token -> new Token(-1, (String)token)).collect(Collectors.toList()));
    }

    public boolean isStartingWithSOS() {
        return this.startingWithSOS;
    }

    public boolean isEndingWithEOS() {
        return this.endingWithEOS;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public double getMetric(GenerationPerformance.Metrics metric) {
        return this.metrics.getOrDefault((Object)metric, 0.0);
    }

    public void setMetric(GenerationPerformance.Metrics metric, double value) {
        this.metrics.put(metric, value);
    }

    public Token getLastToken() {
        return this.tokens.isEmpty() ? Token.emptyToken() : this.tokens.get(this.tokens.size() - 1);
    }

    public String getLastWord() {
        return this.getLastToken().getWord();
    }

    public List<String> getLastDeAnonymizedWord() {
        return this.lastDeAnonymizedWord;
    }

    public boolean isLastTokenDeAnonymized() {
        return this.lastTokenDeAnonymized;
    }

    public Token getFirstToken() {
        return this.tokens.isEmpty() ? Token.emptyToken() : this.tokens.get(0);
    }

    public void deAnonymize(Map<String, AnonymizationAlignment> map) {
        if (map == null || map.isEmpty()) {
            this.deanonymizedTokens.addAll(this.tokens);
        } else {
            for (int i = 0; i < this.tokens.size(); ++i) {
                AnonymizationAlignment alignment;
                Token token = this.tokens.get(i);
                boolean isAnonymizedFormattedDate = this.isAnonymizedFormattedDate(token);
                boolean isAnonymizedMonthDate = this.isAnonymizedMonthDate(token);
                AnonymizationAlignment anonymizationAlignment = isAnonymizedFormattedDate ? map.get(this.getAnonymizedDateNormalForm(token)) : (alignment = isAnonymizedMonthDate ? map.get(this.getAnonymizedMonthDateNormalForm(token)) : map.get(token.getWord()));
                if (alignment != null) {
                    if (isAnonymizedFormattedDate) {
                        if (i == 0) {
                            this.deanonymizedTokens.add(new Token(alignment.getCanonicalizedInputTokens().get(0)));
                            continue;
                        }
                        if (i < 1 || this.isAnonymizedFormattedDate(this.tokens.get(i - 1))) continue;
                        this.deanonymizedTokens.add(new Token(alignment.getCanonicalizedInputTokens().get(0)));
                        continue;
                    }
                    if (isAnonymizedMonthDate) {
                        this.deAnonymizeMonthDate(alignment);
                        continue;
                    }
                    List<String> nlTokens = map.get(token.getWord()).getCanonicalizedInputTokens();
                    nlTokens.stream().forEach(word -> this.deanonymizedTokens.add(new Token((String)word)));
                    continue;
                }
                this.deanonymizedTokens.add(new Token(token));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean deAnonymize(Token token, Map<String, AnonymizationAlignment> anonAlignments) {
        this.lastDeAnonymizedWord.clear();
        if (anonAlignments == null || anonAlignments.isEmpty()) {
            this.deanonymizedTokens.add(token);
            this.lastDeAnonymizedWord.add(token.getWord());
            return true;
        }
        AnonymizationAlignment alignment = anonAlignments.get(token.getWord());
        if (alignment != null) {
            anonAlignments.get(token.getWord()).getCanonicalizedInputTokens().stream().forEach(word -> {
                this.deanonymizedTokens.add(new Token((String)word));
                this.lastDeAnonymizedWord.add((String)word);
            });
            return true;
        }
        boolean isAnonymizedFormattedDate = this.isAnonymizedFormattedDate(token);
        boolean isAnonymizedMonthDate = this.isAnonymizedMonthDate(token);
        AnonymizationAlignment anonymizationAlignment = isAnonymizedFormattedDate ? anonAlignments.get(this.getAnonymizedDateNormalForm(token)) : (alignment = isAnonymizedMonthDate ? anonAlignments.get(this.getAnonymizedMonthDateNormalForm(token)) : null);
        if (alignment != null) {
            if (isAnonymizedFormattedDate) {
                if (this.length() == 1) {
                    String word2 = this.deAnonymizeFormattedDate(token, anonAlignments);
                    this.lastDeAnonymizedWord.add(word2);
                    return true;
                }
                if (this.length() <= 1) return false;
                if (this.isAnonymizedFormattedDate(this.tokens.get(this.length() - 2))) return false;
                String word3 = this.deAnonymizeFormattedDate(token, anonAlignments);
                this.lastDeAnonymizedWord.add(word3);
                return true;
            }
            if (isAnonymizedMonthDate) {
                String word4 = this.deAnonymizeMonthDate(alignment);
                this.lastDeAnonymizedWord.add(word4);
                return true;
            }
            this.lastDeAnonymizedWord.add(this.tokens.get(this.length() - 2).getWord());
            return true;
        }
        this.deanonymizedTokens.add(token);
        this.lastDeAnonymizedWord.add(token.getWord());
        if (isAnonymizedFormattedDate) return false;
        if (Hypothesis.isAnonymizedEntity(token.getWord())) return false;
        return true;
    }

    public void deAnonymizeFake() {
        this.deanonymizedTokens.addAll(this.tokens);
    }

    private String deAnonymizeFormattedDate(Token token, Map<String, AnonymizationAlignment> alignments) {
        String word;
        String[] info = this.getFormattedDateInfo(token);
        String srcDateEntityTemplate = "_date-entity_" + info[2];
        String year = this.getDatePartFromSrc("year" + srcDateEntityTemplate, alignments);
        String month = this.getDatePartFromSrc("month" + srcDateEntityTemplate, alignments);
        String day = this.getDatePartFromSrc("day" + srcDateEntityTemplate, alignments);
        switch (info[1]) {
            case "1": {
                word = String.format("%s%s%s", year.substring(2), month, day);
                break;
            }
            default: {
                word = String.format("%s%s%s", year, month, day);
                break;
            }
            case "3": {
                word = String.format("%s-%s-%s", year, month, day);
            }
        }
        this.deanonymizedTokens.add(new Token(word));
        return word;
    }

    private String getDatePartFromSrc(String part, Map<String, AnonymizationAlignment> alignments) {
        AnonymizationAlignment al = alignments.get(part);
        String value = al == null ? "00" : al.getCanonicalizedInputTokens().get(0);
        return value.length() == 1 ? "0" + value : value;
    }

    private String deAnonymizeMonthDate(AnonymizationAlignment alignment) {
        String word;
        switch (alignment.getCanonicalizedInputTokens().get(0)) {
            default: {
                word = "January";
                break;
            }
            case "2": {
                word = "Feburary";
                break;
            }
            case "3": {
                word = "March";
                break;
            }
            case "4": {
                word = "April";
                break;
            }
            case "5": {
                word = "May";
                break;
            }
            case "6": {
                word = "June";
                break;
            }
            case "7": {
                word = "July";
                break;
            }
            case "8": {
                word = "August";
                break;
            }
            case "9": {
                word = "September";
                break;
            }
            case "10": {
                word = "October";
                break;
            }
            case "11": {
                word = "November";
                break;
            }
            case "12": {
                word = "December";
            }
        }
        this.deanonymizedTokens.add(new Token(word));
        return word;
    }

    private boolean isAnonymizedFormattedDate(Token token) {
        return token.getWord().contains("date-entity") && token.getWord().contains("_f");
    }

    private boolean isAnonymizedMonthDate(Token token) {
        return token.getWord().contains("month_name_date-entity");
    }

    private String getAnonymizedDateNormalForm(Token token) {
        int index = token.getWord().indexOf("_f");
        return token.getWord().substring(0, index) + token.getWord().substring(index + 3);
    }

    private String getAnonymizedMonthDateNormalForm(Token token) {
        int index = token.getWord().lastIndexOf("_");
        return "month_date-entity" + token.getWord().substring(index);
    }

    private String[] getFormattedDateInfo(Token token) {
        int index = token.getWord().indexOf("_");
        String part = token.getWord().substring(0, index);
        index = token.getWord().indexOf("f");
        String format = token.getWord().substring(index + 1, index + 2);
        index = token.getWord().lastIndexOf("_");
        String id = token.getWord().substring(index + 1);
        return new String[]{part, format, id};
    }

    public int length() {
        return this.tokens.size();
    }

    public int deAnonymizedLength() {
        return this.deanonymizedTokens.size();
    }

    public String metricsToString() {
        return this.metrics.isEmpty() ? "" : String.format("[BLEU score : %s\tBLEU anonymized score : %s\tMETEOR score : %s\tMETEOR anonymized score : %s\tpos : %s]", GenerationPerformance.METRICS_FORMATTER.format(this.metrics.get((Object)GenerationPerformance.Metrics.BLEU)), GenerationPerformance.METRICS_FORMATTER.format(this.metrics.get((Object)GenerationPerformance.Metrics.BLEU_ANONYMIZED)), GenerationPerformance.METRICS_FORMATTER.format(this.metrics.get((Object)GenerationPerformance.Metrics.METEOR)), GenerationPerformance.METRICS_FORMATTER.format(this.metrics.get((Object)GenerationPerformance.Metrics.METEOR_ANONYMIZED)), GenerationPerformance.METRICS_FORMATTER.format(this.metrics.getOrDefault((Object)GenerationPerformance.Metrics.POS, 0.0)));
    }

    public String tokensToString(List<Token> tokens) {
        StringBuilder str = new StringBuilder();
        tokens.stream().forEach(token -> str.append(token).append(" "));
        return str.toString().trim();
    }

    public String tokensToStringCapitalizeFirstWord(List<Token> tokens) {
        StringBuilder str = new StringBuilder();
        if (tokens.size() > 0) {
            tokens.get(0).capitalize();
        }
        tokens.stream().forEach(token -> str.append(token).append(" "));
        return str.toString().trim();
    }

    public String deAnonymizedToString() {
        return this.tokensToString(this.deanonymizedTokens);
    }

    public String deAnonymizedCapitalizeFirstWordToString() {
        return this.tokensToStringCapitalizeFirstWord(this.deanonymizedTokens);
    }

    public String anonymizedToString() {
        return this.tokensToString(this.tokens);
    }

    public String toString() {
        return this.deAnonymizedToString();
    }

    public static Hypothesis newEmptyHypothesis() {
        return new Hypothesis();
    }

    public static boolean isAnonymizedEntity(String word) {
        return anonymizedEntityMatcher.matcher(word).matches();
    }
}

