/*
 * Decompiled with CFR 0.152.
 */
package util.metrics;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Token {
    private final int index;
    private String word;
    private final Set<String> EOS_CHARACTERS = new HashSet<String>(Arrays.asList(".", "?", "!"));

    public Token(int index, String word) {
        this.index = index;
        this.word = word;
    }

    public Token(String word) {
        this(-1, word);
    }

    public Token(Token tokenIn) {
        this(tokenIn.index, tokenIn.word);
    }

    public int getIndex() {
        return this.index;
    }

    public String getWord() {
        return this.word;
    }

    public boolean isEOSCharacter() {
        return this.EOS_CHARACTERS.contains(this.word);
    }

    public void capitalize() {
        this.word = Character.toUpperCase(this.word.charAt(0)) + this.word.substring(1);
    }

    public String toString() {
        return this.word;
    }

    public boolean equals(Object obj) {
        assert (obj instanceof Token);
        return ((Token)obj).index == this.index;
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + this.index;
        return hash;
    }

    public static Token emptyToken() {
        return new Token(-1, "");
    }
}

