/*
 * Decompiled with CFR 0.152.
 */
package util.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.Callable;
import util.server.NerServer;
import util.utils.NamedEntityRecognizer;

public class NerThread
implements Callable {
    private Socket socket = null;
    private final NamedEntityRecognizer ner;
    private final String client;
    private final boolean verbose;

    public NerThread(NamedEntityRecognizer ner, Socket socket, boolean verbose) {
        this.ner = ner;
        this.verbose = verbose;
        this.socket = socket;
        this.client = socket.getRemoteSocketAddress().toString();
        if (verbose) {
            NerServer.message("Established connection with client " + this.client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call() {
        String input = null;
        try {
            try (PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);
                 BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));){
                if (this.verbose) {
                    NerServer.message("Looks like the socket is" + (this.socket.isClosed() ? " not" : " ") + "open...");
                }
                do {
                    if (this.verbose) {
                        NerServer.message("Waiting for some input from client...");
                    }
                    input = in.readLine();
                    String result = this.ner.processToString(input) + "\n";
                    if (this.verbose) {
                        NerServer.message("Just predicted: " + result + " . Writing output to socket...");
                    }
                    out.write(result);
                    out.flush();
                } while (input != null && !input.equals("terminate_server") && !input.equals("terminate_client"));
            }
            catch (Exception e) {
                NerServer.error(e.getMessage());
            }
        }
        finally {
            try {
                this.socket.close();
                if (this.verbose) {
                    NerServer.message("Closed connection with client " + this.client);
                }
            }
            catch (IOException ex) {
                NerServer.error(ex.getMessage());
            }
        }
        if (input == null) return null;
        if (!input.equals("terminate_server")) return null;
        return "terminate_server";
    }
}

