/*
 * Decompiled with CFR 0.152.
 */
package util.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import util.utils.Settings;

public class Database {
    private Connection conn;
    private final Settings settings;

    public Database(Settings settings) {
        this.settings = settings;
        this.conn = this.getConnection();
    }

    private Connection getConnection() {
        String corpus = this.settings.getProperty("corpus");
        String dbms = this.settings.getProperty("dbms");
        if (dbms.equals("none")) {
            return null;
        }
        String driver = this.settings.getProperty(dbms + ".driver");
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Unable to find and load driver");
            System.exit(1);
        }
        String database = this.settings.getProperty(corpus + "." + dbms + ".database");
        String conString = this.settings.getProperty(String.format("%s.%s.url", corpus, dbms));
        try {
            this.conn = DriverManager.getConnection(conString);
            System.err.println("Established connection with " + database);
        }
        catch (SQLException e) {
            this.displaySQLErrors(e, "open connection");
        }
        return this.conn;
    }

    public void closeConnection() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            this.displaySQLErrors(e, "close connection");
        }
    }

    public void displaySQLErrors(SQLException e, String sql) {
        String out = sql + "\nSQLException: " + e.getMessage() + "\nSQLState: " + e.getSQLState() + "\nVendorError: " + e.getErrorCode();
        System.err.println(out);
    }

    public ResultSet executeQuery(String sql) {
        ResultSet rs = null;
        try {
            Statement stmt = this.conn.createStatement();
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            this.displaySQLErrors(e, sql);
        }
        return rs;
    }

    public int executeUpdate(String sql) {
        int rowcount = 0;
        try {
            Statement stmt = this.conn.createStatement();
            rowcount = stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.displaySQLErrors(e, sql);
            rowcount = -1;
        }
        return rowcount;
    }
}

