/*
 * Decompiled with CFR 0.152.
 */
package util.utils;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import util.Stemmer;
import util.utils.HistMap;

public class StemmerPosTagger {
    private final StanfordCoreNLP pipeline;
    private static final Pattern ANONYMIZED_ENTITY_MATCHER = Pattern.compile(".+_[0-9]+$");
    private final Map<String, HistMap<String>> stemPosToStrings;

    public StemmerPosTagger() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, pos, lemma");
        props.setProperty("tokenize.language", "Whitespace");
        props.setProperty("pos.model", "lib/models/pos-tagger/english-left3words-distsim.tagger");
        this.pipeline = new StanfordCoreNLP(props);
        this.stemPosToStrings = new HashMap<String, HistMap<String>>();
    }

    public Pair<List<String>, List<String>> process(String text, int length, boolean lemmaOnly) {
        Annotation document = new Annotation(text);
        this.pipeline.annotate(document);
        ArrayList tokens = new ArrayList();
        ((List)document.get(CoreAnnotations.SentencesAnnotation.class)).stream().forEach(sent -> ((List)sent.get(CoreAnnotations.TokensAnnotation.class)).stream().forEach(token -> tokens.add(token)));
        assert (tokens.size() == length) : "length mismatch. Found " + tokens.size() + ", was given " + length + " " + text;
        ArrayList stems = new ArrayList(length);
        ArrayList posTags = new ArrayList(length);
        tokens.stream().forEach(token -> {
            String word = ((String)token.get(CoreAnnotations.LemmaAnnotation.class)).toLowerCase();
            String stem = lemmaOnly ? word : Stemmer.stem((String)word);
            stems.add(stem);
            String posTag = stem.equals("@-@") ? ":" : (stem.startsWith("num_") ? "NUM" : (stem.contains("date-entity") ? "DATE" : (StemmerPosTagger.isAnonymizedEntity(stem) ? "NAME" : (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class))));
            posTags.add(posTag);
            String key = stem + "^" + posTag;
            HistMap<String> hist = this.stemPosToStrings.getOrDefault(key, new HistMap());
            hist.add(((String)token.get(CoreAnnotations.TextAnnotation.class)).toLowerCase());
            this.stemPosToStrings.put(key, hist);
        });
        return new Pair(stems, posTags);
    }

    public Pair<String, String> processToString(String text, int length) {
        Pair<List<String>, List<String>> stemsPosTags = this.process(text, length, false);
        return new Pair((Object)((List)stemsPosTags.getFirst()).stream().collect(Collectors.joining(" ")), (Object)((List)stemsPosTags.getSecond()).stream().collect(Collectors.joining(" ")));
    }

    public static boolean isAnonymizedEntity(String word) {
        return ANONYMIZED_ENTITY_MATCHER.matcher(word).matches();
    }

    public Map<String, HistMap<String>> getStemPosToStrings() {
        return this.stemPosToStrings;
    }

    public String stemPosToStringsToString() {
        return StemmerPosTagger.stemPosToStringsToString(this.stemPosToStrings);
    }

    public static String stemPosToStringsToString(Map<String, HistMap<String>> map) {
        StringBuilder str = new StringBuilder();
        map.forEach((k, v) -> str.append((String)k).append("\t").append(v.getEntriesSorted().stream().map(pair -> (String)pair.getFirst() + " : " + pair.getSecond()).collect(Collectors.joining(", "))).append("\n"));
        return str.toString();
    }

    public static void main(String[] args) {
        String text = "char\u00b7i\u00b7ty\u2002 \u2002 @/@ \u02c8t\u0283\u00e6r\u026ati Show Spelled [ char-i-tee ] Show IPA . noun , plural -@ ties .";
        StemmerPosTagger spt = new StemmerPosTagger();
        Pair<List<String>, List<String>> stemsPosTags = spt.process(text, 17, false);
        System.out.println("lemmata = " + stemsPosTags.getFirst());
        System.out.println("POS tags = " + stemsPosTags.getSecond());
        Pair<String, String> stemsPosTagsToString = spt.processToString(text, 17);
        System.out.println("lemmataToString = " + (String)stemsPosTagsToString.getFirst());
        System.out.println("POS tags toString = " + (String)stemsPosTagsToString.getSecond());
        System.out.println("\nThings will appear twice as we processed the same sentence twice above\n");
        System.out.println(spt.stemPosToStringsToString());
    }
}

