/*
 * Decompiled with CFR 0.152.
 */
package util.apps;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.swing.tree.TreeNode;
import util.corpus.wrappers.AmrAlignment;
import util.corpus.wrappers.AmrAnonymizationAlignment;
import util.corpus.wrappers.AmrLinearize;
import util.corpus.wrappers.AmrLinearizedSentence;
import util.corpus.wrappers.AmrNode;
import util.corpus.wrappers.AnonymizationAlignment;
import util.corpus.wrappers.Dictionaries;
import util.corpus.wrappers.GigawordWrapper;
import util.corpus.wrappers.NerSentence;
import util.utils.HistMap;
import util.utils.Settings;

public class AmrUtils {
    private final Settings settings;
    private Dictionaries dictionaries;
    private HistMap<Character> vars;
    private final String[] MONTH_NAMES = new String[]{"January", "Feburary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private String errorMessage = "Failed to parse.";

    public AmrUtils() {
        this.settings = new Settings();
        this.vars = new HistMap();
    }

    private void initDictionaries(Action action) {
        switch (action) {
            case ANONYMIZE_AMR: {
                this.dictionaries = new Dictionaries(this.settings, false, "amr", true);
                break;
            }
            case DEANONYMIZE_AMR: {
                this.dictionaries = new Dictionaries(this.settings, false, "amr", false);
                break;
            }
            case ANONYMIZE_TEXT: {
                this.dictionaries = new Dictionaries(this.settings, false, "anonymize", false);
            }
        }
    }

    private String anonymizeAmr(String input, boolean strippedAmr, boolean isInputFile) {
        if (!isInputFile) {
            return this.anonymizeSingleAmr(input, strippedAmr);
        }
        this.anonymizeFile(input, false, strippedAmr, null);
        return "";
    }

    private String deAnonymizeAmr(String input, boolean isInputFile) {
        if (!isInputFile) {
            return this.expandStrippedToFull(this.deAnonymizeSingle(input, false), true);
        }
        this.deAnonymizeFile(input, false);
        return "";
    }

    private String anonymizeText(String input, boolean isInputFile) {
        GigawordWrapper anonymizer = new GigawordWrapper(this.dictionaries.getAmrAnonymizationAlignments(), this.dictionaries.getNeNlAmrAlignments(), false);
        String out = "";
        if (isInputFile) {
            this.anonymizeFile(input, true, false, anonymizer);
        } else {
            out = this.anonymizeSingleText(input, anonymizer);
        }
        anonymizer.terminateNerClient();
        return out;
    }

    private String deAnonymizeText(String input, boolean isInputFile) {
        if (!isInputFile) {
            return this.deAnonymizeSingle(input, true);
        }
        this.deAnonymizeFile(input, true);
        return "";
    }

    private void anonymizeFile(String path, boolean isText, boolean strippedAmr, GigawordWrapper anonymizer) {
        try (PrintWriter anonymizedWriter = new PrintWriter(new FileOutputStream(path + ".anonymized"));
             PrintWriter alignmentsWriter = new PrintWriter(new FileOutputStream(path + ".alignments"));){
            Files.lines(Paths.get(path, new String[0])).forEach(line -> {
                String[] anonAligns = (isText ? this.anonymizeSingleText((String)line, anonymizer) : this.anonymizeSingleAmr((String)line, strippedAmr)).split("#");
                anonymizedWriter.println(anonAligns[0]);
                alignmentsWriter.println(anonAligns.length == 1 ? "" : anonAligns[1]);
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String anonymizeSingleAmr(String input, boolean strippedAmr) {
        AmrLinearizedSentence amrSentence;
        String id = "";
        if (input.isEmpty()) {
            return " # ";
        }
        if (strippedAmr) {
            input = this.normalizeAmr(input);
            List<String> tokens = Arrays.asList(input.split(" "));
            if (!this.checkBrackets(tokens = this.collateNames(tokens)) || !this.checkStructure(tokens)) return "FAILED_TO_PARSE#" + this.errorMessage;
            AmrNode root = new AmrNode("", tokens.get(0), "", ":TOP");
            this.readGraph(tokens, 1, root);
            amrSentence = new AmrLinearizedSentence(id, "", root, this.dictionaries, Collections.EMPTY_MAP, "dfs");
        } else {
            amrSentence = new AmrLinearizedSentence(id, "", Collections.EMPTY_MAP, "dfs");
            try {
                amrSentence.parseAmr(id, input, this.dictionaries);
            }
            catch (StringIndexOutOfBoundsException | EmptyStackException e) {
                return "FAILED_TO_PARSE#" + this.errorMessage;
            }
        }
        boolean failedToParse = amrSentence.getAmr().isFailedToParse();
        if (failedToParse) return "FAILED_TO_PARSE#" + this.errorMessage;
        amrSentence.applyAlignmentHeuristics(new HashMap<String, HistMap<String>>(), false, true, false);
        String alignments = this.alignmentsToString(amrSentence.getAnonymizationAlignments());
        return ((AmrLinearize)amrSentence.getAmr()).toStringBrackets(false, false, false, false) + "#" + alignments + "#" + this.toVisJs(((AmrLinearize)amrSentence.getAmr()).getGraph());
    }

    private String anonymizeSingleText(String input, GigawordWrapper anonymizer) {
        if ((input = this.normalizePunctuation(input)).isEmpty() || input.equals("?")) {
            return " # ";
        }
        NerSentence nerSentence = anonymizer.anonymizeRaw(input);
        this.normalizeAnonymizedSentence(nerSentence);
        return nerSentence.toStringNlAnonOnly() + "#" + this.alignmentsToString(nerSentence.getAnonymizationAlignments());
    }

    private void deAnonymizeFile(String path, boolean isText) {
        try (PrintWriter deAnonymizedWriter = new PrintWriter(new FileOutputStream(path + ".pred"));){
            String anonymizedPath = new File(path + ".pred.anonymized").exists() ? path + ".pred.anonymized" : path + ".anonymized";
            AmrUtils.zip(Files.lines(Paths.get(anonymizedPath, new String[0])), Files.lines(Paths.get(path + ".alignments", new String[0])), (a, b) -> a + "#" + b).forEach(l -> deAnonymizedWriter.println(isText ? this.deAnonymizeSingle((String)l, true) : this.expandStrippedToFull(this.deAnonymizeSingle((String)l, false), false)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String deAnonymizeSingle(String input, boolean isText) {
        String[] inputAligns = input.split("#");
        if (inputAligns.length != 0 && !inputAligns[0].isEmpty() && !inputAligns[0].equals(" ")) {
            if (inputAligns.length > 1) {
                Map<String, AnonymizationAlignment> alignments = this.getAlignmentsFromString(inputAligns[1]);
                return isText ? this.deAnonymizeSingleText(inputAligns[0], alignments) : this.deAnonymizeSingleAmr(inputAligns[0], alignments);
            }
            if (isText) {
                return inputAligns[0];
            }
            return this.deAnonymizeSingleAmr(inputAligns[0], Collections.EMPTY_MAP);
        }
        return "FAILED_TO_PARSE#" + this.errorMessage;
    }

    private String deAnonymizeSingleText(String input, Map<String, AnonymizationAlignment> map) {
        ArrayList<String> deanonymizedTokens = new ArrayList<String>();
        String[] tokens = input.split(" ");
        for (int i = 0; i < tokens.length; ++i) {
            AnonymizationAlignment alignment;
            String token = tokens[i];
            boolean isAnonymizedFormattedDate = this.isAnonymizedFormattedDate(token);
            boolean isAnonymizedMonthDate = this.isAnonymizedMonthDate(token);
            AnonymizationAlignment anonymizationAlignment = isAnonymizedFormattedDate ? map.get(this.getAnonymizedDateNormalForm(token)) : (alignment = isAnonymizedMonthDate ? map.get(this.getAnonymizedMonthDateNormalForm(token)) : map.get(token));
            if (alignment != null) {
                if (isAnonymizedFormattedDate) {
                    if (i == 0) {
                        deanonymizedTokens.add(alignment.getCanonicalizedInputTokens().get(0));
                        continue;
                    }
                    if (i < 1 || this.isAnonymizedFormattedDate(tokens[i - 1])) continue;
                    deanonymizedTokens.add(alignment.getCanonicalizedInputTokens().get(0));
                    continue;
                }
                if (isAnonymizedMonthDate) {
                    deanonymizedTokens.add(this.deAnonymizeMonthDate(alignment));
                    continue;
                }
                List<String> nlTokens = map.get(token).getCanonicalizedInputTokens();
                nlTokens.stream().forEach(word -> deanonymizedTokens.add((String)word));
                continue;
            }
            deanonymizedTokens.add(token);
        }
        return String.join((CharSequence)" ", deanonymizedTokens);
    }

    private String deAnonymizeSingleAmr(String input, Map<String, AnonymizationAlignment> map) {
        input = this.normalizeAmr(input);
        List<String> tokens = Arrays.asList(input.split(" "));
        if (this.isValidAmr(input)) {
            return String.join((CharSequence)" ", this.deAnonymizeAmrTokens(tokens, map));
        }
        return "FAILED_TO_PARSE#" + this.errorMessage;
    }

    private boolean isValidAmr(String input) {
        List<String> tokens = Arrays.asList(input.split(" "));
        return this.checkBrackets(tokens) && this.checkStructure(tokens);
    }

    private String expandStrippedToFull(String input, boolean outputVisJs) {
        if (input.isEmpty() || input.equals(" ")) {
            return " # ";
        }
        if (input.startsWith("FAILED_TO_PARSE")) {
            return input;
        }
        this.vars = new HistMap();
        String id = "";
        List<String> tokens = Arrays.asList(input.split(" "));
        String rootConcept = tokens.get(0);
        AmrNode root = new AmrNode(this.getVar(rootConcept), rootConcept, "", ":TOP");
        this.readGraph(tokens, 1, root);
        AmrLinearizedSentence amrSentence = new AmrLinearizedSentence(id, "", root, this.dictionaries, Collections.EMPTY_MAP, "dfs");
        boolean failedToParse = amrSentence.getAmr().isFailedToParse();
        if (!failedToParse) {
            return root.pp().trim() + (outputVisJs ? "#" + this.toVisJs(((AmrLinearize)amrSentence.getAmr()).getGraph()) : "");
        }
        return "FAILED_TO_PARSE#" + this.errorMessage;
    }

    private List<String> deAnonymizeAmrTokens(List<String> tokens, Map<String, AnonymizationAlignment> map) {
        ArrayList<String> out = new ArrayList<String>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (token.contains("name_")) {
                out.addAll(this.processName(token, i == 0 || !tokens.get(i - 1).equals("("), map));
                continue;
            }
            if (token.contains("num_")) {
                if (token.contains("quantity")) {
                    out.add(":quant");
                } else if (token.contains("entity")) {
                    out.add(":value");
                }
                out.add(this.getAmrValue(token, map).get(0).split(" ")[0]);
                continue;
            }
            if (token.contains("date-entity_")) {
                out.add(":" + token.substring(0, token.indexOf("_")));
                out.add(this.getAmrValue(token, map).get(0).split(" ")[0]);
                continue;
            }
            out.add(token);
        }
        return out;
    }

    private List<String> processName(String node, boolean encloseInBrackets, Map<String, AnonymizationAlignment> map) {
        ArrayList<String> out = new ArrayList<String>();
        String headNode = node.substring(0, node.indexOf("_"));
        if (encloseInBrackets) {
            out.add("(");
        }
        out.add(headNode);
        out.add(":name");
        out.add("(");
        out.add("name");
        String[] value = this.getAmrValue(node, map).get(0).split(" ");
        for (int i = 1; i <= value.length; ++i) {
            out.add(":op" + i);
            out.add("\"" + value[i - 1] + "\"");
        }
        out.add(")");
        if (encloseInBrackets) {
            out.add(")");
        }
        return out;
    }

    private List<String> getAmrValue(String key, Map<String, AnonymizationAlignment> map) {
        int lastIndex;
        AnonymizationAlignment alignment = map.get(key);
        if (alignment != null) {
            return this.anonymizationAlignmentToString(alignment);
        }
        if (key.startsWith("month_date-entity")) {
            String num = key.substring(key.lastIndexOf("_") + 1);
            alignment = map.get("month_name_date-entity_" + num);
            if (alignment != null) {
                return this.anonymizationAlignmentToString(alignment);
            }
        }
        String keyWithoutNum = key.substring(0, (lastIndex = key.lastIndexOf("_")) != -1 ? lastIndex : key.length());
        for (Map.Entry<String, AnonymizationAlignment> entries : map.entrySet()) {
            if (!entries.getKey().startsWith(keyWithoutNum)) continue;
            return this.anonymizationAlignmentToString(entries.getValue());
        }
        return Arrays.asList("N-A");
    }

    private List<String> anonymizationAlignmentToString(AnonymizationAlignment alignment) {
        ArrayList<String> value = new ArrayList<String>();
        List<String> nlTokens = alignment.getCanonicalizedInputTokens();
        nlTokens.stream().forEach(word -> value.add(this.normalizeNode((String)word)));
        return value;
    }

    private String normalizeNode(String node) {
        return node.replaceAll("/", "-").replaceAll(":", "-").replaceAll("~", "-").replaceAll("\"", "a").replaceAll("\\(", "[");
    }

    private String normalizePunctuation(String input) {
        Charset ascii = Charset.forName("ISO-8859-1");
        input = new String(input.getBytes(ascii), ascii);
        return input.replaceAll("!", ".").replaceAll("#", "-");
    }

    private String normalizeAmr(String input) {
        input = input.replaceAll("\n", " ").replaceAll("\\p{Space}+", " ");
        input = input.replaceAll("\\(", "( ").replaceAll("\\)", " )").replaceAll(" +", " ");
        return input;
    }

    private void normalizeAnonymizedSentence(NerSentence input) {
        input.setAnonymizedSentence(input.getAnonymizedSentence().replaceAll("`", "'").replaceAll("#", "-"));
    }

    private Map<String, AnonymizationAlignment> getAlignmentsFromString(String inputAligns) {
        return Stream.of(inputAligns.split("\t")).map(str -> {
            String[] anonAmr = str.split("[|]{3}");
            return new AmrAnonymizationAlignment(anonAmr[0], anonAmr[1]);
        }).collect(Collectors.toMap(AmrAnonymizationAlignment::getAnonymizedToken, Function.identity(), (oldVal, newVal) -> oldVal));
    }

    private String alignmentsToString(Collection<AmrAnonymizationAlignment> alignments) {
        return alignments.stream().map(a -> a.getAnonymizedToken() + "|||" + a.getRawAmrToken()).collect(Collectors.joining("\t"));
    }

    private List<String> collateNames(List<String> words) {
        ArrayList<String> out = new ArrayList<String>(words.size());
        block0: for (int i = 0; i < words.size(); ++i) {
            String word = words.get(i);
            out.add(word);
            if (!word.equals(":name")) continue;
            ArrayList<String> name = new ArrayList<String>();
            for (int j = i + 1; j < words.size(); ++j) {
                name.add(words.get(j));
                if (!words.get(j).endsWith("\"")) continue;
                i = j;
                out.add("(");
                out.add("name");
                out.add(":op1");
                out.add(String.join((CharSequence)"_", name));
                out.add(")");
                continue block0;
            }
        }
        return out;
    }

    private boolean checkBrackets(List<String> words) {
        int openBrackets = 0;
        boolean correct = true;
        for (String word : words) {
            if (this.isOpenBracket(word)) {
                ++openBrackets;
            } else if (this.isCloseBracket(word)) {
                --openBrackets;
            }
            if (openBrackets >= 0) continue;
            correct = false;
            this.errorMessage = "More closing than opening brackets.";
            break;
        }
        if (!correct) {
            this.errorMessage = "Number of opening and closing brackets doesn't match.";
        }
        return correct && openBrackets == 0;
    }

    private boolean checkStructure(List<String> words) {
        boolean correct = true;
        int length = words.size();
        for (int i = 0; i < length; ++i) {
            String word = words.get(i);
            if (i < length - 1) {
                String nextWord = words.get(i + 1);
                if (this.isConcept(word)) {
                    if (this.isSpecialConcept(word) && this.isSpecialConcept(nextWord)) continue;
                    if (this.isConcept(nextWord)) {
                        this.errorMessage = "Two concepts in a row.";
                        correct = false;
                        break;
                    }
                    if (this.isOpenBracket(nextWord)) {
                        this.errorMessage = "Opening bracket after concept.";
                        correct = false;
                        break;
                    }
                } else if (this.isRole(word)) {
                    if (i == 0) {
                        this.errorMessage = "Role at the beginning of the graph.";
                        correct = false;
                        break;
                    }
                    if (this.isRole(nextWord)) {
                        this.errorMessage = "Two roles in a row.";
                        correct = false;
                        break;
                    }
                    if (this.isCloseBracket(nextWord)) {
                        this.errorMessage = "Closing bracket after role.";
                        correct = false;
                        break;
                    }
                } else if (this.isOpenBracket(word)) {
                    if (!this.isConcept(nextWord)) {
                        this.errorMessage = "Not concept after open bracket.";
                        correct = false;
                        break;
                    }
                } else if (this.isCloseBracket(word)) {
                    if (this.isConcept(nextWord)) {
                        this.errorMessage = "Concept after closing bracket (should be closing bracket or role).";
                        correct = false;
                        break;
                    }
                    if (this.isOpenBracket(nextWord)) {
                        this.errorMessage = "Opening bracket after closing bracket (should be a role, or closing bracket instead).";
                        correct = false;
                        break;
                    }
                }
            }
            if (i != length - 1 || !this.isRole(word)) continue;
            this.errorMessage = "Role at the end of the graph.";
            correct = false;
            break;
        }
        return correct;
    }

    private int readGraph(List<String> graph, int pos, AmrNode parent) {
        while (pos < graph.size()) {
            AmrAlignment conceptAlignment;
            String nextToken;
            String currentToken = graph.get(pos);
            if (this.isCloseBracket(currentToken)) {
                return pos;
            }
            String role = currentToken;
            AmrAlignment roleAlignment = new AmrAlignment(AmrAlignment.TokenType.ROLE, role);
            if (this.isConcept(nextToken = graph.get(++pos))) {
                conceptAlignment = new AmrAlignment(AmrAlignment.TokenType.CONCEPT, nextToken);
                parent.add(new AmrNode(this.getVar(nextToken), nextToken, "", role, conceptAlignment, roleAlignment));
            } else if (this.isOpenBracket(nextToken)) {
                int nextPos;
                conceptAlignment = new AmrAlignment(AmrAlignment.TokenType.CONCEPT, graph.get(pos + 1));
                AmrNode subTreeParent = new AmrNode(this.getVar(graph.get(pos + 1)), graph.get(pos + 1), "", role, conceptAlignment, roleAlignment);
                parent.add(subTreeParent);
                pos = nextPos = this.readGraph(graph, pos + 2, subTreeParent);
            } else {
                this.errorMessage = "Couldn't convert to full AMR graph.";
            }
            ++pos;
        }
        return pos;
    }

    private String toVisJs(AmrNode graph) {
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<String> edges = new ArrayList<String>();
        HashMap<AmrNode, Integer> ids = new HashMap<AmrNode, Integer>();
        Enumeration<TreeNode> traversal = graph.preorderEnumeration();
        int id = 0;
        while (traversal.hasMoreElements()) {
            AmrNode node = (AmrNode)traversal.nextElement();
            int nodeId = ids.getOrDefault(node, ++id);
            if (nodeId == id) {
                ids.put(node, nodeId);
                nodes.add(String.format("{\"id\":%s,\"label\":\"%s\"}", nodeId, node.getWord().replaceAll("\"", "\\\\\"")));
            }
            if (node.getParent() == null) continue;
            edges.add(String.format("{\"from\":%s,\"to\":%s,\"label\":\"%s\"}", ids.get((AmrNode)node.getParent()), nodeId, node.getRole()));
        }
        return "\"nodes\":[" + String.join((CharSequence)",", nodes) + "],\"edges\":[" + String.join((CharSequence)",", edges) + "]";
    }

    private List<String> getConceptStructure(String node) {
        if (node.equals("-") || node.matches("[0-9]+") || node.startsWith("\"") && node.endsWith("\"")) {
            return new ArrayList<String>(Arrays.asList(node));
        }
        return new ArrayList<String>(Arrays.asList(this.getVar(node), "/", node));
    }

    private String getVar(String token) {
        Character firstChar = Character.valueOf(token.charAt(0));
        this.vars.add(firstChar);
        int freq = this.vars.getFrequency(firstChar);
        return String.valueOf(firstChar) + (freq > 1 ? Integer.valueOf(freq) : "");
    }

    private boolean isRole(String word) {
        return word.charAt(0) == ':';
    }

    private boolean isOpenBracket(String word) {
        return word.charAt(0) == '(';
    }

    private boolean isCloseBracket(String word) {
        return word.charAt(0) == ')';
    }

    private boolean isBracket(String word) {
        return this.isOpenBracket(word) || this.isCloseBracket(word);
    }

    private boolean isConcept(String word) {
        return !this.isRole(word) && !this.isOpenBracket(word) && !this.isCloseBracket(word);
    }

    private boolean isSpecialConcept(String word) {
        return word.contains("date-entity") || word.contains("-quantity") || word.contains("-entity");
    }

    private boolean isAnonymizedFormattedDate(String token) {
        return token.contains("date-entity") && token.contains("_f");
    }

    private boolean isAnonymizedMonthDate(String token) {
        return token.contains("month_name_date-entity");
    }

    private String getAnonymizedDateNormalForm(String token) {
        int index = token.indexOf("_f");
        return token.substring(0, index) + token.substring(index + 3);
    }

    private String getAnonymizedMonthDateNormalForm(String token) {
        int index = token.lastIndexOf("_");
        return "month_date-entity" + token.substring(index);
    }

    private String deAnonymizeMonthDate(AnonymizationAlignment alignment) {
        int month;
        try {
            month = Integer.valueOf(alignment.getCanonicalizedInputTokens().get(0)) - 1;
        }
        catch (NumberFormatException e) {
            month = 0;
        }
        return this.MONTH_NAMES[month];
    }

    private static <A, B, C> Stream<C> zip(Stream<? extends A> a, Stream<? extends B> b, final BiFunction<? super A, ? super B, ? extends C> zipper) {
        final Iterator iteratorA = a.iterator();
        final Iterator iteratorB = b.iterator();
        Iterable iterable = () -> new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return iteratorA.hasNext() && iteratorB.hasNext();
            }

            @Override
            public C next() {
                return zipper.apply(iteratorA.next(), iteratorB.next());
            }
        };
        return StreamSupport.stream(iterable.spliterator(), a.isParallel() || b.isParallel());
    }

    public static void main(String[] args) {
        String usage = "Usage: java_exec anonymizeAmrStripped|anonymizeAmrFull|deAnonymizeAmr|anonymizeText|deAnonymizeText input_file[true|false] input";
        if (args.length != 3) {
            System.out.println(usage);
            System.exit(1);
        }
        boolean strippedAmr = false;
        Action action = null;
        switch (args[0]) {
            case "anonymizeAmrStripped": {
                strippedAmr = true;
                action = Action.ANONYMIZE_AMR;
                break;
            }
            case "anonymizeAmrFull": {
                strippedAmr = false;
                action = Action.ANONYMIZE_AMR;
                break;
            }
            case "deAnonymizeText": {
                action = Action.DEANONYMIZE_TEXT;
                break;
            }
            case "anonymizeText": {
                action = Action.ANONYMIZE_TEXT;
                break;
            }
            case "deAnonymizeAmr": {
                action = Action.DEANONYMIZE_AMR;
                break;
            }
            default: {
                System.out.println(usage);
                System.exit(1);
            }
        }
        boolean inputIsFile = Boolean.valueOf(args[1]);
        String input = args[2].trim();
        AmrUtils agas = new AmrUtils();
        agas.initDictionaries(action);
        switch (action) {
            case ANONYMIZE_AMR: {
                System.out.println(agas.anonymizeAmr(input, strippedAmr, inputIsFile));
                break;
            }
            case DEANONYMIZE_AMR: {
                System.out.println(agas.deAnonymizeAmr(input, inputIsFile));
                break;
            }
            case ANONYMIZE_TEXT: {
                System.out.println(agas.anonymizeText(input, inputIsFile));
                break;
            }
            case DEANONYMIZE_TEXT: {
                System.out.println(agas.deAnonymizeText(input, inputIsFile));
            }
        }
    }

    private static enum Action {
        ANONYMIZE_AMR,
        DEANONYMIZE_AMR,
        ANONYMIZE_TEXT,
        DEANONYMIZE_TEXT;

    }
}

