/*
 * Decompiled with CFR 0.152.
 */
package util.apps;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import util.corpus.Corpus;
import util.utils.Database;
import util.utils.Settings;
import util.utils.Utils;

public abstract class Application {
    protected Database db;
    protected Settings settings = new Settings();
    protected String corpusString;
    protected Corpus corpus;

    public Application() {
        this.db = new Database(this.settings);
        this.corpusString = this.settings.getProperty("corpus");
        this.init();
    }

    private void init() {
        try {
            Constructor<?> cons = Class.forName("util.corpus." + Utils.toCamelCasing(this.corpusString) + "Corpus").getConstructor(Settings.class, Database.class, String.class);
            this.corpus = (Corpus)cons.newInstance(this.settings, this.db, this.corpusString);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.err.println(ex.getCause());
            ex.printStackTrace(System.err);
        }
    }

    public abstract void execute();
}

