/*
 * Decompiled with CFR 0.152.
 */
package util.corpus;

import fig.basic.IOUtils;
import fig.basic.Indexer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import util.corpus.AbstractCorpus;
import util.corpus.wrappers.AmrAnonymizationAlignment;
import util.corpus.wrappers.AmrLinearizedSentence;
import util.corpus.wrappers.AmrSentence;
import util.corpus.wrappers.AmrWrapper;
import util.corpus.wrappers.Dictionaries;
import util.corpus.wrappers.JamrAlignment;
import util.utils.Database;
import util.utils.HistMap;
import util.utils.Settings;
import util.utils.StemmerPosTagger;
import util.utils.Utils;

public class AmrCorpus
extends AbstractCorpus {
    final String outputFilename;
    final String[] inputPaths;
    final String exportType;
    final String linearizeType;
    private final Dictionaries dictionaries;
    private Map<String, Map<String, JamrAlignment>> jamrAlignments;
    private Indexer<String> amrVocabulary;
    private Indexer<String> nlVocabulary;
    private Map<String, HistMap<String>> amrAlignedNlVocabulary;
    private boolean augmentLexicon;
    private final boolean deAnonymizeOutput;
    private final boolean useNeClusters;
    private final boolean lowerCaseOutput;
    private final boolean includeReentrances;
    private final boolean reentrancesRoles;
    private final boolean outputBrackets;
    private final boolean reshuffleChildren;
    private final boolean markLeaves;
    private final boolean concatBracketsWithRoles;
    private final boolean outputSense;
    private final int amrThres;
    private final int nlThres;
    private final StemmerPosTagger stemmerPostagger;

    public AmrCorpus(Settings settings, Database db, String corpus) {
        super(settings, db, corpus);
        String basePath = settings.getProperty(corpus + ".down.base");
        int i = 0;
        String[] inputs = settings.getProperty(corpus + ".down.input").split(",");
        this.inputPaths = new String[inputs.length];
        for (String tok : inputs) {
            this.inputPaths[i++] = basePath + tok;
        }
        this.dictionaries = new Dictionaries(settings, true, "amr", false);
        this.outputFilename = settings.getProperty(corpus + ".down.output");
        this.exportType = settings.getProperty(corpus + ".export.type");
        this.linearizeType = settings.getProperty(corpus + ".linearize.type");
        this.amrThres = Integer.valueOf(settings.getProperty(corpus + ".threshold.amr"));
        this.nlThres = Integer.valueOf(settings.getProperty(corpus + ".threshold.nl"));
        this.stemmerPostagger = new StemmerPosTagger();
        this.deAnonymizeOutput = settings.getProperty(corpus + ".down.deAnonymize").equals("true");
        this.useNeClusters = settings.getProperty(corpus + ".down.useNeClusters").equals("true");
        this.includeReentrances = settings.getProperty(corpus + ".down.includeReentrances").equals("true");
        this.reentrancesRoles = settings.getProperty(corpus + ".down.reentrancesRoles").equals("true");
        this.outputBrackets = settings.getProperty(corpus + ".down.outputBrackets").equals("true");
        this.reshuffleChildren = settings.getProperty(corpus + ".down.reshuffleChildren").equals("true");
        this.markLeaves = settings.getProperty(corpus + ".down.markLeaves").equals("true");
        this.lowerCaseOutput = settings.getProperty(corpus + ".down.lowercase").equals("true");
        this.concatBracketsWithRoles = settings.getProperty(corpus + ".down.concatBracketsWithRoles").equals("true");
        this.outputSense = settings.getProperty(corpus + ".down.outputSense").equals("true");
    }

    @Override
    public void preprocess() {
        ArrayList[] amrSentences = new ArrayList[this.inputPaths.length];
        if (this.exportType.equals("linearize")) {
            this.preLoadVocabularies();
            this.preLoadLinearizeDictionaries();
        }
        int i = 0;
        for (String inputPath : this.inputPaths) {
            amrSentences[i] = new ArrayList();
            for (String inputFile : this.listTxtFiles(inputPath)) {
                System.out.println("Processing file " + inputFile);
                String[] lines = Utils.readLines(inputPath + "/" + inputFile);
                AmrWrapper annotatorFile = new AmrWrapper(this.getLinearizeType(), this.isLinearize(), this.getJamrAlignments(), this.getDictionaries(), lines);
                annotatorFile.parse();
                amrSentences[i].addAll(annotatorFile.getAmrSentences());
            }
            ++i;
        }
        try {
            switch (this.exportType) {
                case "linearize": {
                    this.writeLinearize(amrSentences);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }
        }
        catch (IOException | UnsupportedOperationException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    private void preLoadLinearizeDictionaries() {
        this.jamrAlignments = this.readJamrAlignments(this.settings.getProperty(this.corpus + ".jamr.alignments"));
        this.amrAlignedNlVocabulary = new HashMap<String, HistMap<String>>();
    }

    private void preLoadVocabularies() {
        this.amrVocabulary = new Indexer();
        this.amrVocabulary.add((Object)"<unk>");
        this.amrVocabulary.add((Object)"<s>");
        this.amrVocabulary.add((Object)"</s>");
        this.nlVocabulary = new Indexer();
        this.nlVocabulary.add((Object)"<unk>");
        this.nlVocabulary.add((Object)"<s>");
        this.nlVocabulary.add((Object)"</s>");
    }

    private void writeLinearize(List<AmrSentence>[] amrSentences) throws IOException {
        int i = 0;
        for (String infix : this.settings.getProperty(this.corpus + ".down.input").split(",")) {
            HistMap<String> amrHist = new HistMap<String>();
            HistMap<String> nlHist = new HistMap<String>();
            HashMap<String, HistMap<String>> amrNlAlignmentsMap = new HashMap<String, HistMap<String>>();
            this.augmentLexicon = infix.equals("training");
            boolean useNlOov = !this.augmentLexicon && !infix.endsWith("test");
            PrintWriter rawIdsAmrWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-raw-amr-ids.txt", this.outputFilename, infix)));
            PrintWriter linearAmrAnonymizedNlPairWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-%s-linear.txt", this.outputFilename, infix, this.linearizeType)));
            PrintWriter anonymizedAlignmentsWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-anonymized-alignments.txt", this.outputFilename, infix)));
            PrintWriter jamrAlignmentsWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-jamr-alignments.txt", this.outputFilename, infix)));
            PrintWriter contentAlignmentsWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-content-alignments.txt", this.outputFilename, infix)));
            PrintWriter amrNlAlignmentsSeqWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-amr-nl-alignments-seq.txt", this.outputFilename, infix)));
            PrintWriter propositionAmrAnonymizedNlPairWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-propositions.txt", this.outputFilename, infix)));
            PrintWriter nlWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-nl.txt", this.outputFilename, infix)));
            PrintWriter realIdToNumIdMap = new PrintWriter(new FileOutputStream(String.format("%s%s-ids-map.txt", this.outputFilename, infix)));
            PrintWriter amrVocabWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-amr-vocab.txt", this.outputFilename, infix)));
            PrintWriter nlVocabWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-nl-vocab.txt", this.outputFilename, infix)));
            System.out.println("Total number of sentences (before alignment heuristics): " + amrSentences[i].size());
            for (AmrSentence amrSentence : amrSentences[i]) {
                ((AmrLinearizedSentence)amrSentence).applyAlignmentHeuristics(amrNlAlignmentsMap, this.deAnonymizeOutput, this.includeReentrances, this.reentrancesRoles);
                if (this.augmentLexicon) {
                    ((AmrLinearizedSentence)amrSentence).updateVocabularies(this.amrVocabulary, amrHist, this.nlVocabulary, nlHist);
                }
                Collection<AmrAnonymizationAlignment> mergedAlignments = this.mergeAlignments((AmrLinearizedSentence)amrSentence, false);
                mergedAlignments.stream().filter(alignment -> !alignment.getRawAmrToken().isEmpty()).forEach(alignment -> {
                    HistMap<String> hist = this.amrAlignedNlVocabulary.getOrDefault(alignment.getRawAmrToken(), new HistMap());
                    if (!alignment.getNlTokens().isEmpty()) {
                        hist.add(alignment.getNlTokens().get(0));
                        this.amrAlignedNlVocabulary.put(alignment.getRawAmrToken(), hist);
                    }
                });
            }
            Iterator<AmrSentence> it = amrSentences[i].iterator();
            while (it.hasNext()) {
                AmrSentence s = it.next();
                if (!s.getAmr().isEmpty() && s.getAnonymizedSentenceSize() != 0) continue;
                it.remove();
            }
            if (this.amrThres > 1) {
                this.amrVocabulary = this.applyThresholding(this.amrVocabulary, amrHist, this.amrThres);
            }
            if (this.nlThres > 1) {
                this.nlVocabulary = this.applyThresholding(this.nlVocabulary, nlHist, this.nlThres);
            }
            amrHist.getEntriesSorted().stream().map(e -> String.format("%s\t%s", e.getFirst(), e.getSecond())).forEach(amrVocabWriter::println);
            nlHist.getEntriesSorted().stream().map(e -> String.format("%s\t%s", e.getFirst(), e.getSecond())).forEach(nlVocabWriter::println);
            Collections.shuffle(amrSentences[i], new Random(1234L));
            System.out.println("Total number of sentences (after alignment heuristics): " + amrSentences[i].size());
            for (AmrSentence amrSentence : amrSentences[i]) {
                rawIdsAmrWriter.println(amrSentence.rawIdsToString());
                linearAmrAnonymizedNlPairWriter.println(this.deAnonymizeOutput ? (this.outputBrackets ? ((AmrLinearizedSentence)amrSentence).toStringBrackets(this.reshuffleChildren, this.markLeaves, this.outputSense, this.concatBracketsWithRoles) : amrSentence.toString()) : ((AmrLinearizedSentence)amrSentence).toStringAnonymized(this.outputBrackets, this.reshuffleChildren, this.markLeaves, this.outputSense, this.concatBracketsWithRoles));
                anonymizedAlignmentsWriter.println(((AmrLinearizedSentence)amrSentence).toStringAnonymizationAlignments(this.lowerCaseOutput));
                contentAlignmentsWriter.println(((AmrLinearizedSentence)amrSentence).toStringContentAlignments());
                jamrAlignmentsWriter.println(((AmrLinearizedSentence)amrSentence).toStringJamrAlignments());
                amrNlAlignmentsSeqWriter.println(((AmrLinearizedSentence)amrSentence).toStringAmrNlSeqAlignments(this.mergeAlignments((AmrLinearizedSentence)amrSentence, true)));
                propositionAmrAnonymizedNlPairWriter.println(((AmrLinearizedSentence)amrSentence).toStringPropositionsAnonymizedNl());
                nlWriter.println(((AmrLinearizedSentence)amrSentence).toStringNlOnly());
                realIdToNumIdMap.println(((AmrLinearizedSentence)amrSentence).toStringIdToNumIdOnly());
            }
            this.amrAlignedNlVocabulary.values().stream().forEach(HistMap::setTopFreqElement);
            IOUtils.writeObjFileEasy((String)String.format("%s%s-io-alignments.obj.gz", this.outputFilename, infix), this.amrAlignedNlVocabulary);
            linearAmrAnonymizedNlPairWriter.close();
            rawIdsAmrWriter.close();
            amrNlAlignmentsMap.values().stream().forEach(HistMap::setTopFreqElement);
            Utils.writeLines(String.format("%s%s-amr-nl-alignments.txt", this.outputFilename, infix), amrNlAlignmentsMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("")).map(entry -> ((String)entry.getKey()).toLowerCase() + "|||" + ((String)((HistMap)entry.getValue()).getTopFreqElement()).toLowerCase()).collect(Collectors.toList()).toArray(new String[0]));
            Utils.writeLines(String.format("%s%s-amr-nl-alignments-hist.txt", this.outputFilename, infix), amrNlAlignmentsMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("")).map(entry -> (String)entry.getKey() + "|||" + ((HistMap)entry.getValue()).toStringOneLine()).collect(Collectors.toList()).toArray(new String[0]));
            Utils.writeLines(String.format("%s%s-nl-lemma-alignments.txt", this.outputFilename, infix), this.nlVocabulary.stream().filter(entry -> !entry.equals("")).map(entry -> entry + "|||" + (String)((List)this.stemmerPostagger.process((String)entry, 1, true).getFirst()).get(0)).collect(Collectors.toList()).toArray(new String[0]));
            anonymizedAlignmentsWriter.close();
            contentAlignmentsWriter.close();
            jamrAlignmentsWriter.close();
            propositionAmrAnonymizedNlPairWriter.close();
            amrNlAlignmentsSeqWriter.close();
            nlWriter.close();
            realIdToNumIdMap.close();
            amrVocabWriter.close();
            nlVocabWriter.close();
            if (this.augmentLexicon) {
                // empty if block
            }
            System.out.println("AMR vocabulary size: " + this.amrVocabulary.size());
            System.out.println("NL vocabulary size: " + this.nlVocabulary.size());
            ++i;
        }
        Utils.writeLines(String.format("%samr-roles-orderIds.txt", this.outputFilename), this.dictionaries.getAmrRoles().entrySet().stream().map(entry -> entry.getKey() + "\t" + entry.getValue()).collect(Collectors.toList()).toArray(new String[0]));
    }

    private Indexer<String> applyThresholding(Indexer<String> vocabulary, HistMap<String> hist, int thres) {
        if (thres > 1) {
            Indexer out = new Indexer();
            vocabulary.stream().forEach(key -> {
                int freq = hist.getFrequency((String)key);
                if (freq == -1 || freq > thres) {
                    out.add(key);
                }
            });
            return out;
        }
        return vocabulary;
    }

    private Map<String, Map<String, JamrAlignment>> readJamrAlignments(String path) {
        HashMap<String, Map<String, JamrAlignment>> map = new HashMap<String, Map<String, JamrAlignment>>();
        System.out.println("Reading JAMR alignments from " + path);
        String[] lines = Utils.readLines(path);
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].startsWith("# ::id ")) continue;
            String id = lines[i].split(" ")[2].trim();
            while (!lines[i].startsWith("# ::tok")) {
                ++i;
            }
            List<String> sentence = Arrays.asList(lines[i].substring(8).split(" "));
            while (!lines[i].startsWith("# ::node")) {
                ++i;
            }
            HashMap<String, JamrAlignment> alignments = new HashMap<String, JamrAlignment>();
            while (lines[i].startsWith("# ::node")) {
                JamrAlignment alignment = new JamrAlignment(sentence, lines[i++]);
                alignments.put(alignment.getNodeId(), alignment);
            }
            map.put(id, alignments);
        }
        return map;
    }

    private Collection<AmrAnonymizationAlignment> mergeAlignments(AmrLinearizedSentence amrSentence, boolean mergeAnonymizationAlignments) {
        HashSet<AmrAnonymizationAlignment> contentAlignments = new HashSet<AmrAnonymizationAlignment>(amrSentence.getContentAlignments());
        HashSet<JamrAlignment> jamrSentAlignments = new HashSet<JamrAlignment>(amrSentence.getJamrAlignments());
        contentAlignments.addAll(jamrSentAlignments.stream().filter(jamr -> !contentAlignments.stream().anyMatch(content -> content.equalsAmr((AmrAnonymizationAlignment)jamr))).map(alignment -> new JamrAlignment((AmrAnonymizationAlignment)alignment)).collect(Collectors.toSet()));
        if (mergeAnonymizationAlignments) {
            contentAlignments.addAll(amrSentence.getAnonymizationAlignments());
        }
        return contentAlignments;
    }

    private String[] listTxtFiles(String path) {
        return this.listFilesExt(path, ".txt");
    }

    private String[] listFilesExt(String path, String ext) {
        File f = new File(path);
        if (f.exists() && f.isDirectory()) {
            return f.list((dir, name) -> name.endsWith(ext));
        }
        return new String[0];
    }

    public String getExportType() {
        return this.exportType;
    }

    public Dictionaries getDictionaries() {
        return this.dictionaries;
    }

    public Map<String, Map<String, JamrAlignment>> getJamrAlignments() {
        return this.jamrAlignments;
    }

    public boolean isLinearize() {
        return this.exportType.equals("linearize");
    }

    public String getLinearizeType() {
        return this.linearizeType;
    }

    public boolean isDeanonymizeOutput() {
        return this.deAnonymizeOutput;
    }

    public boolean isLowerCaseOutput() {
        return this.lowerCaseOutput;
    }
}

