/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import util.corpus.wrappers.JamrAlignment;

public class AmrAlignment {
    private String token;
    private final TokenType type;
    private final List<Integer> wordIds;
    private String[] words;

    public AmrAlignment(TokenType type, String rawAlignStr) {
        this.type = type;
        int index = rawAlignStr.indexOf("~");
        if (index >= 0) {
            this.token = rawAlignStr.substring(0, index);
            this.wordIds = AmrAlignment.parseAlignments(rawAlignStr);
        } else {
            this.token = rawAlignStr;
            this.wordIds = new ArrayList<Integer>(Arrays.asList(-1));
        }
        this.words = new String[this.wordIds.size()];
    }

    public AmrAlignment(String token, String word, int wordId, TokenType type) {
        this.token = token;
        this.type = type;
        this.wordIds = Arrays.asList(wordId);
        this.words = new String[]{word};
    }

    public static final List<Integer> parseAlignments(String rawStr) {
        int index2 = rawStr.lastIndexOf(".");
        String[] ar = rawStr.substring(index2 + 1).split(",");
        ArrayList<Integer> ids = new ArrayList<Integer>(ar.length);
        for (String id : ar) {
            ids.add(Integer.valueOf(id));
        }
        return ids;
    }

    public List<Integer> getWordIds() {
        return this.wordIds;
    }

    public String[] getWords() {
        return this.words;
    }

    public void addAlignments(AmrAlignment alignment) {
        this.wordIds.addAll(alignment.wordIds);
        this.token = this.token + "_" + alignment.token.replaceAll("\"", "");
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public TokenType getType() {
        return this.type;
    }

    public void setWords(String sentence) {
        String[] ar = sentence.split(" ");
        for (int i = 0; i < this.wordIds.size(); ++i) {
            assert (this.wordIds.get(i) < ar.length);
            this.words[i] = ar[this.wordIds.get(i)];
        }
    }

    public void copyFromJamrAlignment(JamrAlignment jamr) {
        this.wordIds.clear();
        this.wordIds.addAll(jamr.nlIds);
        this.words = jamr.nlTokens.toArray(new String[0]);
    }

    public boolean isEmpty() {
        return this.wordIds.isEmpty() || this.wordIds.size() == 1 && this.wordIds.get(0) == -1;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(" " + this.token + " ||| ");
        for (int i = 0; i < this.wordIds.size(); ++i) {
            str.append(this.wordIds.get(i)).append(":").append(this.words[i]).append(", ");
        }
        return str.toString();
    }

    public static enum TokenType {
        ROLE,
        CONCEPT;

    }
}

