/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import javax.swing.tree.DefaultMutableTreeNode;
import util.corpus.wrappers.AmrAlignment;

public class AmrNode
extends DefaultMutableTreeNode {
    final String var;
    private final String word;
    private final String sense;
    private String role;
    private AmrAlignment conceptAlignment;
    private AmrAlignment roleAlignment;
    private final boolean cyclicReference;
    private final boolean constant;

    AmrNode(String variable, String word, String sensestr, String label, boolean cyclicReference, AmrAlignment conceptAlignment, AmrAlignment roleAlignment) {
        this.var = variable;
        String[] wordSense = this.stripSense(word);
        if (wordSense.length == 1) {
            this.word = word;
            this.sense = sensestr;
        } else {
            this.word = wordSense[0];
            this.sense = wordSense[1];
        }
        int index = label.indexOf(":");
        this.role = index >= 0 ? label.substring(index + 1) : label;
        this.cyclicReference = cyclicReference;
        this.conceptAlignment = conceptAlignment;
        this.roleAlignment = roleAlignment;
        this.constant = this.parseConstant(this.word);
    }

    public AmrNode(String variable, String word, String sensestr, String label, AmrAlignment conceptAlignment, AmrAlignment roleAlignment) {
        this(variable, word, sensestr, label, false, conceptAlignment, roleAlignment);
    }

    public AmrNode(String variable, String word, String sensestr, String label) {
        this(variable, word, sensestr, label, false, null, null);
    }

    private String[] stripSense(String tok) {
        String candSense;
        int id = tok.lastIndexOf("-");
        if (id != -1 && (candSense = tok.substring(id + 1)).matches("[0-9]{2}")) {
            return new String[]{tok.substring(0, id), candSense};
        }
        return new String[]{tok};
    }

    private boolean parseConstant(String word) {
        return word.startsWith("\"") || word.matches("[0-9]+[,.]?[0-9]*") || word.equals("-");
    }

    public boolean isConstant() {
        return this.constant;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getVar() {
        return this.var;
    }

    public String getSense() {
        return this.sense;
    }

    public boolean hasSense() {
        return !this.sense.equals("");
    }

    public boolean hasInverseRelation() {
        return this.role != null && this.role.endsWith("-of");
    }

    public String getWord() {
        return this.word;
    }

    public AmrAlignment getConceptAlignment() {
        return this.conceptAlignment;
    }

    public AmrAlignment getRoleAlignment() {
        return this.roleAlignment;
    }

    public boolean isCyclicReference() {
        return this.cyclicReference;
    }

    public void addArg(AmrNode arg) {
        this.insert(arg, 0);
    }

    public String pp() {
        StringBuilder sb = new StringBuilder();
        if (!this.role.equals("TOP")) {
            sb.append(" :");
            sb.append(this.role);
        }
        if (!this.var.isEmpty() && !this.isConstant()) {
            sb.append(" (");
            sb.append(this.var);
            sb.append(" / ");
        } else {
            sb.append(" ");
        }
        sb.append(this.word);
        if (!this.sense.isEmpty()) {
            sb.append("-");
            sb.append(this.sense);
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            AmrNode child = (AmrNode)this.getChildAt(i);
            sb.append(child.pp());
        }
        if (!this.var.isEmpty() && !this.isConstant()) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String toStringNoChildren() {
        return String.format(":%s ( %s / %s-%s )", this.role, this.var, this.word, this.sense);
    }

    public String toStringWithChildren() {
        StringBuilder str = new StringBuilder(this.toStringNoChildren());
        str.append(" [ ");
        for (int i = 0; i < this.getChildCount(); ++i) {
            AmrNode child = (AmrNode)this.getChildAt(i);
            str.append(child.toStringNoChildren()).append(", ");
        }
        str.deleteCharAt(str.length() - 2).append("]");
        return str.toString();
    }

    @Override
    public String toString() {
        return this.toStringNoChildren();
    }
}

