/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import util.corpus.wrappers.Amr;
import util.corpus.wrappers.Dictionaries;

public class AmrSentence {
    protected static int count = 1;
    protected String id;
    protected String sentence;
    protected String anonymizedSentence;
    protected final int incrId = count++;
    protected Amr amr;

    public AmrSentence(String id, String sentence) {
        this.id = id;
        this.sentence = sentence;
    }

    public void parseAmr(String id, String rawAmr, Dictionaries dictionaries) {
        this.amr = new Amr(id, rawAmr, dictionaries);
        this.amr.convert();
    }

    public String getId() {
        return this.id;
    }

    public String getSentence() {
        return this.sentence.toLowerCase();
    }

    public int getSentenceSize() {
        return this.sentence.split(" ").length;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public String getAnonymizedSentence() {
        return this.anonymizedSentence;
    }

    public int getAnonymizedSentenceSize() {
        return this.anonymizedSentence.split(" ").length;
    }

    public void setAnonymizedSentence(String anonymizedSentence) {
        this.anonymizedSentence = anonymizedSentence;
    }

    public Amr getAmr() {
        return this.amr;
    }

    public String rawIdsToString() {
        String raw = this.amr.raw.replaceAll("\\s+", " ").trim();
        raw = raw.replaceAll("~e[.][0-9]+,?[0-9]*", "");
        String[] ar = raw.split(" ");
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < ar.length; ++i) {
            if (ar[i].equals(":wiki")) {
                ++i;
                continue;
            }
            str.append(ar[i]).append(" ");
        }
        raw = str.toString().trim();
        return this.id + "\t" + raw;
    }
}

