/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import java.util.ArrayList;
import java.util.List;
import util.corpus.wrappers.AmrAnonymizationAlignment;

public class JamrAlignment
extends AmrAnonymizationAlignment {
    private final String nodeId;

    public JamrAlignment(AmrAnonymizationAlignment alignIn) {
        this.nodeId = null;
        this.amrToken = alignIn.amrToken;
        this.anonymizedNlId = alignIn.anonymizedNlId;
        this.anonymizedToken = alignIn.anonymizedToken;
        this.nlIds = alignIn.nlIds;
        this.nlTokens = alignIn.nlTokens;
    }

    public JamrAlignment(List<String> sentence, String rawStr) {
        this.anonymizedToken = "-";
        String[] toks = rawStr.split("\t");
        this.nlTokens = new ArrayList();
        this.nodeId = toks[1];
        this.amrToken = this.stripSense(toks[2]);
        this.nlIds = new ArrayList();
        if (toks.length == 3) {
            this.nlIds.add(-1);
        } else {
            String[] startEnd = toks[3].split("-");
            int start = Integer.valueOf(startEnd[0]);
            int end = Integer.valueOf(startEnd[1]);
            switch (end - start) {
                case 1: {
                    this.nlIds.add(start);
                    assert (start >= 0 && start <= sentence.size()) : "start=" + start + " sentence.size()=" + sentence.size() + " sentence=" + sentence;
                    this.nlTokens.add(sentence.get(start));
                    break;
                }
                case 0: {
                    start = end - 1;
                    this.nlIds.add(start);
                    assert (start >= 0 && start <= sentence.size()) : "start=" + start + " sentence.size()=" + sentence.size() + " sentence=" + sentence;
                    this.nlTokens.add(sentence.get(start));
                    break;
                }
                default: {
                    if (start >= 0 && end < sentence.size()) {
                        for (int i = start; i < end; ++i) {
                            this.nlIds.add(i);
                            this.nlTokens.add(sentence.get(i));
                        }
                        break;
                    }
                    this.nlIds.add(-1);
                }
            }
        }
        this.anonymizedToken = this.nodeId;
        try {
            this.anonymizedNlId = (Integer)this.nlIds.get(0);
        }
        catch (Exception e) {
            System.out.println("Error reading JAMR alignment");
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public boolean isEmpty() {
        return this.nlIds.isEmpty() || (Integer)this.nlIds.get(0) == -1;
    }

    private String stripSense(String tok) {
        int id = tok.lastIndexOf("-");
        return id == -1 ? tok : tok.substring(0, id);
    }
}

