/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import util.corpus.wrappers.AmrAnonymizationAlignment;
import util.corpus.wrappers.AmrSentence;

public class NerSentence
extends AmrSentence {
    private final Collection<AmrAnonymizationAlignment> anonymizationAlignments;
    private final List<String> tokens;

    public NerSentence(String id, boolean generateId, List<String> sentence, List<String> anonymizedSentence, Collection<AmrAnonymizationAlignment> anonymizationAlignments) {
        super(id, String.join((CharSequence)" ", sentence));
        this.id = generateId ? id + this.incrId : id;
        this.anonymizedSentence = String.join((CharSequence)" ", anonymizedSentence);
        this.anonymizationAlignments = anonymizationAlignments;
        this.tokens = anonymizedSentence.stream().map(tok -> tok.toLowerCase()).collect(Collectors.toList());
    }

    public String toStringAnonymizationAlignments() {
        StringBuilder str = new StringBuilder();
        this.anonymizationAlignments.stream().forEach(an -> str.append(an).append(" # "));
        return String.format("%s\t%s", this.getId(), this.anonymizationAlignments.isEmpty() ? "" : str.substring(0, str.length() - 3).trim());
    }

    public Collection<AmrAnonymizationAlignment> getAnonymizationAlignments() {
        return this.anonymizationAlignments;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public String toStringNlOnly() {
        return this.sentence.toLowerCase();
    }

    public String toStringNlAnonOnly() {
        return this.anonymizedSentence.toLowerCase();
    }

    public String toString() {
        return this.sentence;
    }
}

