/*
 * Decompiled with CFR 0.152.
 */
package util.metrics;

import fig.basic.Fmt;
import fig.basic.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.Option;
import util.corpus.wrappers.AmrAnonymizationAlignment;
import util.corpus.wrappers.AnonymizationAlignment;
import util.metrics.GenerationPerformance;
import util.metrics.Hypothesis;
import util.utils.Utils;

public class RecomputeMetrics {
    private final CommandLineArguments cmd;
    private final String outputFolder;
    private final String inputFolder;
    private final boolean useMultiBleu;
    private String referencesFilename;
    private final GenerationPerformance performance;
    private Map<String, String> referenceExamples;
    private Map<String, String> referenceAnonymizedExamples;
    private Map<String, Map<String, AnonymizationAlignment>> anonymizedAlignments;
    private final boolean singleFileOnly;
    private final boolean isInputAnonymized;
    private final boolean isMultipleFiles;
    private final boolean isGridExperiment;
    private List<String> ids;

    public RecomputeMetrics(CommandLineArguments cmd) {
        this.cmd = cmd;
        this.outputFolder = this.inputFolder = cmd.getInputFolder();
        this.useMultiBleu = new File("./multi-bleu.perl").exists();
        this.isInputAnonymized = cmd.getIsInputAnonymized();
        this.isMultipleFiles = cmd.getIsMultipleFiles();
        this.isGridExperiment = cmd.getIsGridExperiment();
        this.singleFileOnly = new File(cmd.getInputFolder()).isFile();
        this.readReferenceFiles();
        this.performance = new GenerationPerformance("");
    }

    public void execute() {
        if (this.referenceExamples != null) {
            if (this.isMultipleFiles) {
                StringBuilder summary = new StringBuilder(this.performance.getNameMetricsShortHeader(this.useMultiBleu));
                ArrayList<Pair<String, double[]>> results = new ArrayList<Pair<String, double[]>>();
                if (this.isGridExperiment) {
                    try {
                        Files.walk(Paths.get(this.inputFolder, new String[0]), new FileVisitOption[0]).filter(p -> p.toFile().isDirectory()).forEach(p -> results.addAll(this.processFolder(summary, p.toString())));
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                    }
                } else {
                    results.addAll(this.processFolder(summary, this.inputFolder));
                }
                StringBuilder maxScores = this.maxScores(results, this.performance.getMetricsNames(this.useMultiBleu));
                System.out.println(maxScores);
                summary.append("\n\nMax scores:-----------\n").append((CharSequence)maxScores);
                Utils.write(this.outputFolder + "/summary.performance.recomputed", summary.toString());
            } else {
                Map<String, String> predAnonExamples;
                Map<String, String> predExamples;
                Map<String, String> map = this.isInputAnonymized ? null : (predExamples = this.readFile(this.inputFolder + (this.singleFileOnly ? "" : "/decoder-simple.output")));
                Map<String, String> map2 = this.isInputAnonymized ? this.readFile(this.inputFolder) : (predAnonExamples = this.singleFileOnly ? null : this.readFile(this.inputFolder + "/decoder-anonymized-simple.output"));
                if ((predExamples != null || predAnonExamples != null) && (this.singleFileOnly || predAnonExamples != null && this.anonymizedAlignments != null)) {
                    HashMap<String, String> deAnonymizedPreds = new HashMap<String, String>();
                    this.processFile(this.referenceExamples, this.referenceAnonymizedExamples, predExamples, predAnonExamples, deAnonymizedPreds, this.anonymizedAlignments);
                    this.writeOutput(this.outputFolder + (this.singleFileOnly ? ".performance.recomputed" : "/decoder.performance.recomputed"));
                }
            }
        }
    }

    private void readReferenceFiles() {
        System.out.println("Reading from " + (this.singleFileOnly ? "file " : "folder ") + this.inputFolder);
        this.ids = RecomputeMetrics.extractIds(this.cmd.getIdsFilename().equals("") ? this.cmd.getReferenceFilename() : this.cmd.getIdsFilename());
        this.referenceExamples = RecomputeMetrics.readFileWithIds(this.cmd.getReferenceFilename());
        this.referenceAnonymizedExamples = this.cmd.getReferenceAnonymizedFilename().equals("") ? Collections.EMPTY_MAP : RecomputeMetrics.readFileWithIds(this.cmd.getReferenceAnonymizedFilename());
        Map<String, Map<String, AnonymizationAlignment>> map = this.anonymizedAlignments = (!this.singleFileOnly || this.isInputAnonymized) && !this.cmd.getAnonymizedAlignmentsFilename().equals("") ? RecomputeMetrics.readAmrAnonymizedAlignments(this.cmd.getAnonymizedAlignmentsFilename()) : null;
        if (this.useMultiBleu && this.referenceExamples != null && !this.referenceExamples.isEmpty()) {
            try {
                File tempFilename = File.createTempFile("references-", ".txt");
                this.referencesFilename = tempFilename.getAbsolutePath();
                this.writeOutputInOrder(this.referenceExamples, this.referencesFilename);
                tempFilename.deleteOnExit();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public static Map<String, Map<String, AnonymizationAlignment>> readAmrAnonymizedAlignments(String anonymizedAlignmentsFilename) {
        HashMap<String, Map<String, AnonymizationAlignment>> map = new HashMap<String, Map<String, AnonymizationAlignment>>();
        for (String line : Utils.readLines(anonymizedAlignmentsFilename)) {
            String[] ar = line.split("\t");
            if (ar.length > 2) {
                throw new InputMismatchException("Couldn't read anonymized alignments from: " + anonymizedAlignmentsFilename + " Error in line: " + line);
            }
            String id = ar[0];
            HashMap<String, AmrAnonymizationAlignment> alignments = new HashMap<String, AmrAnonymizationAlignment>();
            if (ar.length > 1) {
                String[] alignmentsAr;
                for (String alignment : alignmentsAr = ar[1].split(" # ")) {
                    AmrAnonymizationAlignment a = new AmrAnonymizationAlignment(alignment);
                    alignments.put(a.getAnonymizedToken(), a);
                }
            }
            map.put(id, alignments);
        }
        return map;
    }

    public static List<String> extractIds(String filename) {
        return new File(filename).exists() ? Arrays.asList(Utils.readLines(filename)).stream().map(line -> line.split("\t")[0]).collect(Collectors.toList()) : null;
    }

    public Map<String, String> readFile(String filename) {
        boolean hasIds;
        String[] lines;
        String[] stringArray = lines = new File(filename).exists() ? Utils.readLines(filename) : null;
        if (lines == null) {
            return null;
        }
        boolean bl = hasIds = lines[0].split("\t").length > 1;
        if (hasIds) {
            return RecomputeMetrics.readFileWithIds(lines);
        }
        return this.readFileWithoutIds(lines);
    }

    public static Map<String, String> readFileWithIds(String filename) {
        return RecomputeMetrics.readFileWithIds(Utils.readLines(filename));
    }

    public static Map<String, String> readFileWithIds(String[] lines) {
        Map<String, String> out = lines.length > 0 ? Arrays.asList(lines).stream().collect(Collectors.toMap(line -> line.split("\t")[0], line -> line.split("\t")[1])) : null;
        return out;
    }

    public Map<String, String> readFileWithoutIds(String[] lines) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (int i = 0; i < lines.length; ++i) {
            out.put(this.ids.get(i), lines[i]);
        }
        return out;
    }

    private List<Pair<String, double[]>> processFolder(StringBuilder summary, String inputFolder) {
        ArrayList<Pair<String, double[]>> results = new ArrayList<Pair<String, double[]>>();
        Arrays.asList(new File(inputFolder).list()).stream().filter(filePath -> filePath.endsWith(".txt")).forEach(filename -> {
            Map<String, String> predAnonExamples;
            String fullFilename = inputFolder + "/" + filename;
            System.out.println("Processing " + fullFilename);
            Map<String, String> predExamples = this.isInputAnonymized ? null : this.readFile(inputFolder + "/" + filename);
            Map<String, String> map = predAnonExamples = this.isInputAnonymized ? this.readFile(inputFolder + "/" + filename) : null;
            if (predExamples != null || predAnonExamples != null && this.anonymizedAlignments != null) {
                HashMap<String, String> deAnonymizedPreds = new HashMap<String, String>();
                this.processFile(this.referenceExamples, this.referenceAnonymizedExamples, predExamples, predAnonExamples, deAnonymizedPreds, this.anonymizedAlignments);
                this.performance.setExperimentName(fullFilename);
                this.writeOutput(fullFilename + ".performance.recomputed");
                this.writeOutputInOrder(deAnonymizedPreds, fullFilename + ".deAnonymized");
                if (this.useMultiBleu) {
                    String multiBleuStr = this.computeMultiBleu(fullFilename + ".deAnonymized");
                    double multiBleu = Double.valueOf(multiBleuStr.split("[ ,]")[2]);
                    summary.append(this.performance.getNameMetricsShort(multiBleuStr));
                    results.add(this.performance.getMetrics(multiBleu));
                } else {
                    summary.append(this.performance.getNameMetricsShort());
                    results.add(this.performance.getMetrics(-1.0));
                }
                this.performance.reset();
            }
        });
        return results;
    }

    private void processFile(Map<String, String> referenceExamples, Map<String, String> referenceAnonymizedExamples, Map<String, String> predExamples, Map<String, String> predAnonExamples, Map<String, String> deAnonymizedPreds, Map<String, Map<String, AnonymizationAlignment>> anonymizedAlignments) {
        referenceExamples.forEach((id, referenceSentence) -> {
            Hypothesis referenceHypothesis;
            Hypothesis hypothesis = referenceHypothesis = referenceAnonymizedExamples.isEmpty() ? new Hypothesis((String)referenceSentence) : new Hypothesis((String)referenceSentence, (String)referenceAnonymizedExamples.get(id));
            if ((this.singleFileOnly || this.isMultipleFiles) && this.isInputAnonymized) {
                if (predAnonExamples.containsKey(id)) {
                    Hypothesis predHypothesis = new Hypothesis((String)predAnonExamples.get(id));
                    predHypothesis.deAnonymize((Map)anonymizedAlignments.get(id));
                    deAnonymizedPreds.put((String)id, predHypothesis.deAnonymizedToString());
                    this.performance.add(referenceHypothesis, predHypothesis);
                }
            } else if (this.singleFileOnly) {
                if (predExamples.containsKey(id)) {
                    referenceHypothesis.deAnonymizeFake();
                    Hypothesis predHypothesis = new Hypothesis((String)predExamples.get(id), (String)predExamples.get(id));
                    deAnonymizedPreds.put((String)id, predHypothesis.deAnonymizedToString());
                    this.performance.add(referenceHypothesis, predHypothesis);
                }
            } else if (predExamples.containsKey(id)) {
                if (predAnonExamples != null && predAnonExamples.containsKey(id)) {
                    Hypothesis predHypothesis = new Hypothesis((String)predExamples.get(id), (String)predAnonExamples.get(id));
                    deAnonymizedPreds.put((String)id, predHypothesis.deAnonymizedToString());
                    this.performance.add(referenceHypothesis, predHypothesis);
                } else {
                    Hypothesis predHypothesis = new Hypothesis((String)predExamples.get(id));
                    predHypothesis.deAnonymizeFake();
                    referenceHypothesis.deAnonymizeFake();
                    this.performance.add(referenceHypothesis, predHypothesis);
                }
            }
        });
    }

    private StringBuilder maxScores(List<Pair<String, double[]>> results, String[] metricsNames) {
        StringBuilder out = new StringBuilder();
        int numOfResults = results.size();
        int numOfMetrics = metricsNames.length;
        String[] experimentNames = new String[numOfResults];
        double[][] scores = new double[numOfMetrics][numOfResults];
        for (int i = 0; i < numOfResults; ++i) {
            experimentNames[i] = (String)results.get(i).getFirst();
            for (int j = 0; j < numOfMetrics; ++j) {
                scores[j][i] = ((double[])results.get(i).getSecond())[j];
            }
        }
        for (int j = 0; j < numOfMetrics; ++j) {
            double[] score = scores[j];
            Pair<Integer, Double> maxScore = this.max(score);
            out.append(String.format("Max %s: %s\t%s\n", metricsNames[j], Fmt.D((double)((Double)maxScore.getSecond())), experimentNames[(Integer)maxScore.getFirst()]));
        }
        return out;
    }

    private Pair<Integer, Double> max(double[] ar) {
        double max = ar[0];
        int maxId = 0;
        for (int i = 1; i < ar.length; ++i) {
            if (!(ar[i] > max)) continue;
            max = ar[i];
            maxId = i;
        }
        return new Pair((Object)maxId, (Object)max);
    }

    private String computeMultiBleu(String predFilename) {
        String bleu = null;
        try {
            String command = String.format("perl ./multi-bleu.perl -lc %s", this.referencesFilename);
            ProcessBuilder ps = new ProcessBuilder(command.split(" "));
            ps.redirectErrorStream(true);
            ps.redirectInput(new File(predFilename));
            Process pr = ps.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    bleu = line;
                }
                pr.waitFor();
            }
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
        return bleu;
    }

    private void writeOutput(String filename) {
        try (PrintWriter output = new PrintWriter(filename);){
            output.println(this.performance.output());
            output.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    private void writeOutputInOrder(Map<String, String> deAnonymizedPreds, String filename) {
        try (PrintWriter out = new PrintWriter(new FileOutputStream(filename));){
            this.ids.stream().forEach(id -> out.println((String)deAnonymizedPreds.get(id)));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void main(String[] args) {
        try {
            CommandLineArguments cmd = (CommandLineArguments)CliFactory.parseArguments(CommandLineArguments.class, (String[])args);
            RecomputeMetrics rm = new RecomputeMetrics(cmd);
            rm.execute();
        }
        catch (ArgumentValidationException ex) {
            System.err.println((Object)ex);
        }
    }

    public static interface CommandLineArguments {
        @Option(description="Path that contains input folder")
        public String getInputFolder();

        @Option(defaultValue={""}, description="Reference file used for evaluation.")
        public String getReferenceFilename();

        @Option(defaultValue={""}, description="Reference file (anonymized) used for evaluation.")
        public String getReferenceAnonymizedFilename();

        @Option(defaultValue={""}, description="Alignment file that contains mappings from input tokens to their anonymized counterparts (usually for NEs, dates and numerical entities.")
        public String getAnonymizedAlignmentsFilename();

        @Option(description="Anonymized input")
        public boolean getIsInputAnonymized();

        @Option(defaultValue={""}, description="File containing the ids in the order of the generated output")
        public String getIdsFilename();

        @Option(description="Folder contains multiple prediction files")
        public boolean getIsMultipleFiles();

        @Option(description="Folder contains multiple folders of prediction files")
        public boolean getIsGridExperiment();
    }
}

