/*
 * Decompiled with CFR 0.152.
 */
package util.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import util.utils.NamedEntityRecognizerInterface;

public class NamedEntityRecognizerClient
implements NamedEntityRecognizerInterface {
    private Socket socket = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private final String host = "localhost";

    public NamedEntityRecognizerClient(int port) throws IOException {
        try {
            this.socket = new Socket("localhost", port);
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host: localhost");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: localhost");
            System.exit(1);
        }
    }

    @Override
    public String processToString(String text) {
        try {
            this.out.write(text + "\n");
            this.out.flush();
            return this.in.readLine();
        }
        catch (IOException ex) {
            System.err.println("Couldn't write/read from socket.");
            ex.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public String processToString(String text, int length) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void destroy() {
        try {
            this.out.close();
            this.in.close();
            this.socket.close();
        }
        catch (IOException ex) {
            System.err.println("Error closing socket");
        }
    }

    public static void main(String[] args) {
        try {
            NamedEntityRecognizerClient nerc = new NamedEntityRecognizerClient(4444);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
                String line;
                System.out.println("Enter string to NER [q to exit]");
                while (!(line = reader.readLine()).equals("q")) {
                    System.out.println(nerc.processToString(line));
                }
                nerc.processToString("terminate_client");
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
            nerc.destroy();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }
}

