/*
 * Decompiled with CFR 0.152.
 */
package util.server;

import java.io.IOException;
import java.net.ServerSocket;
import util.server.NerThread;
import util.utils.NamedEntityRecognizer;

public class NerServer {
    protected int port;
    protected NamedEntityRecognizer ner;
    protected boolean verbose;

    public NerServer(int port, boolean verbose) {
        this.port = port;
        this.verbose = verbose;
        this.ner = new NamedEntityRecognizer(true);
    }

    public void execute() {
        ServerSocket serverSocket = null;
        boolean listening = true;
        try {
            serverSocket = new ServerSocket(this.port);
            System.out.println("NER Server listening on port " + this.port);
        }
        catch (IOException e) {
            NerServer.error("Could not listen on port: " + this.port);
        }
        try {
            while (listening) {
                Object res = new NerThread(this.ner, serverSocket.accept(), this.verbose).call();
                if (!(res instanceof String) || !res.equals("terminate_server")) continue;
                listening = false;
            }
        }
        catch (IOException ioe) {
            NerServer.message("Could not establish connection!");
        }
        try {
            serverSocket.close();
        }
        catch (IOException ioe) {
            NerServer.error("Error closing socket");
        }
    }

    public static void main(String[] args) throws IOException {
        int port = args.length > 0 && args[0] != null ? Integer.valueOf(args[0]) : 4444;
        boolean verbose = args.length > 1 && args[1] != null ? Boolean.valueOf(args[1]) : true;
        NerServer server = new NerServer(port, verbose);
        server.execute();
    }

    public static void error(String msg) {
        System.err.println(msg);
        System.exit(-1);
    }

    public static void message(String msg) {
        System.out.println(msg);
    }
}

