/*
 * Decompiled with CFR 0.152.
 */
package util.utils;

import fig.basic.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HistMap<T>
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final HashMap<T, Counter> map = new HashMap();
    private T topFreqElement;

    public void add(T word) {
        Counter counter = this.map.get(word);
        if (counter == null) {
            counter = new Counter(word);
            this.map.put(word, counter);
        }
        counter.incr();
    }

    public Set<Map.Entry<T, Counter>> getEntries() {
        return this.map.entrySet();
    }

    public Set<Map.Entry<T, Integer>> getEntriesFreqs() {
        HashMap m = new HashMap();
        this.map.entrySet().stream().forEach(e -> m.put(e.getKey(), ((Counter)e.getValue()).value));
        return m.entrySet();
    }

    public Set<T> getKeys() {
        return this.map.keySet();
    }

    public int getTotalFrequency() {
        int total = 0;
        total = this.getEntriesFreqs().stream().map(e -> (Integer)e.getValue()).reduce(total, Integer::sum);
        return total;
    }

    public int size() {
        return this.map.size();
    }

    public T getFirstKey() {
        return this.getKeysSorted().get(0);
    }

    public Pair<T, Integer> getFirstEntry() {
        return this.getEntriesSorted().get(0);
    }

    public List<T> getKeysSorted() {
        ArrayList<Counter> list = new ArrayList<Counter>(this.map.values());
        Collections.sort(list);
        ArrayList out = new ArrayList();
        list.stream().forEach(c -> out.add(((Counter)c).key));
        return out;
    }

    public List<Pair<T, Integer>> getEntriesSorted() {
        ArrayList<Counter> list = new ArrayList<Counter>(this.map.values());
        Collections.sort(list);
        ArrayList out = new ArrayList();
        list.stream().forEach(c -> out.add(new Pair(((Counter)c).key, (Object)((Counter)c).value)));
        return out;
    }

    public int getFrequency(T key) {
        return this.map.containsKey(key) ? this.map.get(key).value : -1;
    }

    public T getTopFreqElement() {
        return this.topFreqElement;
    }

    public void setTopFreqElement() {
        this.topFreqElement = this.getFirstKey();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        ArrayList<Counter> list = new ArrayList<Counter>(this.map.values());
        Collections.sort(list);
        list.stream().forEach(c -> str.append(c).append("\n"));
        return str.toString();
    }

    public String toStringOneLine() {
        ArrayList<Counter> list = new ArrayList<Counter>(this.map.values());
        Collections.sort(list);
        return list.stream().map(i -> i.toString()).collect(Collectors.joining("\t"));
    }

    final class Counter
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -1L;
        private T key;
        private int value;

        public Counter(T key) {
            this.key = key;
        }

        public int getValue() {
            return this.value;
        }

        public void incr() {
            ++this.value;
        }

        public String toString() {
            return String.format("%s : %s", this.key, this.value);
        }

        public int compareTo(Object o) {
            return ((Counter)o).value - this.value;
        }
    }
}

