/*
 * Decompiled with CFR 0.152.
 */
package util.utils;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.LexedTokenFactory;
import edu.stanford.nlp.process.PTBTokenizer;
import fig.basic.Pair;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import util.utils.NamedEntityRecognizerInterface;

public class NamedEntityRecognizer
implements NamedEntityRecognizerInterface {
    private final StanfordCoreNLP pipeline;
    private static final Pattern ANONYMIZED_ENTITY_MATCHER = Pattern.compile(".+_[0-9]+$");
    private final boolean tokenize;

    public NamedEntityRecognizer(boolean tokenize) {
        this.tokenize = tokenize;
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, pos, lemma, ner");
        props.setProperty("tokenize.language", "Whitespace");
        props.setProperty("ner.model", "lib/models/ner/english.all.3class.distsim.crf.ser.gz");
        props.setProperty("pos.model", "lib/models/pos-tagger/english-left3words-distsim.tagger");
        this.pipeline = new StanfordCoreNLP(props);
        if (tokenize) {
            // empty if block
        }
    }

    private String tokenize(String text) {
        PTBTokenizer tokenizer = new PTBTokenizer((Reader)new StringReader(text), (LexedTokenFactory)new CoreLabelTokenFactory(), "");
        return tokenizer.tokenize().stream().map(CoreLabel::toString).collect(Collectors.joining(" "));
    }

    private Pair<List<String>, List<String>> process(String text, int length) {
        if (this.tokenize) {
            text = this.tokenize(text);
            length = text.split(" ").length;
        }
        Annotation document = new Annotation(text);
        this.pipeline.annotate(document);
        ArrayList tokens = new ArrayList();
        ((List)document.get(CoreAnnotations.SentencesAnnotation.class)).stream().forEach(sent -> ((List)sent.get(CoreAnnotations.TokensAnnotation.class)).stream().forEach(token -> tokens.add(token)));
        assert (tokens.size() == length) : "length mismatch. Found " + tokens.size() + ", was given " + length + " " + text;
        ArrayList words = new ArrayList(length);
        ArrayList namedEntities = new ArrayList(length);
        tokens.stream().forEach(token -> {
            String word = (String)token.get(CoreAnnotations.TextAnnotation.class);
            String namedEntity = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            words.add(word);
            namedEntities.add(namedEntity);
        });
        return new Pair(words, namedEntities);
    }

    @Override
    public String processToString(String text, int length) {
        Pair<List<String>, List<String>> tokensNers = this.process(text, length);
        return NamedEntityRecognizer.zip(((List)tokensNers.getFirst()).stream(), ((List)tokensNers.getSecond()).stream(), (a, b) -> a + "/" + b).collect(Collectors.joining(" "));
    }

    @Override
    public String processToString(String text) {
        return this.processToString(text, text.split(" ").length);
    }

    public static boolean isAnonymizedEntity(String word) {
        return ANONYMIZED_ENTITY_MATCHER.matcher(word).matches();
    }

    public static void main(String[] args) {
        String text = "Township Vibes wonders who would want to become the president of Zimbabwe : \u201cToday the Zimbabwean dollar is trading at $200 million to \u00a31.";
        int length = text.split(" ").length;
        NamedEntityRecognizer spt = new NamedEntityRecognizer(true);
        Pair<List<String>, List<String>> tokensNers = spt.process(text, length);
        System.out.println("tokens = " + tokensNers.getFirst());
        System.out.println("ners = " + tokensNers.getSecond());
        String tokensNersToString = spt.processToString(text, length);
        System.out.println("NER'd sentence = " + tokensNersToString);
    }

    private static <A, B, C> Stream<C> zip(Stream<? extends A> a, Stream<? extends B> b, final BiFunction<? super A, ? super B, ? extends C> zipper) {
        final Iterator iteratorA = a.iterator();
        final Iterator iteratorB = b.iterator();
        Iterable iterable = () -> new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return iteratorA.hasNext() && iteratorB.hasNext();
            }

            @Override
            public C next() {
                return zipper.apply(iteratorA.next(), iteratorB.next());
            }
        };
        return StreamSupport.stream(iterable.spliterator(), a.isParallel() || b.isParallel());
    }
}

