/*
 * Decompiled with CFR 0.152.
 */
package util.utils;

import fig.basic.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;

public class Utils {
    public static String[] readLines(String path, int maxLines) {
        ArrayList<String> linesList = null;
        BufferedReader in = IOUtils.openInEasy((String)path);
        if (in != null) {
            linesList = new ArrayList<String>();
            String line = "";
            try {
                for (int i = 0; (line = in.readLine()) != null && i < maxLines; ++i) {
                    linesList.add(line);
                }
                in.close();
            }
            catch (IOException ioe) {
                System.err.println(String.format("Error reading file %s", path));
            }
        }
        String[] out = new String[linesList.size()];
        return linesList.toArray(out);
    }

    public static String[] readLines(String path) {
        return Utils.readLines(path, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String filePath) throws IOException {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        BufferedInputStream f = null;
        try {
            f = new BufferedInputStream(new FileInputStream(filePath));
            f.read(buffer);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(buffer);
    }

    public static String stripExtension(String name) {
        int index = name.lastIndexOf(".");
        return index == -1 ? name : name.substring(0, index);
    }

    public static boolean writeLines(String path, String[] lines) {
        PrintWriter out = IOUtils.openOutEasy((String)path);
        if (out != null) {
            for (String line : lines) {
                out.println(line);
            }
            out.close();
            return true;
        }
        return false;
    }

    public static boolean write(String path, String text) {
        PrintWriter out = IOUtils.openOutEasy((String)path);
        if (out != null) {
            out.println(text);
            out.close();
            return true;
        }
        return false;
    }

    public static String[] tokenize(String input) {
        return input.toLowerCase().split("\\s");
    }

    public static String[] removeStopWords(String[] tokens, Set<String> stopWords) {
        ArrayList<String> res = new ArrayList<String>();
        for (String token : tokens) {
            if (stopWords.contains(token)) continue;
            res.add(token);
        }
        return res.toArray(new String[0]);
    }

    public static String[] tokenizeToUnigrams(String sentence, Set<String> stopWords) {
        return stopWords == null ? Utils.tokenize(sentence) : Utils.removeStopWords(Utils.tokenize(sentence), stopWords);
    }

    public static String[] tokenizeToBigrams(String sentence, Set<String> stopWords) {
        ArrayList<String> bigrams = new ArrayList<String>();
        String[] unigrams = Utils.tokenize("<s> " + sentence.replaceAll(", ", "") + " </s>");
        for (int i = 1; i < unigrams.length; ++i) {
            bigrams.add(unigrams[i - 1] + "_" + unigrams[i]);
        }
        return bigrams.toArray(new String[0]);
    }

    public static boolean isSentencePunctuation(String s) {
        return s.equals("./.") || s.equals("--/:") || s.equals(".") || s.equals("--");
    }

    public static String toCamelCasing(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

