/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.stats.Counter;
import java.util.Arrays;
import junit.framework.TestCase;

public class DatasetTest
extends TestCase {
    public static void testDataset() {
        Dataset<String, String> data = new Dataset<String, String>();
        data.add(new BasicDatum<String, String>(Arrays.asList("fever", "cough", "congestion"), "cold"));
        data.add(new BasicDatum<String, String>(Arrays.asList("fever", "cough", "nausea"), "flu"));
        data.add(new BasicDatum<String, String>(Arrays.asList("cough", "congestion"), "cold"));
        DatasetTest.assertEquals((int)4, (int)data.numFeatures());
        DatasetTest.assertEquals((int)4, (int)data.numFeatureTypes());
        DatasetTest.assertEquals((int)2, (int)data.numClasses());
        DatasetTest.assertEquals((int)8, (int)data.numFeatureTokens());
        DatasetTest.assertEquals((int)3, (int)data.size());
        data.applyFeatureCountThreshold(2);
        DatasetTest.assertEquals((int)3, (int)data.numFeatures());
        DatasetTest.assertEquals((int)3, (int)data.numFeatureTypes());
        DatasetTest.assertEquals((int)2, (int)data.numClasses());
        DatasetTest.assertEquals((int)7, (int)data.numFeatureTokens());
        DatasetTest.assertEquals((int)3, (int)data.size());
        LinearClassifierFactory factory = new LinearClassifierFactory();
        Classifier classifier = factory.trainClassifier((GeneralDataset)data);
        BasicDatum d = new BasicDatum(Arrays.asList("cough", "fever"));
        DatasetTest.assertEquals((String)"Classification incorrect", (String)"flu", (String)((String)((LinearClassifier)classifier).classOf(d)));
        Counter probs = ((LinearClassifier)classifier).probabilityOf(d);
        DatasetTest.assertEquals((String)"Returned probability incorrect", (double)0.4553, (double)probs.getCount("cold"), (double)1.0E-4);
        DatasetTest.assertEquals((String)"Returned probability incorrect", (double)0.5447, (double)probs.getCount("flu"), (double)1.0E-4);
        System.out.println();
    }
}

