/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.KNNClassifierFactory;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class KNNClassifier<K, V>
implements Classifier<K, V> {
    private static final long serialVersionUID = 7115357548209007944L;
    private boolean weightedVotes = false;
    private CollectionValuedMap<K, Counter<V>> instances = new CollectionValuedMap();
    private Map<Counter<V>, K> classLookup = Generics.newHashMap();
    private boolean l2Normalize = false;
    int k = 0;

    @Override
    public Collection<K> labels() {
        return this.classLookup.values();
    }

    protected KNNClassifier(int k, boolean weightedVotes, boolean l2Normalize) {
        this.k = k;
        this.weightedVotes = weightedVotes;
        this.l2Normalize = l2Normalize;
    }

    protected void addInstances(Collection<RVFDatum<K, V>> datums) {
        for (RVFDatum<K, V> datum : datums) {
            K label = datum.label();
            Counter<V> vec = datum.asFeaturesCounter();
            this.instances.add(label, vec);
            this.classLookup.put((Counter<K>)vec, (Counter<V>)label);
        }
    }

    @Override
    public K classOf(Datum<K, V> example) {
        if (example instanceof RVFDatum) {
            Counter scores = this.scoresOf((Datum)example);
            return (K)Counters.toSortedList(scores).get(0);
        }
        return null;
    }

    @Override
    public ClassicCounter<K> scoresOf(Datum<K, V> datum) {
        if (datum instanceof RVFDatum) {
            RVFDatum vec = (RVFDatum)datum;
            if (this.l2Normalize) {
                ClassicCounter featVec = new ClassicCounter(vec.asFeaturesCounter());
                Counters.normalize(featVec);
                vec = new RVFDatum(featVec);
            }
            ClassicCounter<Counter<V>> scores = new ClassicCounter<Counter<V>>();
            for (Counter<V> instance : this.instances.allValues()) {
                scores.setCount(instance, Counters.cosine(vec.asFeaturesCounter(), instance));
            }
            List sorted = Counters.toSortedList(scores);
            ClassicCounter<K> classScores = new ClassicCounter<K>();
            for (int i = 0; i < this.k && i < sorted.size(); ++i) {
                K label = this.classLookup.get(sorted.get(i));
                double count = 1.0;
                if (this.weightedVotes) {
                    count = scores.getCount(sorted.get(i));
                }
                classScores.incrementCount(label, count);
            }
            return classScores;
        }
        return null;
    }

    public static void main(String[] args) {
        ArrayList trainingInstances = new ArrayList();
        ClassicCounter<String> f1 = new ClassicCounter<String>();
        f1.setCount("humidity", 5.0);
        f1.setCount("temperature", 35.0);
        trainingInstances.add(new RVFDatum(f1, "rain"));
        f1 = new ClassicCounter();
        f1.setCount("humidity", 4.0);
        f1.setCount("temperature", 32.0);
        trainingInstances.add(new RVFDatum(f1, "rain"));
        f1 = new ClassicCounter();
        f1.setCount("humidity", 6.0);
        f1.setCount("temperature", 30.0);
        trainingInstances.add(new RVFDatum(f1, "rain"));
        f1 = new ClassicCounter();
        f1.setCount("humidity", 2.0);
        f1.setCount("temperature", 33.0);
        trainingInstances.add(new RVFDatum(f1, "dry"));
        f1 = new ClassicCounter();
        f1.setCount("humidity", 1.0);
        f1.setCount("temperature", 34.0);
        trainingInstances.add(new RVFDatum(f1, "dry"));
        KNNClassifier classifier = new KNNClassifierFactory(3, false, true).train(trainingInstances);
        ClassicCounter<String> f12 = new ClassicCounter<String>();
        f12.setCount("humidity", 2.0);
        f12.setCount("temperature", 33.0);
        RVFDatum testVec = new RVFDatum(f12);
        System.out.println(classifier.scoresOf((Datum)testVec));
        System.out.println((String)classifier.classOf(testVec));
    }
}

