/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.classify.RVFDataset;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.ClassicCounter;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;

public class LinearClassifierITest
extends TestCase {
    private static <L, F> RVFDatum<L, F> newDatum(L label, F[] features, Double[] counts) {
        ClassicCounter<F> counter = new ClassicCounter<F>();
        for (int i = 0; i < features.length; ++i) {
            counter.setCount(features[i], counts[i]);
        }
        return new RVFDatum(counter, label);
    }

    private static void testStrBinaryDatums(double d1f1, double d1f2, double d2f1, double d2f2) throws Exception {
        RVFDataset<String, String> trainData = new RVFDataset<String, String>();
        RVFDatum<String, String> d1 = LinearClassifierITest.newDatum("alpha", new String[]{"f1", "f2"}, new Double[]{d1f1, d1f2});
        RVFDatum<String, String> d2 = LinearClassifierITest.newDatum("beta", new String[]{"f1", "f2"}, new Double[]{d2f1, d2f2});
        trainData.add(d1);
        trainData.add(d2);
        LinearClassifierFactory lfc = new LinearClassifierFactory();
        Classifier lc = lfc.trainClassifier((GeneralDataset)trainData);
        Assert.assertEquals((String)d1.label(), (String)((LinearClassifier)lc).classOf(d1));
        Assert.assertEquals((String)d2.label(), (String)((LinearClassifier)lc).classOf(d2));
    }

    public void testStrBinaryDatums() throws Exception {
        LinearClassifierITest.testStrBinaryDatums(-1.0, 0.0, 1.0, 0.0);
        LinearClassifierITest.testStrBinaryDatums(1.0, 0.0, -1.0, 0.0);
        LinearClassifierITest.testStrBinaryDatums(0.0, 1.0, 0.0, -1.0);
        LinearClassifierITest.testStrBinaryDatums(0.0, -1.0, 0.0, 1.0);
        LinearClassifierITest.testStrBinaryDatums(1.0, 1.0, -1.0, -1.0);
        LinearClassifierITest.testStrBinaryDatums(0.0, 1.0, 1.0, 0.0);
        LinearClassifierITest.testStrBinaryDatums(1.0, 0.0, 0.0, 1.0);
    }

    public void testStrMultiClassDatums() throws Exception {
        RVFDataset trainData = new RVFDataset();
        ArrayList<RVFDatum<String, String>> datums = new ArrayList<RVFDatum<String, String>>();
        datums.add(LinearClassifierITest.newDatum("alpha", new String[]{"f1", "f2"}, new Double[]{1.0, 0.0}));
        datums.add(LinearClassifierITest.newDatum("beta", new String[]{"f1", "f2"}, new Double[]{0.0, 1.0}));
        datums.add(LinearClassifierITest.newDatum("charlie", new String[]{"f1", "f2"}, new Double[]{5.0, 5.0}));
        for (RVFDatum rVFDatum : datums) {
            trainData.add(rVFDatum);
        }
        LinearClassifierFactory lfc = new LinearClassifierFactory();
        Classifier classifier = lfc.trainClassifier((GeneralDataset)trainData);
        RVFDatum<String, String> td1 = LinearClassifierITest.newDatum("alpha", new String[]{"f1", "f2", "f3"}, new Double[]{2.0, 0.0, 5.5});
        for (RVFDatum rVFDatum : datums) {
            Assert.assertEquals((String)((String)rVFDatum.label()), (String)((String)((LinearClassifier)classifier).classOf(rVFDatum)));
        }
        Assert.assertEquals((Object)td1.label(), (Object)((LinearClassifier)classifier).classOf(td1));
    }
}

