/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.LogisticUtils;
import edu.stanford.nlp.classify.ProbabilisticClassifier;
import edu.stanford.nlp.classify.RVFClassifier;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Index;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MultinomialLogisticClassifier<L, F>
implements ProbabilisticClassifier<L, F>,
RVFClassifier<L, F> {
    private static final long serialVersionUID = 1L;
    private final double[][] weights;
    private final Index<F> featureIndex;
    private final Index<L> labelIndex;

    public MultinomialLogisticClassifier(double[][] weights, Index<F> featureIndex, Index<L> labelIndex) {
        this.featureIndex = featureIndex;
        this.labelIndex = labelIndex;
        this.weights = weights;
    }

    @Override
    public Collection<L> labels() {
        return this.labelIndex.objectsList();
    }

    @Override
    public L classOf(Datum<L, F> example) {
        return Counters.argmax(this.scoresOf(example));
    }

    @Override
    public Counter<L> scoresOf(Datum<L, F> example) {
        return this.logProbabilityOf(example);
    }

    @Override
    public L classOf(RVFDatum<L, F> example) {
        return this.classOf((Datum<L, F>)example);
    }

    @Override
    public Counter<L> scoresOf(RVFDatum<L, F> example) {
        return this.scoresOf((Datum<L, F>)example);
    }

    @Override
    public Counter<L> probabilityOf(Datum<L, F> example) {
        double[] featureValues;
        int[] featureIndices = LogisticUtils.indicesOf(example.asFeatures(), this.featureIndex);
        if (example instanceof RVFDatum) {
            Collection<Double> featureValuesCollection = ((RVFDatum)example).asFeaturesCounter().values();
            featureValues = LogisticUtils.convertToArray(featureValuesCollection);
        } else {
            featureValues = new double[example.asFeatures().size()];
            Arrays.fill(featureValues, 1.0);
        }
        ClassicCounter<L> result = new ClassicCounter<L>();
        int numClasses = this.labelIndex.size();
        double[] sigmoids = LogisticUtils.calculateSigmoids(this.weights, featureIndices, featureValues);
        for (int c = 0; c < numClasses; ++c) {
            L label = this.labelIndex.get(c);
            result.incrementCount(label, sigmoids[c]);
        }
        return result;
    }

    @Override
    public Counter<L> logProbabilityOf(Datum<L, F> example) {
        Counter<L> result = this.probabilityOf(example);
        Counters.logInPlace(result);
        return result;
    }

    private static <LL, FF> MultinomialLogisticClassifier<LL, FF> load(String path) throws IOException, ClassNotFoundException {
        System.err.print("Loading classifier from " + path + "... ");
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(path));
        double[][] myWeights = (double[][])ErasureUtils.uncheckedCast(in.readObject());
        Index myFeatureIndex = (Index)ErasureUtils.uncheckedCast(in.readObject());
        Index myLabelIndex = (Index)ErasureUtils.uncheckedCast(in.readObject());
        in.close();
        System.err.println("done.");
        return new MultinomialLogisticClassifier(myWeights, myFeatureIndex, myLabelIndex);
    }

    private void save(String path) throws IOException {
        File dir;
        System.out.print("Saving classifier to " + path + "... ");
        int lastSlash = path.lastIndexOf(File.separator);
        if (lastSlash > 0 && !(dir = new File(path.substring(0, lastSlash))).exists()) {
            dir.mkdirs();
        }
        ObjectOutputStream out2 = new ObjectOutputStream(new FileOutputStream(path));
        out2.writeObject(this.weights);
        out2.writeObject(this.featureIndex);
        out2.writeObject(this.labelIndex);
        out2.close();
        System.out.println("done.");
    }

    public Map<L, Counter<F>> weightsAsGenericCounter() {
        HashMap allweights = new HashMap();
        for (int i = 0; i < this.weights.length; ++i) {
            ClassicCounter c = new ClassicCounter();
            L label = this.labelIndex.get(i);
            double[] w = this.weights[i];
            for (Object f : this.featureIndex) {
                int indexf = this.featureIndex.indexOf(f);
                if (w[indexf] == 0.0) continue;
                c.setCount(f, w[indexf]);
            }
            allweights.put(label, c);
        }
        return allweights;
    }
}

