/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.RVFDataset;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.CollectionUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;

public class RVFDatasetTest
extends TestCase {
    public void testCombiningDatasets() {
        RVFDatum<Object, String> datum1 = RVFDatasetTest.newRVFDatum(null, "a", "b", "a");
        RVFDatum<Object, String> datum2 = RVFDatasetTest.newRVFDatum(null, "c", "c", "b");
        RVFDataset<Object, String> data1 = new RVFDataset<Object, String>();
        data1.add(datum1);
        RVFDataset data2 = new RVFDataset();
        data1.add(datum2);
        RVFDataset data = new RVFDataset();
        data.addAll(data1);
        data.addAll(data2);
        Iterator iter = data.iterator();
        Assert.assertEquals(datum1, iter.next());
        Assert.assertEquals(datum2, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    public void testSVMLightIntegerFormat() throws IOException {
        RVFDataset<Boolean, Integer> dataset = new RVFDataset<Boolean, Integer>();
        dataset.add(RVFDatasetTest.newRVFDatum(true, 1, 2, 1, 0));
        dataset.add(RVFDatasetTest.newRVFDatum(false, 2, 2, 0, 0));
        dataset.add(RVFDatasetTest.newRVFDatum(true, 0, 1, 2, 2));
        File tempFile = File.createTempFile("testSVMLightIntegerFormat", ".svm");
        dataset.writeSVMLightFormat(tempFile);
        RVFDataset newDataset = new RVFDataset();
        try {
            newDataset.readSVMLightFormat(tempFile);
            Assert.fail((String)"expected failure with empty indexes");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        newDataset = new RVFDataset(dataset.size(), dataset.featureIndex(), dataset.labelIndex());
        newDataset.readSVMLightFormat(tempFile);
        Assert.assertEquals(CollectionUtils.toList(dataset), CollectionUtils.toList(newDataset));
    }

    private static <L, F> RVFDatum<L, F> newRVFDatum(L label, F ... items) {
        return new RVFDatum<L, F>(Counters.asCounter(Arrays.asList(items)), label);
    }
}

