/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LogPrior;
import edu.stanford.nlp.classify.MultinomialLogisticClassifier;
import edu.stanford.nlp.classify.ShiftParamsLogisticClassifierFactory;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.stats.ClassicCounter;
import junit.framework.Assert;
import org.junit.Test;

public class ShiftParamsLogisticClassifierITest {
    private static <L, F> BasicDatum<L, F> newDatum(L label, F[] features, Double[] counts) {
        ClassicCounter<F> counter = new ClassicCounter<F>();
        for (int i = 0; i < features.length; ++i) {
            counter.setCount(features[i], counts[i]);
        }
        return new BasicDatum(counter.keySet(), label);
    }

    private static void testStrBinaryDatums(double d1f1, double d1f2, double d2f1, double d2f2) throws Exception {
        Dataset<String, String> trainData = new Dataset<String, String>();
        BasicDatum<String, String> d1 = ShiftParamsLogisticClassifierITest.newDatum("alpha", new String[]{"f1", "f2"}, new Double[]{d1f1, d1f2});
        BasicDatum<String, String> d2 = ShiftParamsLogisticClassifierITest.newDatum("beta", new String[]{"f1", "f2"}, new Double[]{d2f1, d2f2});
        trainData.add(d1);
        trainData.add(d2);
        LogPrior prior = new LogPrior(LogPrior.LogPriorType.QUADRATIC, 1.0, 0.1);
        ShiftParamsLogisticClassifierFactory lfc = new ShiftParamsLogisticClassifierFactory(prior, 0.01);
        Classifier lc = lfc.trainClassifier((GeneralDataset)trainData);
        Assert.assertEquals((String)((String)d1.label()), (String)((MultinomialLogisticClassifier)lc).classOf(d1));
        Assert.assertEquals((String)((String)d2.label()), (String)((MultinomialLogisticClassifier)lc).classOf(d2));
    }

    @Test
    public void testStrBinaryDatums() throws Exception {
    }
}

