/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.RVFDataset;
import edu.stanford.nlp.classify.WeightedRVFDataset;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.Counters;
import java.util.Arrays;
import junit.framework.TestCase;

public class WeightedRVFDatasetTest
extends TestCase {
    public void testWeightingWorks() {
        WeightedRVFDataset<Object, String> dataset = new WeightedRVFDataset<Object, String>();
        RVFDatum<Object, String> datum1 = WeightedRVFDatasetTest.newRVFDatum(null, "a", "b", "a");
        dataset.add(datum1, 42.0f);
        RVFDatum<Object, String> datum2 = WeightedRVFDatasetTest.newRVFDatum(null, "a", "b", "a");
        dataset.add(datum2, 7.3f);
        WeightedRVFDatasetTest.assertEquals((double)42.0, (double)dataset.getWeights()[0], (double)1.0E-10);
        WeightedRVFDatasetTest.assertEquals((double)7.3f, (double)dataset.getWeights()[1], (double)1.0E-10);
    }

    public void testBackwardsCompatibility() {
        WeightedRVFDataset<Object, String> dataset = new WeightedRVFDataset<Object, String>();
        RVFDatum<Object, String> datum1 = WeightedRVFDatasetTest.newRVFDatum(null, "a", "b", "a");
        ((RVFDataset)dataset).add(datum1);
        RVFDatum<Object, String> datum2 = WeightedRVFDatasetTest.newRVFDatum(null, "a", "b", "a");
        ((RVFDataset)dataset).add(datum2);
        WeightedRVFDatasetTest.assertEquals((double)1.0, (double)dataset.getWeights()[0], (double)1.0E-10);
        WeightedRVFDatasetTest.assertEquals((double)1.0, (double)dataset.getWeights()[1], (double)1.0E-10);
    }

    public void testMixedCompatibility() {
        WeightedRVFDataset<Object, String> dataset = new WeightedRVFDataset<Object, String>();
        RVFDatum<Object, String> datum1 = WeightedRVFDatasetTest.newRVFDatum(null, "a", "b", "a");
        dataset.add(datum1, 42.0f);
        RVFDatum<Object, String> datum2 = WeightedRVFDatasetTest.newRVFDatum(null, "a", "b", "a");
        dataset.add(datum2);
        RVFDatum<Object, String> datum3 = WeightedRVFDatasetTest.newRVFDatum(null, "a", "b", "a");
        dataset.add(datum3, 7.3f);
        WeightedRVFDatasetTest.assertEquals((double)42.0, (double)dataset.getWeights()[0], (double)1.0E-10);
        WeightedRVFDatasetTest.assertEquals((double)1.0, (double)dataset.getWeights()[1], (double)1.0E-10);
        WeightedRVFDatasetTest.assertEquals((double)7.3f, (double)dataset.getWeights()[2], (double)1.0E-10);
    }

    private static <L, F> RVFDatum<L, F> newRVFDatum(L label, F ... items) {
        return new RVFDatum<L, F>(Counters.asCounter(Arrays.asList(items)), label);
    }
}

