/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.hybrid.sieve;

import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.CorefRules;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.CorefCluster;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.hybrid.HybridCorefPrinter;
import edu.stanford.nlp.coref.hybrid.HybridCorefProperties;
import edu.stanford.nlp.coref.hybrid.rf.RandomForest;
import edu.stanford.nlp.coref.hybrid.sieve.Sieve;
import edu.stanford.nlp.coref.md.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class RFSieve
extends Sieve {
    private static Redwood.RedwoodChannels log = Redwood.channels(RFSieve.class);
    private static final long serialVersionUID = -4090017054885920527L;
    public RandomForest rf;
    public double thresMerge;

    public RFSieve(RandomForest rf, Properties props, String sievename) {
        super(props, sievename);
        this.rf = rf;
        this.props = props;
        this.classifierType = Sieve.ClassifierType.RF;
    }

    @Override
    public void findCoreferentAntecedent(Mention m, int mIdx, Document document, Dictionaries dict, Properties props, StringBuilder sbLog) throws Exception {
        int sentIdx = m.sentNum;
        ClassicCounter<Integer> probs = new ClassicCounter<Integer>();
        int mentionDist = 0;
        for (int sentDist = 0; sentDist <= Math.min(this.maxSentDist, sentIdx); ++sentDist) {
            List<Mention> candidates = RFSieve.getOrderedAntecedents(m, sentIdx - sentDist, mIdx, document.predictedMentions, dict);
            for (Mention candidate : candidates) {
                if (RFSieve.skipForAnalysis(candidate, m, props) || candidate == m || !this.aType.contains((Object)candidate.mentionType) || m.mentionType == Dictionaries.MentionType.PRONOMINAL && (!RFSieve.matchedMentionType(m, this.mTypeStr) || !RFSieve.matchedMentionType(candidate, this.aTypeStr)) || sentDist == 0 && m.appearEarlierThan(candidate)) continue;
                RVFDatum<Boolean, String> datum = RFSieve.extractDatum(m, candidate, document, ++mentionDist, dict, props, this.sievename);
                double probTrue = 0.0;
                if (this.classifierType == Sieve.ClassifierType.RF) {
                    probTrue = this.rf.probabilityOfTrue(datum);
                }
                probs.setCount(candidate.mentionID, probTrue);
            }
        }
        if (HybridCorefProperties.debug(props)) {
            sbLog.append(HybridCorefPrinter.printErrorLog(m, document, probs, mIdx, dict, this));
        }
        if (probs.size() > 0 && Counters.max(probs) > this.thresMerge) {
            int antID = Counters.argmax(probs);
            Sieve.merge(document, m.mentionID, antID);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static RVFDatum<Boolean, String> extractDatum(Mention m, Mention candidate, Document document, int mentionDist, Dictionaries dict, Properties props, String sievename) {
        try {
            CoreLabel aFollowing;
            boolean label = document.goldMentions == null ? false : document.isCoref(m, candidate);
            ClassicCounter<String> features = new ClassicCounter<String>();
            CorefCluster mC = document.corefClusters.get(m.corefClusterID);
            CorefCluster aC = document.corefClusters.get(candidate.corefClusterID);
            CoreLabel mFirst = m.sentenceWords.get(m.startIndex);
            CoreLabel mLast = m.sentenceWords.get(m.endIndex - 1);
            CoreLabel mPreceding = m.startIndex > 0 ? m.sentenceWords.get(m.startIndex - 1) : null;
            CoreLabel mFollowing = m.endIndex < m.sentenceWords.size() ? m.sentenceWords.get(m.endIndex) : null;
            CoreLabel aFirst = candidate.sentenceWords.get(candidate.startIndex);
            CoreLabel aLast = candidate.sentenceWords.get(candidate.endIndex - 1);
            CoreLabel aPreceding = candidate.startIndex > 0 ? candidate.sentenceWords.get(candidate.startIndex - 1) : null;
            CoreLabel coreLabel = aFollowing = candidate.endIndex < candidate.sentenceWords.size() ? candidate.sentenceWords.get(candidate.endIndex) : null;
            if (HybridCorefProperties.useBasicFeatures(props, sievename)) {
                CoreLabel coreLabel2;
                void var21_35;
                void var22_53;
                int sentDist = m.sentNum - candidate.sentNum;
                features.incrementCount("SENTDIST", sentDist);
                features.incrementCount("MENTIONDIST", mentionDist);
                int minSentDist = sentDist;
                for (Mention mention : aC.corefMentions) {
                    minSentDist = Math.min(minSentDist, Math.abs(m.sentNum - mention.sentNum));
                }
                features.incrementCount("MINSENTDIST", minSentDist);
                if (CorefProperties.useConstituencyParse(props) && m.sentNum == candidate.sentNum) {
                    void var21_26;
                    Tree tree;
                    boolean bl = false;
                    Tree tree2 = m.contextParseTree;
                    Tree tree3 = m.mentionSubTree;
                    do {
                        void var23_61;
                        if (!(tree = var23_61.ancestor(1, tree2)).label().value().startsWith("S")) continue;
                        ++var21_26;
                    } while (!tree.dominates(candidate.mentionSubTree) && !tree.label().value().equals("ROOT") && tree.ancestor(1, tree2) != null);
                    features.incrementCount("CLAUSECOUNT", (double)var21_26);
                }
                if (document.docType == Document.DocType.CONVERSATION) {
                    features.incrementCount("B-DOCTYPE-" + (Object)((Object)document.docType));
                }
                if (((String)m.headWord.get(CoreAnnotations.SpeakerAnnotation.class)).equalsIgnoreCase("PER0")) {
                    features.incrementCount("B-SPEAKER-PER0");
                }
                if (document.docInfo != null && document.docInfo.containsKey("DOC_ID")) {
                    features.incrementCount("B-DOCSOURCE-" + document.docInfo.get("DOC_ID").split("/")[1]);
                }
                features.incrementCount("M-LENGTH", m.originalSpan.size());
                features.incrementCount("A-LENGTH", candidate.originalSpan.size());
                if (m.originalSpan.size() < candidate.originalSpan.size()) {
                    features.incrementCount("B-A-ISLONGER");
                }
                features.incrementCount("A-SIZE", aC.getCorefMentions().size());
                features.incrementCount("M-SIZE", mC.getCorefMentions().size());
                String string = "A-NOROLE";
                String string2 = "M-NOROLE";
                if (m.isSubject) {
                    String string3 = "M-SUBJ";
                }
                if (m.isDirectObject) {
                    String string4 = "M-DOBJ";
                }
                if (m.isIndirectObject) {
                    String string5 = "M-IOBJ";
                }
                if (m.isPrepositionObject) {
                    String string6 = "M-POBJ";
                }
                if (candidate.isSubject) {
                    String string7 = "A-SUBJ";
                }
                if (candidate.isDirectObject) {
                    String string8 = "A-DOBJ";
                }
                if (candidate.isIndirectObject) {
                    String string9 = "A-IOBJ";
                }
                if (candidate.isPrepositionObject) {
                    String string10 = "A-POBJ";
                }
                features.incrementCount("B-" + (String)var22_53);
                features.incrementCount("B-" + (String)var21_35);
                features.incrementCount("B-" + (String)var21_35 + "-" + (String)var22_53);
                if (HybridCorefProperties.combineObjectRoles(props, sievename) && (m.isDirectObject || m.isIndirectObject || m.isPrepositionObject || candidate.isDirectObject || candidate.isIndirectObject || candidate.isPrepositionObject)) {
                    void var22_55;
                    void var21_37;
                    if (m.isDirectObject || m.isIndirectObject || m.isPrepositionObject) {
                        String string11 = "M-OBJ";
                        features.incrementCount("B-M-OBJ");
                    }
                    if (candidate.isDirectObject || candidate.isIndirectObject || candidate.isPrepositionObject) {
                        String string12 = "A-OBJ";
                        features.incrementCount("B-A-OBJ");
                    }
                    features.incrementCount("B-" + (String)var21_37 + "-" + (String)var22_55);
                }
                if (mFirst.word().toLowerCase().matches("a|an")) {
                    features.incrementCount("B-M-START-WITH-INDEFINITE");
                }
                if (aFirst.word().toLowerCase().matches("a|an")) {
                    features.incrementCount("B-A-START-WITH-INDEFINITE");
                }
                if (mFirst.word().equalsIgnoreCase("the")) {
                    features.incrementCount("B-M-START-WITH-DEFINITE");
                }
                if (aFirst.word().equalsIgnoreCase("the")) {
                    features.incrementCount("B-A-START-WITH-DEFINITE");
                }
                if (dict.indefinitePronouns.contains(m.lowercaseNormalizedSpanString())) {
                    features.incrementCount("B-M-INDEFINITE-PRONOUN");
                }
                if (dict.indefinitePronouns.contains(candidate.lowercaseNormalizedSpanString())) {
                    features.incrementCount("B-A-INDEFINITE-PRONOUN");
                }
                if (dict.indefinitePronouns.contains(mFirst.word().toLowerCase())) {
                    features.incrementCount("B-M-INDEFINITE-ADJ");
                }
                if (dict.indefinitePronouns.contains(aFirst.word().toLowerCase())) {
                    features.incrementCount("B-A-INDEFINITE-ADJ");
                }
                if (dict.reflexivePronouns.contains(m.headString)) {
                    features.incrementCount("B-M-REFLEXIVE");
                }
                if (dict.reflexivePronouns.contains(candidate.headString)) {
                    features.incrementCount("B-A-REFLEXIVE");
                }
                if (m.headIndex == m.endIndex - 1) {
                    features.incrementCount("B-M-HEADEND");
                }
                if (m.headIndex < m.endIndex - 1 && ((coreLabel2 = m.sentenceWords.get(m.headIndex + 1)).word().matches("that|,") || coreLabel2.tag().startsWith("W"))) {
                    features.incrementCount("B-M-HASPOSTPHRASE");
                    if (mFirst.tag().equals("DT") && mFirst.word().toLowerCase().matches("the|this|these|those")) {
                        features.incrementCount("B-M-THE-HASPOSTPHRASE");
                    } else if (mFirst.word().toLowerCase().matches("a|an")) {
                        features.incrementCount("B-M-INDEFINITE-HASPOSTPHRASE");
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                ArrayList<Mention> arrayList = new ArrayList<Mention>(aC.corefMentions.size());
                arrayList.addAll(aC.corefMentions);
                Collections.sort(arrayList, new CorefChain.MentionComparator());
                for (Mention mention : arrayList) {
                    stringBuilder.append((Object)mention.mentionType).append("-");
                }
                features.incrementCount("B-A-SHAPE-" + stringBuilder.toString());
                StringBuilder stringBuilder2 = new StringBuilder();
                ArrayList<Mention> arrayList2 = new ArrayList<Mention>(mC.corefMentions.size());
                arrayList2.addAll(mC.corefMentions);
                Collections.sort(arrayList2, new CorefChain.MentionComparator());
                for (Mention mention : arrayList2) {
                    stringBuilder2.append((Object)mention.mentionType).append("-");
                }
                features.incrementCount("B-M-SHAPE-" + stringBuilder2.toString());
                if (CorefProperties.useConstituencyParse(props)) {
                    StringBuilder stringBuilder3 = new StringBuilder();
                    Tree mTree = m.contextParseTree;
                    Tree tree = ((Tree)mTree.getLeaves().get(m.headIndex)).ancestor(1, mTree);
                    for (Tree node : mTree.pathNodeToNode(tree, mTree)) {
                        stringBuilder3.append(node.value()).append("-");
                        if (!node.value().equals("S")) continue;
                        break;
                    }
                    features.incrementCount("B-M-SYNPATH-" + stringBuilder3.toString());
                    StringBuilder stringBuilder4 = new StringBuilder();
                    Tree tree4 = candidate.contextParseTree;
                    Tree aHead = ((Tree)tree4.getLeaves().get(candidate.headIndex)).ancestor(1, tree4);
                    for (Tree node : tree4.pathNodeToNode(aHead, tree4)) {
                        stringBuilder4.append(node.value()).append("-");
                        if (!node.value().equals("S")) continue;
                        break;
                    }
                    features.incrementCount("B-A-SYNPATH-" + stringBuilder4.toString());
                }
                features.incrementCount("A-FIRSTAPPEAR", aC.representative.sentNum);
                features.incrementCount("M-FIRSTAPPEAR", mC.representative.sentNum);
                int docSize = document.predictedMentions.size();
                features.incrementCount("A-FIRSTAPPEAR-NORMALIZED", aC.representative.sentNum / docSize);
                features.incrementCount("M-FIRSTAPPEAR-NORMALIZED", mC.representative.sentNum / docSize);
            }
            if (HybridCorefProperties.useMentionDetectionFeatures(props, sievename)) {
                if (m.originalSpan.size() == 1 && m.headWord.tag().equals("NNS")) {
                    features.incrementCount("B-M-BAREPLURAL");
                }
                if (candidate.originalSpan.size() == 1 && candidate.headWord.tag().equals("NNS")) {
                    features.incrementCount("B-A-BAREPLURAL");
                }
                if (CorefProperties.useConstituencyParse(props) && (RuleBasedCorefMentionFinder.isPleonastic(m, m.contextParseTree) || RuleBasedCorefMentionFinder.isPleonastic(candidate, candidate.contextParseTree))) {
                    features.incrementCount("B-PLEONASTICIT");
                }
                if (dict.quantifiers.contains(mFirst.word().toLowerCase(Locale.ENGLISH))) {
                    features.incrementCount("B-M-QUANTIFIER");
                }
                if (dict.quantifiers.contains(aFirst.word().toLowerCase(Locale.ENGLISH))) {
                    features.incrementCount("B-A-QUANTIFIER");
                }
                if (mFirst.word().toLowerCase(Locale.ENGLISH).matches("none|no|nothing|not") || aFirst.word().toLowerCase(Locale.ENGLISH).matches("none|no|nothing|not")) {
                    features.incrementCount("B-NEGATIVE-START");
                }
                if (RuleBasedCorefMentionFinder.partitiveRule(m, m.sentenceWords, dict)) {
                    features.incrementCount("B-M-PARTITIVE");
                }
                if (RuleBasedCorefMentionFinder.partitiveRule(candidate, candidate.sentenceWords, dict)) {
                    features.incrementCount("B-A-PARTITIVE");
                }
                if (m.headString.equals("%")) {
                    features.incrementCount("B-M-HEAD%");
                }
                if (candidate.headString.equals("%")) {
                    features.incrementCount("B-A-HEAD%");
                }
                if (dict.isAdjectivalDemonym(m.spanToString())) {
                    features.incrementCount("B-M-ADJ-DEMONYM");
                }
                if (dict.isAdjectivalDemonym(candidate.spanToString())) {
                    features.incrementCount("B-A-ADJ-DEMONYM");
                }
                if (m.lowercaseNormalizedSpanString().endsWith("etc.")) {
                    features.incrementCount("B-M-ETC-END");
                }
                if (candidate.lowercaseNormalizedSpanString().endsWith("etc.")) {
                    features.incrementCount("B-A-ETC-END");
                }
            }
            features.incrementCount("B-M-NUMBER-" + (Object)((Object)m.number));
            features.incrementCount("B-A-NUMBER-" + (Object)((Object)candidate.number));
            features.incrementCount("B-M-GENDER-" + (Object)((Object)m.gender));
            features.incrementCount("B-A-GENDER-" + (Object)((Object)candidate.gender));
            features.incrementCount("B-M-ANIMACY-" + (Object)((Object)m.animacy));
            features.incrementCount("B-A-ANIMACY-" + (Object)((Object)candidate.animacy));
            features.incrementCount("B-M-PERSON-" + (Object)((Object)m.person));
            features.incrementCount("B-A-PERSON-" + (Object)((Object)candidate.person));
            features.incrementCount("B-M-NETYPE-" + m.nerString);
            features.incrementCount("B-A-NETYPE-" + candidate.nerString);
            features.incrementCount("B-BOTH-NUMBER-" + (Object)((Object)candidate.number) + "-" + (Object)((Object)m.number));
            features.incrementCount("B-BOTH-GENDER-" + (Object)((Object)candidate.gender) + "-" + (Object)((Object)m.gender));
            features.incrementCount("B-BOTH-ANIMACY-" + (Object)((Object)candidate.animacy) + "-" + (Object)((Object)m.animacy));
            features.incrementCount("B-BOTH-PERSON-" + (Object)((Object)candidate.person) + "-" + (Object)((Object)m.person));
            features.incrementCount("B-BOTH-NETYPE-" + candidate.nerString + "-" + m.nerString);
            Set<Dictionaries.Number> mcNumber = Generics.newHashSet();
            for (Dictionaries.Number number : mC.numbers) {
                features.incrementCount("B-MC-NUMBER-" + (Object)((Object)number));
                mcNumber.add(number);
            }
            if (mcNumber.size() == 1) {
                features.incrementCount("B-MC-CLUSTERNUMBER-" + mcNumber.iterator().next());
            } else {
                mcNumber.remove((Object)Dictionaries.Number.UNKNOWN);
                if (mcNumber.size() == 1) {
                    features.incrementCount("B-MC-CLUSTERNUMBER-" + mcNumber.iterator().next());
                } else {
                    features.incrementCount("B-MC-CLUSTERNUMBER-CONFLICT");
                }
            }
            Set<Dictionaries.Gender> mcGender = Generics.newHashSet();
            for (Dictionaries.Gender gender : mC.genders) {
                features.incrementCount("B-MC-GENDER-" + (Object)((Object)gender));
                mcGender.add(gender);
            }
            if (mcGender.size() == 1) {
                features.incrementCount("B-MC-CLUSTERGENDER-" + mcGender.iterator().next());
            } else {
                mcGender.remove((Object)Dictionaries.Gender.UNKNOWN);
                if (mcGender.size() == 1) {
                    features.incrementCount("B-MC-CLUSTERGENDER-" + mcGender.iterator().next());
                } else {
                    features.incrementCount("B-MC-CLUSTERGENDER-CONFLICT");
                }
            }
            Set<Dictionaries.Animacy> set = Generics.newHashSet();
            for (Dictionaries.Animacy animacy : mC.animacies) {
                features.incrementCount("B-MC-ANIMACY-" + (Object)((Object)animacy));
                set.add(animacy);
            }
            if (set.size() == 1) {
                features.incrementCount("B-MC-CLUSTERANIMACY-" + set.iterator().next());
            } else {
                set.remove((Object)Dictionaries.Animacy.UNKNOWN);
                if (set.size() == 1) {
                    features.incrementCount("B-MC-CLUSTERANIMACY-" + set.iterator().next());
                } else {
                    features.incrementCount("B-MC-CLUSTERANIMACY-CONFLICT");
                }
            }
            Set<String> set2 = Generics.newHashSet();
            for (String string : mC.nerStrings) {
                features.incrementCount("B-MC-NETYPE-" + string);
                set2.add(string);
            }
            if (set2.size() == 1) {
                features.incrementCount("B-MC-CLUSTERNETYPE-" + (String)set2.iterator().next());
            } else {
                set2.remove("O");
                if (set2.size() == 1) {
                    features.incrementCount("B-MC-CLUSTERNETYPE-" + (String)set2.iterator().next());
                } else {
                    features.incrementCount("B-MC-CLUSTERNETYPE-CONFLICT");
                }
            }
            Set<Dictionaries.Number> set3 = Generics.newHashSet();
            for (Dictionaries.Number n : aC.numbers) {
                features.incrementCount("B-AC-NUMBER-" + (Object)((Object)n));
                set3.add(n);
            }
            if (set3.size() == 1) {
                features.incrementCount("B-AC-CLUSTERNUMBER-" + set3.iterator().next());
            } else {
                set3.remove((Object)Dictionaries.Number.UNKNOWN);
                if (set3.size() == 1) {
                    features.incrementCount("B-AC-CLUSTERNUMBER-" + set3.iterator().next());
                } else {
                    features.incrementCount("B-AC-CLUSTERNUMBER-CONFLICT");
                }
            }
            Set<Dictionaries.Gender> set4 = Generics.newHashSet();
            for (Dictionaries.Gender gender : aC.genders) {
                features.incrementCount("B-AC-GENDER-" + (Object)((Object)gender));
                set4.add(gender);
            }
            if (set4.size() == 1) {
                features.incrementCount("B-AC-CLUSTERGENDER-" + set4.iterator().next());
            } else {
                set4.remove((Object)Dictionaries.Gender.UNKNOWN);
                if (set4.size() == 1) {
                    features.incrementCount("B-AC-CLUSTERGENDER-" + set4.iterator().next());
                } else {
                    features.incrementCount("B-AC-CLUSTERGENDER-CONFLICT");
                }
            }
            Set<Dictionaries.Animacy> acAnimacy = Generics.newHashSet();
            for (Dictionaries.Animacy animacy : aC.animacies) {
                features.incrementCount("B-AC-ANIMACY-" + (Object)((Object)animacy));
                acAnimacy.add(animacy);
            }
            if (acAnimacy.size() == 1) {
                features.incrementCount("B-AC-CLUSTERANIMACY-" + acAnimacy.iterator().next());
            } else {
                acAnimacy.remove((Object)Dictionaries.Animacy.UNKNOWN);
                if (acAnimacy.size() == 1) {
                    features.incrementCount("B-AC-CLUSTERANIMACY-" + acAnimacy.iterator().next());
                } else {
                    features.incrementCount("B-AC-CLUSTERANIMACY-CONFLICT");
                }
            }
            Set<String> set5 = Generics.newHashSet();
            for (String t : aC.nerStrings) {
                features.incrementCount("B-AC-NETYPE-" + t);
                set5.add(t);
            }
            if (set5.size() == 1) {
                features.incrementCount("B-AC-CLUSTERNETYPE-" + (String)set5.iterator().next());
            } else {
                set5.remove("O");
                if (set5.size() == 1) {
                    features.incrementCount("B-AC-CLUSTERNETYPE-" + (String)set5.iterator().next());
                } else {
                    features.incrementCount("B-AC-CLUSTERNETYPE-CONFLICT");
                }
            }
            if (m.numbersAgree(candidate)) {
                features.incrementCount("B-NUMBER-AGREE");
            }
            if (m.gendersAgree(candidate)) {
                features.incrementCount("B-GENDER-AGREE");
            }
            if (m.animaciesAgree(candidate)) {
                features.incrementCount("B-ANIMACY-AGREE");
            }
            if (CorefRules.entityAttributesAgree(mC, aC)) {
                features.incrementCount("B-ATTRIBUTES-AGREE");
            }
            if (CorefRules.entityPersonDisagree(document, m, candidate, dict)) {
                features.incrementCount("B-PERSON-DISAGREE");
            }
            if (HybridCorefProperties.useDcorefRules(props, sievename)) {
                Set<Dictionaries.MentionType> set6;
                if (CorefRules.entityIWithinI(m, candidate, dict)) {
                    features.incrementCount("B-i-within-i");
                }
                if (CorefRules.antecedentIsMentionSpeaker(document, m, candidate, dict)) {
                    features.incrementCount("B-ANT-IS-SPEAKER");
                }
                if (CorefRules.entitySameSpeaker(document, m, candidate)) {
                    features.incrementCount("B-SAME-SPEAKER");
                }
                if (CorefRules.entitySubjectObject(m, candidate)) {
                    features.incrementCount("B-SUBJ-OBJ");
                }
                for (Mention a : aC.corefMentions) {
                    if (!CorefRules.entitySubjectObject(m, a)) continue;
                    features.incrementCount("B-CLUSTER-SUBJ-OBJ");
                }
                if (CorefRules.entityPersonDisagree(document, m, candidate, dict) && CorefRules.entitySameSpeaker(document, m, candidate)) {
                    features.incrementCount("B-PERSON-DISAGREE-SAME-SPEAKER");
                }
                if (CorefRules.entityIWithinI(mC, aC, dict)) {
                    features.incrementCount("B-ENTITY-IWITHINI");
                }
                if (CorefRules.antecedentMatchesMentionSpeakerAnnotation(m, candidate, document)) {
                    features.incrementCount("B-ANT-IS-SPEAKER-OF-MENTION");
                }
                if ((set6 = HybridCorefProperties.getMentionType(props, sievename)).contains((Object)Dictionaries.MentionType.PROPER) || set6.contains((Object)Dictionaries.MentionType.NOMINAL)) {
                    if (m.headString.equals(candidate.headString)) {
                        features.incrementCount("B-HEADMATCH");
                    }
                    if (CorefRules.entityHeadsAgree(mC, aC, m, candidate, dict)) {
                        features.incrementCount("B-HEADSAGREE");
                    }
                    if (CorefRules.entityExactStringMatch(mC, aC, dict, document.roleSet)) {
                        features.incrementCount("B-EXACTSTRINGMATCH");
                    }
                    if (CorefRules.entityHaveExtraProperNoun(m, candidate, new HashSet<String>())) {
                        features.incrementCount("B-HAVE-EXTRA-PROPER-NOUN");
                    }
                    if (CorefRules.entityBothHaveProper(mC, aC)) {
                        features.incrementCount("B-BOTH-HAVE-PROPER");
                    }
                    if (CorefRules.entityHaveDifferentLocation(m, candidate, dict)) {
                        features.incrementCount("B-HAVE-DIFF-LOC");
                    }
                    if (CorefRules.entityHaveIncompatibleModifier(mC, aC)) {
                        features.incrementCount("B-HAVE-INCOMPATIBLE-MODIFIER");
                    }
                    if (CorefRules.entityIsAcronym(document, mC, aC)) {
                        features.incrementCount("B-IS-ACRONYM");
                    }
                    if (CorefRules.entityIsApposition(mC, aC, m, candidate)) {
                        features.incrementCount("B-IS-APPOSITION");
                    }
                    if (CorefRules.entityIsPredicateNominatives(mC, aC, m, candidate)) {
                        features.incrementCount("B-IS-PREDICATE-NOMINATIVES");
                    }
                    if (CorefRules.entityIsRoleAppositive(mC, aC, m, candidate, dict)) {
                        features.incrementCount("B-IS-ROLE-APPOSITIVE");
                    }
                    if (CorefRules.entityNumberInLaterMention(m, candidate)) {
                        features.incrementCount("B-NUMBER-IN-LATER");
                    }
                    if (CorefRules.entityRelaxedExactStringMatch(mC, aC, m, candidate, dict, document.roleSet)) {
                        features.incrementCount("B-RELAXED-EXACT-STRING-MATCH");
                    }
                    if (CorefRules.entityRelaxedHeadsAgreeBetweenMentions(mC, aC, m, candidate)) {
                        features.incrementCount("B-RELAXED-HEAD-AGREE");
                    }
                    if (CorefRules.entitySameProperHeadLastWord(m, candidate)) {
                        features.incrementCount("B-SAME-PROPER-HEAD");
                    }
                    if (CorefRules.entitySameProperHeadLastWord(mC, aC, m, candidate)) {
                        features.incrementCount("B-CLUSTER-SAME-PROPER-HEAD");
                    }
                    if (CorefRules.entityWordsIncluded(mC, aC, m, candidate)) {
                        features.incrementCount("B-WORD-INCLUSION");
                    }
                }
                if (set6.contains((Object)Dictionaries.MentionType.LIST)) {
                    features.incrementCount("NUM-LIST-", RFSieve.numEntitiesInList(m));
                    if (m.spanToString().contains("two") || m.spanToString().contains("2") || m.spanToString().contains("both")) {
                        features.incrementCount("LIST-M-TWO");
                    }
                    if (m.spanToString().contains("three") || m.spanToString().contains("3")) {
                        features.incrementCount("LIST-M-THREE");
                    }
                    if (candidate.spanToString().contains("two") || candidate.spanToString().contains("2") || candidate.spanToString().contains("both")) {
                        features.incrementCount("B-LIST-A-TWO");
                    }
                    if (candidate.spanToString().contains("three") || candidate.spanToString().contains("3")) {
                        features.incrementCount("B-LIST-A-THREE");
                    }
                }
                if (set6.contains((Object)Dictionaries.MentionType.PRONOMINAL)) {
                    CoreLabel nextword;
                    if (dict.firstPersonPronouns.contains(m.headString)) {
                        features.incrementCount("B-M-I");
                    }
                    if (dict.secondPersonPronouns.contains(m.headString)) {
                        features.incrementCount("B-M-YOU");
                    }
                    if (dict.thirdPersonPronouns.contains(m.headString)) {
                        features.incrementCount("B-M-3RDPERSON");
                    }
                    if (dict.possessivePronouns.contains(m.headString)) {
                        features.incrementCount("B-M-POSSESSIVE");
                    }
                    if (dict.neutralPronouns.contains(m.headString)) {
                        features.incrementCount("B-M-NEUTRAL");
                    }
                    if (dict.malePronouns.contains(m.headString)) {
                        features.incrementCount("B-M-MALE");
                    }
                    if (dict.femalePronouns.contains(m.headString)) {
                        features.incrementCount("B-M-FEMALE");
                    }
                    if (dict.firstPersonPronouns.contains(candidate.headString)) {
                        features.incrementCount("B-A-I");
                    }
                    if (dict.secondPersonPronouns.contains(candidate.headString)) {
                        features.incrementCount("B-A-YOU");
                    }
                    if (dict.thirdPersonPronouns.contains(candidate.headString)) {
                        features.incrementCount("B-A-3RDPERSON");
                    }
                    if (dict.possessivePronouns.contains(candidate.headString)) {
                        features.incrementCount("B-A-POSSESSIVE");
                    }
                    if (dict.neutralPronouns.contains(candidate.headString)) {
                        features.incrementCount("B-A-NEUTRAL");
                    }
                    if (dict.malePronouns.contains(candidate.headString)) {
                        features.incrementCount("B-A-MALE");
                    }
                    if (dict.femalePronouns.contains(candidate.headString)) {
                        features.incrementCount("B-A-FEMALE");
                    }
                    features.incrementCount("B-M-GENERIC-" + m.generic);
                    features.incrementCount("B-A-GENERIC-" + candidate.generic);
                    if (HybridCorefPrinter.dcorefPronounSieve.skipThisMention(document, m, mC, dict)) {
                        features.incrementCount("B-SKIPTHISMENTION-true");
                    }
                    if (m.spanToString().equalsIgnoreCase("you") && mFollowing != null && mFollowing.word().equalsIgnoreCase("know")) {
                        features.incrementCount("B-YOUKNOW-PRECEDING-POS-" + (mPreceding == null ? "NULL" : mPreceding.tag()));
                        features.incrementCount("B-YOUKNOW-PRECEDING-WORD-" + (mPreceding == null ? "NULL" : mPreceding.word().toLowerCase()));
                        nextword = m.endIndex + 1 < m.sentenceWords.size() ? m.sentenceWords.get(m.endIndex + 1) : null;
                        features.incrementCount("B-YOUKNOW-FOLLOWING-POS-" + (nextword == null ? "NULL" : nextword.tag()));
                        features.incrementCount("B-YOUKNOW-FOLLOWING-WORD-" + (nextword == null ? "NULL" : nextword.word().toLowerCase()));
                    }
                    if (candidate.spanToString().equalsIgnoreCase("you") && aFollowing != null && aFollowing.word().equalsIgnoreCase("know")) {
                        features.incrementCount("B-YOUKNOW-PRECEDING-POS-" + (aPreceding == null ? "NULL" : aPreceding.tag()));
                        features.incrementCount("B-YOUKNOW-PRECEDING-WORD-" + (aPreceding == null ? "NULL" : aPreceding.word().toLowerCase()));
                        nextword = candidate.endIndex + 1 < candidate.sentenceWords.size() ? candidate.sentenceWords.get(candidate.endIndex + 1) : null;
                        features.incrementCount("B-YOUKNOW-FOLLOWING-POS-" + (nextword == null ? "NULL" : nextword.tag()));
                        features.incrementCount("B-YOUKNOW-FOLLOWING-WORD-" + (nextword == null ? "NULL" : nextword.word().toLowerCase()));
                    }
                }
                if (m.person == Dictionaries.Person.YOU && document.docType == Document.DocType.ARTICLE && ((String)m.headWord.get(CoreAnnotations.SpeakerAnnotation.class)).equals("PER0")) {
                    features.incrementCount("B-DISCOURSE-M-YOU-GENERIC?");
                }
                if (candidate.generic && candidate.person == Dictionaries.Person.YOU) {
                    features.incrementCount("B-DISCOURSE-A-YOU-GENERIC?");
                }
                String mString = m.lowercaseNormalizedSpanString();
                String antString = candidate.lowercaseNormalizedSpanString();
                if (m.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(mString) && candidate.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(antString) && CorefRules.entitySameSpeaker(document, m, candidate)) {
                    features.incrementCount("B-DISCOURSE-I-I-SAMESPEAKER");
                }
                if (m.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(mString) && CorefRules.antecedentIsMentionSpeaker(document, m, candidate, dict)) {
                    features.incrementCount("B-DISCOURSE-SPEAKER-I");
                }
                if (candidate.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(antString) && CorefRules.antecedentIsMentionSpeaker(document, candidate, m, dict)) {
                    features.incrementCount("B-DISCOURSE-I-SPEAKER");
                }
                if (dict.secondPersonPronouns.contains(mString) && dict.secondPersonPronouns.contains(antString) && CorefRules.entitySameSpeaker(document, m, candidate)) {
                    features.incrementCount("B-DISCOURSE-BOTH-YOU");
                }
                if ((m.person == Dictionaries.Person.I && candidate.person == Dictionaries.Person.YOU || m.person == Dictionaries.Person.YOU && candidate.person == Dictionaries.Person.I) && (Integer)m.headWord.get(CoreAnnotations.UtteranceAnnotation.class) - (Integer)candidate.headWord.get(CoreAnnotations.UtteranceAnnotation.class) == 1 && document.docType == Document.DocType.CONVERSATION) {
                    features.incrementCount("B-DISCOURSE-I-YOU");
                }
                if (dict.reflexivePronouns.contains(m.headString) && CorefRules.entitySubjectObject(m, candidate)) {
                    features.incrementCount("B-DISCOURSE-REFLEXIVE");
                }
                if (m.person == Dictionaries.Person.I && candidate.person == Dictionaries.Person.I && !CorefRules.entitySameSpeaker(document, m, candidate)) {
                    features.incrementCount("B-DISCOURSE-I-I-DIFFSPEAKER");
                }
                if (m.person == Dictionaries.Person.YOU && candidate.person == Dictionaries.Person.YOU && !CorefRules.entitySameSpeaker(document, m, candidate)) {
                    features.incrementCount("B-DISCOURSE-YOU-YOU-DIFFSPEAKER");
                }
                if (m.person == Dictionaries.Person.WE && candidate.person == Dictionaries.Person.WE && !CorefRules.entitySameSpeaker(document, m, candidate)) {
                    features.incrementCount("B-DISCOURSE-WE-WE-DIFFSPEAKER");
                }
            }
            if (HybridCorefProperties.usePOSFeatures(props, sievename)) {
                features.incrementCount("B-LEXICAL-M-HEADPOS-" + m.headWord.tag());
                features.incrementCount("B-LEXICAL-A-HEADPOS-" + candidate.headWord.tag());
                features.incrementCount("B-LEXICAL-M-FIRSTPOS-" + mFirst.tag());
                features.incrementCount("B-LEXICAL-A-FIRSTPOS-" + aFirst.tag());
                features.incrementCount("B-LEXICAL-M-LASTPOS-" + mLast.tag());
                features.incrementCount("B-LEXICAL-A-LASTPOS-" + aLast.tag());
                features.incrementCount("B-LEXICAL-M-PRECEDINGPOS-" + (mPreceding == null ? "NULL" : mPreceding.tag()));
                features.incrementCount("B-LEXICAL-A-PRECEDINGPOS-" + (aPreceding == null ? "NULL" : aPreceding.tag()));
                features.incrementCount("B-LEXICAL-M-FOLLOWINGPOS-" + (mFollowing == null ? "NULL" : mFollowing.tag()));
                features.incrementCount("B-LEXICAL-A-FOLLOWINGPOS-" + (aFollowing == null ? "NULL" : aFollowing.tag()));
            }
            if (HybridCorefProperties.useLexicalFeatures(props, sievename)) {
                features.incrementCount("B-LEXICAL-M-HEADWORD-" + m.headString.toLowerCase());
                features.incrementCount("B-LEXICAL-A-HEADWORD-" + candidate.headString.toLowerCase());
                features.incrementCount("B-LEXICAL-M-FIRSTWORD-" + mFirst.word().toLowerCase());
                features.incrementCount("B-LEXICAL-A-FIRSTWORD-" + aFirst.word().toLowerCase());
                features.incrementCount("B-LEXICAL-M-LASTWORD-" + mLast.word().toLowerCase());
                features.incrementCount("B-LEXICAL-A-LASTWORD-" + aLast.word().toLowerCase());
                features.incrementCount("B-LEXICAL-M-PRECEDINGWORD-" + (mPreceding == null ? "NULL" : mPreceding.word().toLowerCase()));
                features.incrementCount("B-LEXICAL-A-PRECEDINGWORD-" + (aPreceding == null ? "NULL" : aPreceding.word().toLowerCase()));
                features.incrementCount("B-LEXICAL-M-FOLLOWINGWORD-" + (mFollowing == null ? "NULL" : mFollowing.word().toLowerCase()));
                features.incrementCount("B-LEXICAL-A-FOLLOWINGWORD-" + (aFollowing == null ? "NULL" : aFollowing.word().toLowerCase()));
                for (String mHead : mC.heads) {
                    if (aC.heads.contains(mHead)) continue;
                    features.incrementCount("B-LEXICAL-MC-EXTRAHEAD-" + mHead);
                }
                for (String mWord : mC.words) {
                    if (aC.words.contains(mWord)) continue;
                    features.incrementCount("B-LEXICAL-MC-EXTRAWORD-" + mWord);
                }
            }
            if (HybridCorefProperties.useWordEmbedding(props, sievename)) {
                float[] v;
                int n = ((float[])dict.vectors.entrySet().iterator().next().getValue()).length;
                float[] mV = (float[])dict.vectors.get(m.headString.toLowerCase());
                float[] aV = (float[])dict.vectors.get(candidate.headString.toLowerCase());
                if (mV != null && aV != null) {
                    features.incrementCount("WORDVECTOR-DIFF-HEADWORD", RFSieve.cosine(mV, aV));
                }
                mV = (float[])dict.vectors.get(mFirst.word().toLowerCase());
                aV = (float[])dict.vectors.get(aFirst.word().toLowerCase());
                if (mV != null && aV != null) {
                    features.incrementCount("WORDVECTOR-DIFF-FIRSTWORD", RFSieve.cosine(mV, aV));
                }
                mV = (float[])dict.vectors.get(mLast.word().toLowerCase());
                aV = (float[])dict.vectors.get(aLast.word().toLowerCase());
                if (mV != null && aV != null) {
                    features.incrementCount("WORDVECTOR-DIFF-LASTWORD", RFSieve.cosine(mV, aV));
                }
                if (mPreceding != null && aPreceding != null) {
                    mV = (float[])dict.vectors.get(mPreceding.word().toLowerCase());
                    aV = (float[])dict.vectors.get(aPreceding.word().toLowerCase());
                    if (mV != null && aV != null) {
                        features.incrementCount("WORDVECTOR-DIFF-PRECEDINGWORD", RFSieve.cosine(mV, aV));
                    }
                }
                if (mFollowing != null && aFollowing != null) {
                    mV = (float[])dict.vectors.get(mFollowing.word().toLowerCase());
                    aV = (float[])dict.vectors.get(aFollowing.word().toLowerCase());
                    if (mV != null && aV != null) {
                        features.incrementCount("WORDVECTOR-DIFF-FOLLOWINGWORD", RFSieve.cosine(mV, aV));
                    }
                }
                float[] aggreM = new float[n];
                float[] aggreA = new float[n];
                for (CoreLabel cl : m.originalSpan) {
                    v = (float[])dict.vectors.get(cl.word().toLowerCase());
                    if (v == null) continue;
                    ArrayMath.pairwiseAddInPlace(aggreM, v);
                }
                for (CoreLabel cl : candidate.originalSpan) {
                    v = (float[])dict.vectors.get(cl.word().toLowerCase());
                    if (v == null) continue;
                    ArrayMath.pairwiseAddInPlace(aggreA, v);
                }
                if (ArrayMath.L2Norm(aggreM) != 0.0f && ArrayMath.L2Norm(aggreA) != 0.0f) {
                    features.incrementCount("WORDVECTOR-AGGREGATE-DIFF", RFSieve.cosine(aggreM, aggreA));
                }
                int cnt = 0;
                double dist = 0.0;
                for (CoreLabel mcl : m.originalSpan) {
                    for (CoreLabel acl : candidate.originalSpan) {
                        mV = (float[])dict.vectors.get(mcl.word().toLowerCase());
                        aV = (float[])dict.vectors.get(acl.word().toLowerCase());
                        if (mV == null || aV == null) continue;
                        ++cnt;
                        dist += RFSieve.cosine(mV, aV);
                    }
                }
                features.incrementCount("WORDVECTOR-AVG-DIFF", dist / (double)cnt);
            }
            return new RVFDatum<Boolean, String>(features, label);
        }
        catch (Exception e) {
            log.info("Datum Extraction failed in Sieve.java while processing document: " + document.docInfo.get("DOC_ID") + " part: " + document.docInfo.get("DOC_PART"));
            throw new RuntimeException(e);
        }
    }

    private static double cosine(float[] normalizedVector1, float[] normalizedVector2) {
        double inner = ArrayMath.innerProduct(normalizedVector1, normalizedVector2);
        return inner;
    }

    public static int numEntitiesInList(Mention m) {
        int num = 0;
        for (int i = 1; i < m.originalSpan.size(); ++i) {
            CoreLabel cl = m.originalSpan.get(i);
            if (cl.word().equals(",")) {
                ++num;
            }
            if (!cl.word().equalsIgnoreCase("and") && !cl.word().equalsIgnoreCase("or") || m.originalSpan.get(i - 1).word().equals(",")) continue;
            ++num;
        }
        return num;
    }
}

