/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.KBPRelationExtractor;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class KBPRelationExtractorTest {
    @Test
    public void testAccuracySimple() {
        KBPRelationExtractor.Accuracy accuracy = new KBPRelationExtractor.Accuracy();
        accuracy.predict(new HashSet<String>(Arrays.asList("a")), new HashSet<String>(Arrays.asList("a")));
        accuracy.predict(new HashSet<String>(Arrays.asList("a")), new HashSet<String>(Arrays.asList(new String[0])));
        accuracy.predict(new HashSet<String>(Arrays.asList(new String[0])), new HashSet<String>(Arrays.asList("b")));
        accuracy.predict(new HashSet<String>(Arrays.asList("b")), new HashSet<String>(Arrays.asList(new String[0])));
        accuracy.predict(new HashSet<String>(Arrays.asList("b")), new HashSet<String>(Arrays.asList("b")));
        accuracy.predict(new HashSet<String>(Arrays.asList("b")), new HashSet<String>(Arrays.asList("b")));
        Assert.assertEquals((double)0.5, (double)accuracy.precision("a"), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)accuracy.recall("a"), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)accuracy.f1("a"), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)accuracy.precision("b"), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)accuracy.recall("b"), (double)1.0E-10);
        Assert.assertEquals((double)0.6, (double)accuracy.precisionMicro(), (double)1.0E-10);
        Assert.assertEquals((double)0.5833333333333334, (double)accuracy.precisionMacro(), (double)1.0E-10);
        Assert.assertEquals((double)0.75, (double)accuracy.recallMicro(), (double)1.0E-10);
        Assert.assertEquals((double)0.8333333333333334, (double)accuracy.recallMacro(), (double)1.0E-10);
    }

    @Test
    public void testAccuracyNoRelation() {
        KBPRelationExtractor.Accuracy accuracy = new KBPRelationExtractor.Accuracy();
        accuracy.predict(new HashSet<String>(Arrays.asList("a")), new HashSet<String>(Arrays.asList("a")));
        accuracy.predict(new HashSet<String>(Arrays.asList("a")), new HashSet<String>(Arrays.asList("no_relation")));
        accuracy.predict(new HashSet<String>(Arrays.asList("no_relation")), new HashSet<String>(Arrays.asList("b")));
        accuracy.predict(new HashSet<String>(Arrays.asList("b")), new HashSet<String>(Arrays.asList("no_relation")));
        accuracy.predict(new HashSet<String>(Arrays.asList("b")), new HashSet<String>(Arrays.asList("b")));
        accuracy.predict(new HashSet<String>(Arrays.asList("b")), new HashSet<String>(Arrays.asList("b")));
        Assert.assertEquals((double)0.5, (double)accuracy.precision("a"), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)accuracy.recall("a"), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)accuracy.f1("a"), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)accuracy.precision("b"), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)accuracy.recall("b"), (double)1.0E-10);
        Assert.assertEquals((double)0.6, (double)accuracy.precisionMicro(), (double)1.0E-10);
        Assert.assertEquals((double)0.5833333333333334, (double)accuracy.precisionMacro(), (double)1.0E-10);
        Assert.assertEquals((double)0.75, (double)accuracy.recallMicro(), (double)1.0E-10);
        Assert.assertEquals((double)0.8333333333333334, (double)accuracy.recallMacro(), (double)1.0E-10);
    }

    @Test
    public void testAccuracyTrueNegatives() {
        KBPRelationExtractor.Accuracy accuracy = new KBPRelationExtractor.Accuracy();
        accuracy.predict(new HashSet<String>(Arrays.asList("a")), new HashSet<String>(Arrays.asList("a")));
        accuracy.predict(new HashSet<String>(Arrays.asList("a")), new HashSet<String>(Arrays.asList("no_relation")));
        accuracy.predict(new HashSet<String>(Arrays.asList("no_relation")), new HashSet<String>(Arrays.asList("b")));
        accuracy.predict(new HashSet<String>(Arrays.asList("b")), new HashSet<String>(Arrays.asList("no_relation")));
        accuracy.predict(new HashSet<String>(Arrays.asList("b")), new HashSet<String>(Arrays.asList("b")));
        accuracy.predict(new HashSet<String>(Arrays.asList("b")), new HashSet<String>(Arrays.asList("b")));
        accuracy.predict(new HashSet<String>(Arrays.asList("no_relation")), new HashSet<String>(Arrays.asList("no_relation")));
        accuracy.predict(new HashSet<String>(Arrays.asList("no_relation")), new HashSet<String>(Arrays.asList("no_relation")));
        accuracy.predict(new HashSet<String>(Arrays.asList("no_relation")), new HashSet<String>(Arrays.asList("no_relation")));
        Assert.assertEquals((double)0.5, (double)accuracy.precision("a"), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)accuracy.recall("a"), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)accuracy.f1("a"), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)accuracy.precision("b"), (double)1.0E-10);
        Assert.assertEquals((double)0.6666666666666666, (double)accuracy.recall("b"), (double)1.0E-10);
        Assert.assertEquals((double)0.6, (double)accuracy.precisionMicro(), (double)1.0E-10);
        Assert.assertEquals((double)0.5833333333333334, (double)accuracy.precisionMacro(), (double)1.0E-10);
        Assert.assertEquals((double)0.75, (double)accuracy.recallMicro(), (double)1.0E-10);
        Assert.assertEquals((double)0.8333333333333334, (double)accuracy.recallMacro(), (double)1.0E-10);
    }
}

