/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.NERServer;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.net.Ports;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import junit.framework.TestCase;

public class NERServerITest
extends TestCase {
    private static CRFClassifier crf = null;
    private static final String englishCRFPath = "/u/nlp/data/ner/goodClassifiers/english.all.3class.nodistsim.crf.ser.gz";
    private static final String englishTestFile = "/u/nlp/data/ner/column_data/conll.testa";
    private static String loadedQueryFile = null;
    private static final String CHARSET = "UTF-8";
    private static final String QUERY = "John Bauer was born in New Jersey";
    private static final String EXPECTED_ANSWER = "John/PERSON Bauer/PERSON was/O born/O in/O New/LOCATION Jersey/LOCATION";

    public Thread startNERServer(int port, AbstractSequenceClassifier classifier, String charset, boolean daemon) throws IOException {
        final NERServer server = new NERServer(port, classifier, charset);
        Thread thread = new Thread(){

            @Override
            public void run() {
                server.run();
            }
        };
        thread.setDaemon(daemon);
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setUp() throws IOException {
        Class<NERServerITest> clazz;
        if (crf == null) {
            clazz = NERServerITest.class;
            // MONITORENTER : edu.stanford.nlp.ie.NERServerITest.class
            if (crf == null) {
                Properties props = new Properties();
                props.setProperty("outputFormat", "slashTags");
                crf = new CRFClassifier(props);
                crf.loadClassifierNoExceptions(englishCRFPath, props);
            }
            // MONITOREXIT : clazz
        }
        if (loadedQueryFile != null) return;
        clazz = NERServerITest.class;
        // MONITORENTER : edu.stanford.nlp.ie.NERServerITest.class
        if (loadedQueryFile == null) {
            String line;
            BufferedReader br = IOUtils.readerFromString(englishTestFile);
            StringBuilder query = new StringBuilder();
            StringBuilder allQueries = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) {
                    if (query.length() <= 0) continue;
                    allQueries.append(query.toString());
                    allQueries.append("\n");
                    query = new StringBuilder();
                    continue;
                }
                String queryWord = line.split("\\s+")[0];
                if (query.length() > 0) {
                    query.append(" ");
                }
                query.append(queryWord);
            }
            loadedQueryFile = allQueries.toString();
        }
        // MONITOREXIT : clazz
    }

    public void testStartServer() throws IOException {
        int port = Ports.findAvailable(2000, 10000);
        System.err.println("testStartServer: starting on port " + port);
        this.startNERServer(port, crf, CHARSET, true);
    }

    public void testQueryServer() throws IOException {
        int port = Ports.findAvailable(2000, 10000);
        System.err.println("testQueryServer: starting on port " + port);
        this.startNERServer(port, crf, CHARSET, true);
        StringReader sin = new StringReader(QUERY);
        BufferedReader bin = new BufferedReader(sin);
        StringWriter sout = new StringWriter();
        BufferedWriter bout = new BufferedWriter(sout);
        NERServer.NERClient.communicateWithNERServer("localhost", port, CHARSET, bin, bout, false);
        bout.flush();
        NERServerITest.assertEquals((String)EXPECTED_ANSWER, (String)sout.toString().trim());
    }

    public void testServerDoesntHang() throws IOException {
        int port = Ports.findAvailable(2000, 10000);
        System.err.println("testServerDoesntHang: starting on port " + port);
        this.startNERServer(port, null, CHARSET, true);
        StringReader sin = new StringReader(QUERY);
        BufferedReader bin = new BufferedReader(sin);
        StringWriter sout = new StringWriter();
        BufferedWriter bout = new BufferedWriter(sout);
        NERServer.NERClient.communicateWithNERServer("localhost", port, CHARSET, bin, bout, false);
        bout.flush();
        NERServerITest.assertEquals((String)"", (String)sout.toString().trim());
    }

    public void testThreadedServer() throws IOException, InterruptedException {
        int port = Ports.findAvailable(2000, 10000);
        System.err.println("testThreadedServer: starting on port " + port);
        this.startNERServer(port, crf, CHARSET, true);
        StringReader sin = new StringReader(loadedQueryFile);
        BufferedReader bin = new BufferedReader(sin);
        StringWriter sout = new StringWriter();
        BufferedWriter bout = new BufferedWriter(sout);
        NERServer.NERClient.communicateWithNERServer("localhost", port, CHARSET, bin, bout, false);
        bout.flush();
        String results = sout.toString();
        System.out.println("Got first results, length " + results.length());
        NERServerITest.assertTrue((results.length() >= loadedQueryFile.length() ? 1 : 0) != 0);
        sin = new StringReader(loadedQueryFile);
        bin = new BufferedReader(sin);
        sout = new StringWriter();
        bout = new BufferedWriter(sout);
        NERServer.NERClient.communicateWithNERServer("localhost", port, CHARSET, bin, bout, false);
        bout.flush();
        results = sout.toString();
        System.out.println("Reran results, length " + results.length());
        NERServerITest.assertTrue((results.length() >= loadedQueryFile.length() ? 1 : 0) != 0);
        NERClientThread t1 = new NERClientThread("localhost", port, CHARSET, loadedQueryFile);
        NERClientThread t2 = new NERClientThread("localhost", port, CHARSET, loadedQueryFile);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        NERServerITest.assertEquals((String)results, (String)t1.results());
        System.out.println("Results from simul client 1 matched");
        NERServerITest.assertEquals((String)results, (String)t2.results());
        System.out.println("Results from simul client 2 matched");
    }

    private class NERClientThread
    extends Thread {
        final String host;
        final int port;
        final String charset;
        final String queryText;
        String results;

        public NERClientThread(String host, int port, String charset, String queryText) {
            this.host = host;
            this.port = port;
            this.charset = charset;
            this.queryText = queryText;
        }

        public String results() {
            return this.results;
        }

        @Override
        public void run() {
            try {
                StringReader sin = new StringReader(this.queryText);
                BufferedReader bin = new BufferedReader(sin);
                StringWriter sout = new StringWriter();
                BufferedWriter bout = new BufferedWriter(sout);
                NERServer.NERClient.communicateWithNERServer(this.host, this.port, this.charset, bin, bout, false);
                bout.flush();
                this.results = sout.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

