/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.NumberNormalizer;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class NumberNormalizerITest
extends TestCase {
    static AnnotationPipeline pipeline = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<NumberNormalizerITest> clazz = NumberNormalizerITest.class;
        synchronized (NumberNormalizerITest.class) {
            if (pipeline == null) {
                pipeline = new AnnotationPipeline();
                pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
                pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
                pipeline.addAnnotator(new POSTaggerAnnotator("edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger", false));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testNumbers() throws IOException {
        String testText = "two dozen\nsix hundred,\nfour hundred, and twelve.\n4 million six hundred fifty thousand, two hundred and eleven.\n6 hundred billion, five million six hundred fifty thousand, three hundred and seventy six\n5,786,345\ntwenty-five.\n1.3 million.\none thousand two hundred and twenty four\n10 thousand million.\n3.625\nzero\n-15\none two three four.\none hundred and fifty five\na hundred\n";
        Iterator<Number> expectedNumbers = Arrays.asList(24.0, 600.0, 412.0, 4650211.0, 6.00005650376E11, 5786345, 25.0, 1300000.0, 1224.0, 1.0E10, 3.625, 0, -15.0, 1, 2, 3, 4, 155.0, 100).iterator();
        Iterator<String> expectedTexts = Arrays.asList("two dozen", "six hundred", "four hundred, and twelve", "4 million six hundred fifty thousand, two hundred and eleven", "6 hundred billion, five million six hundred fifty thousand, three hundred and seventy six", "5,786,345", "twenty-five", "1.3 million", "one thousand two hundred and twenty four", "10 thousand million", "3.625", "zero", "-15", "one", "two", "three", "four", "one hundred and fifty five", "hundred").iterator();
        Annotation document = NumberNormalizerITest.createDocument(testText);
        NumberNormalizer.findAndAnnotateNumericExpressions(document);
        for (CoreMap num : (List)document.get(CoreAnnotations.NumerizedTokensAnnotation.class)) {
            if (!num.containsKey(CoreAnnotations.NumericCompositeTypeAnnotation.class)) continue;
            Number expectedNumber = expectedNumbers.next();
            String expectedType = "NUMBER";
            String expectedText = expectedTexts.next();
            String text = ((String)document.get(CoreAnnotations.TextAnnotation.class)).substring((Integer)num.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), (Integer)num.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
            NumberNormalizerITest.assertEquals((String)expectedText, (String)text);
            NumberNormalizerITest.assertEquals((String)expectedType, (String)((String)num.get(CoreAnnotations.NumericCompositeTypeAnnotation.class)));
            NumberNormalizerITest.assertEquals((String)expectedNumber.toString(), (String)((Number)num.get(CoreAnnotations.NumericCompositeValueAnnotation.class)).toString());
        }
        NumberNormalizerITest.assertFalse((boolean)expectedNumbers.hasNext());
    }

    public void testOrdinals() throws IOException {
        String testText = "0th, 1st, 2nd, 3rd, 4th, 5th, 6th, 7th, 8th, 9th, 10th\nzeroth, first, second, third, fourth, fifth, sixth, seventh, eighth, ninth, tenth\n11th, 12th, 13th, 14th, 15th, 16th, 17th, 18th, 19th, 20th\nEleventh, twelfth, thirteenth, Fourteenth, fifteenth, Sixteenth, seventeenth, eighteenth, nineteenth, twentieth\nTwenty-first, twenty first, twenty second, twenty third, twenty fourth\nthirtieth, thirty first, thirty-second,fortieth, one hundredth, two hundredth, one hundred and fifty first, one hundred fifty first";
        Iterator<Number> expectedNumbers = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21.0, 21.0, 22.0, 23.0, 24.0, 30, 31.0, 32.0, 40, 100.0, 200.0, 151.0, 151.0).iterator();
        Iterator<String> expectedTexts = Arrays.asList(testText.split("\\s*[,\\n]+\\s*")).iterator();
        Annotation document = NumberNormalizerITest.createDocument(testText);
        NumberNormalizer.findAndAnnotateNumericExpressions(document);
        for (CoreMap num : (List)document.get(CoreAnnotations.NumerizedTokensAnnotation.class)) {
            if (!num.containsKey(CoreAnnotations.NumericCompositeTypeAnnotation.class)) continue;
            Number expectedNumber = expectedNumbers.next();
            String expectedType = "ORDINAL";
            String expectedText = expectedTexts.next();
            String text = ((String)document.get(CoreAnnotations.TextAnnotation.class)).substring((Integer)num.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), (Integer)num.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
            NumberNormalizerITest.assertEquals((String)expectedText, (String)text);
            NumberNormalizerITest.assertEquals((String)("Type for " + expectedText), (String)expectedType, (String)((String)num.get(CoreAnnotations.NumericCompositeTypeAnnotation.class)));
            NumberNormalizerITest.assertEquals((String)expectedNumber.toString(), (String)((Number)num.get(CoreAnnotations.NumericCompositeValueAnnotation.class)).toString());
        }
        NumberNormalizerITest.assertFalse((boolean)expectedNumbers.hasNext());
    }

    private static Annotation createDocument(String text) {
        Annotation annotation = new Annotation(text);
        pipeline.annotate(annotation);
        return annotation;
    }
}

