/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CoreUtilities;
import java.util.List;
import junit.framework.TestCase;

public class NumberSequenceClassifierExpectedOutputITest
extends TestCase {
    private NumberSequenceClassifier nscOld = new NumberSequenceClassifier(false);
    private NumberSequenceClassifier nscNew = new NumberSequenceClassifier(true);
    private String[][] w1 = new String[][]{{"\u20ac", "30"}, {"500", "US$"}, {"forty", "three", "cents"}, {"weighs", "almost", "192", "pounds"}};
    private String[][] t1 = new String[][]{{"SYM", "CD"}, {"CD", "$"}, {"CD", "CD", "NNS"}, {"VBZ", "RB", "CD", "NNS"}};
    private int[] i1 = new int[]{0, 1, 0, 2};
    private String[] a1 = new String[]{"MONEY", "MONEY", "MONEY", "NUMBER"};
    private String[][] w2 = new String[][]{{"1:43"}, {"42:76"}, {"22:14:12"}, {"02:96:15"}, {"12/31/1986"}, {"5/18/1986"}, {"11\\/3\\/1986"}, {"2011-08-18"}, {"13", "Oct"}, {"December", "7"}, {"18", "September", "2001"}, {"3rd", "October", "1952"}, {"5th", "of", "January", ",", "2011"}, {"5:45", "a.m."}, {"7:50", "PM"}, {"March", "2001"}, {"2011", "November", "18"}, {"four", "hundred", "and", "two"}, {"11th", "of", "February"}, {"31st", "of", "December"}, {"11th", "time"}, {"First", "of", "April"}};
    private String[][] t2 = new String[][]{{"CD"}, {"CD"}, {"CD"}, {"CD"}, {"CD"}, {"CD"}, {"CD"}, {"CD"}, {"CD", "NNP"}, {"NNP", "CD"}, {"CD", "NNP", "CD"}, {"JJ", "NNP", "CD"}, {"JJ", "IN", "NNP", ",", "CD"}, {"CD", "NN"}, {"CD", "NN"}, {"NNP", "CD"}, {"CD", "NNP", "CD"}, {"CD", "CD", "CC", "CD"}, {"JJ", "IN", "NNP"}, {"JJ", "IN", "NNP"}, {"JJ", "NN"}, {"JJ", "IN", "NNP"}};
    private int[] i2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 1, 1, 1, 1, 1, 2, 0, 1, 0, 0};
    private String[] a2 = new String[]{"TIME", "NUMBER", "TIME", "NUMBER", "DATE", "DATE", "DATE", "DATE", "DATE", "DATE", "DATE", "DATE", "DATE", "TIME", "TIME", "DATE", "DATE", "NUMBER", "DATE", "DATE", "ORDINAL", "DATE"};

    public void testCurrencyOld() {
        assert (this.w1.length == this.t1.length);
        assert (this.w1.length == this.i1.length);
        assert (this.w1.length == this.a1.length);
        for (int i = 0; i < this.w1.length; ++i) {
            List<CoreLabel> cl = CoreUtilities.toCoreLabelList(this.w1[i], this.t1[i]);
            cl = this.nscOld.classify(cl);
            NumberSequenceClassifierExpectedOutputITest.assertEquals((String)("Failed on " + this.w1[i][this.i1[i]]), (String)this.a1[i], (String)((String)cl.get(this.i1[i]).get(CoreAnnotations.AnswerAnnotation.class)));
        }
    }

    public void testCurrencyNew() {
        assert (this.w1.length == this.t1.length);
        assert (this.w1.length == this.i1.length);
        assert (this.w1.length == this.a1.length);
        for (int i = 0; i < this.w1.length; ++i) {
            List<CoreLabel> cl = CoreUtilities.toCoreLabelList(this.w1[i], this.t1[i]);
            cl = this.nscNew.classify(cl);
            NumberSequenceClassifierExpectedOutputITest.assertEquals((String)("Failed on " + this.w1[i][this.i1[i]]), (String)this.a1[i], (String)((String)cl.get(this.i1[i]).get(CoreAnnotations.AnswerAnnotation.class)));
        }
    }

    public void testCdOld() {
        assert (this.w2.length == this.t2.length);
        assert (this.w2.length == this.i2.length);
        assert (this.w2.length == this.a2.length);
        for (int i = 0; i < this.w2.length; ++i) {
            List<CoreLabel> cl = CoreUtilities.toCoreLabelList(this.w2[i], this.t2[i]);
            cl = this.nscOld.classify(cl);
            NumberSequenceClassifierExpectedOutputITest.assertEquals((String)("Failed on " + this.w2[i][this.i2[i]]), (String)this.a2[i], (String)((String)cl.get(this.i2[i]).get(CoreAnnotations.AnswerAnnotation.class)));
        }
    }

    public void testCdNew() {
        assert (this.w2.length == this.t2.length);
        assert (this.w2.length == this.i2.length);
        assert (this.w2.length == this.a2.length);
        for (int i = 0; i < this.w2.length; ++i) {
            List<CoreLabel> cl = CoreUtilities.toCoreLabelList(this.w2[i], this.t2[i]);
            cl = this.nscNew.classify(cl);
            NumberSequenceClassifierExpectedOutputITest.assertEquals((String)("Failed on " + this.w2[i][this.i2[i]]), (String)this.a2[i], (String)((String)cl.get(this.i2[i]).get(CoreAnnotations.AnswerAnnotation.class)));
        }
    }
}

