/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class NumberSequenceClassifierITest
extends TestCase {
    public static final boolean VERBOSE = true;
    private static final String[] moneyStrings = new String[]{"It cost $5", "It cost 24 cents", "It cost 18\u00a2", "It cost \u00a35.40", "It cost 10 thousand million pounds", "It cost 10 thousand million dollars", "It cost four million dollars", "It cost $1m", "It cost 50 cents", "It cost \u00a3 1500", "It cost \u00a3 1500", "It cost \u00a3 .50", "It cost \u20ac .50", "It cost $ 1500", "It cost $1500", "It cost $ 1,500", "It cost $1,500", "It cost $48.75", "It cost $ 57.60", "It cost $8 thousand", "It cost $42,33"};
    private static final String[][] moneyAnswers = new String[][]{{null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY", "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY", "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY", "MONEY"}, {null, null, "MONEY", "MONEY"}};
    private static final String[][] moneyNormed = new String[][]{{null, null, "\\$5.0", "\\$5.0"}, {null, null, "\\$0.24", "\\$0.24"}, {null, null, "\\$0.18", "\\$0.18"}, {null, null, "\u00a35.4", "\u00a35.4"}, {null, null, "\u00a31.0E10", "\u00a31.0E10", "\u00a31.0E10", "\u00a31.0E10"}, {null, null, "\\$1.0E10", "\\$1.0E10", "\\$1.0E10", "\\$1.0E10"}, {null, null, "\\$4000000.0", "\\$4000000.0", "\\$4000000.0"}, {null, null, "\\$1000000.0", "\\$1000000.0"}, {null, null, "\\$0.5", "\\$0.5"}, {null, null, "\u00a31500.0", "\u00a31500.0"}, {null, null, "\u00a31500.0", "\u00a31500.0"}, {null, null, "\u00a30.5", "\u00a30.5"}, {null, null, "\\$0.5", "\\$0.5"}, {null, null, "\\$1500.0", "\\$1500.0"}, {null, null, "\\$1500.0", "\\$1500.0"}, {null, null, "\\$1500.0", "\\$1500.0"}, {null, null, "\\$1500.0", "\\$1500.0"}, {null, null, "\\$48.75", "\\$48.75"}, {null, null, "\\$57.6", "\\$57.6"}, {null, null, "\\$8000.0", "\\$8000.0", "\\$8000.0"}, {null, null, "\\$4233.0", "\\$4233.0"}};
    private static final String[] ordinalStrings = new String[]{"It was the 2nd time", "It was the second time", "It was the twenty-second time", "It was the 0th time", "It was the 1000th time"};
    private static final String[][] ordinalAnswers = new String[][]{{null, null, null, "ORDINAL", null}, {null, null, null, "ORDINAL", null}, {null, null, null, "ORDINAL", null}, {null, null, null, "ORDINAL", null}, {null, null, null, "ORDINAL", null}};
    private static final String[][] ordinalNormed = new String[][]{{null, null, null, "2.0", null}, {null, null, null, "2.0", null}, {null, null, null, "22.0", null}, {null, null, null, "0.0", null}, {null, null, null, "1000.0", null}};
    private static final String[] dateStrings = new String[]{"January 14, 2010", "14 July, 2009", "6 June 2008", "February 5, 1923", "Mar 3", "18 July 2005", "18 Sep '05", "Jan. 13", "2009-07-19", "2007-06-16", "32 July 2010", "yesterday", "tomorrow", "last year", "next year", "6 June 2008, 7 June 2008"};
    private static final String[][] dateAnswers = new String[][]{{"DATE", "DATE", "DATE", "DATE"}, {"DATE", "DATE", "DATE", "DATE"}, {"DATE", "DATE", "DATE"}, {"DATE", "DATE", "DATE", "DATE"}, {"DATE", "DATE"}, {"DATE", "DATE", "DATE"}, {"DATE", "DATE", "DATE", "DATE"}, {"DATE", "DATE"}, {"DATE"}, {"DATE"}, {"NUMBER", "DATE", "DATE"}, {"DATE"}, {"DATE"}, {"DATE", "DATE"}, {"DATE", "DATE"}, {"DATE", "DATE", "DATE", null, "DATE", "DATE", "DATE"}};
    private static final String[][] dateNormed = new String[][]{{"2010-01-14", "2010-01-14", "2010-01-14", "2010-01-14"}, {"2009-07-14", "2009-07-14", "2009-07-14", "2009-07-14"}, {"2008-06-06", "2008-06-06", "2008-06-06"}, {"1923-02-05", "1923-02-05", "1923-02-05", "1923-02-05"}, {"XXXX-03-03", "XXXX-03-03"}, {"2005-07-18", "2005-07-18", "2005-07-18"}, {"XX05-09-18", "XX05-09-18", "XX05-09-18", "XX05-09-18"}, {"XXXX-01-13", "XXXX-01-13"}, {"2009-07-19"}, {"2007-06-16"}, {"32.0", "2010-07", "2010-07"}, {"OFFSET P-1D"}, {"OFFSET P+1D"}, {"THIS P1Y OFFSET P-1Y", "THIS P1Y OFFSET P-1Y"}, {"THIS P1Y OFFSET P+1Y", "THIS P1Y OFFSET P+1Y"}, {"2008-06-06", "2008-06-06", "2008-06-06", null, "2008-06-07", "2008-06-07", "2008-06-07"}};
    private static final String[] numberStrings = new String[]{"one hundred thousand", "1.3 million", "10 thousand million", "3.625", "-15", "117-111", "<b>867</b>5309", "her phone number is 867-5309", "801 <b> 123 </b>"};
    private static final String[][] numberAnswers = new String[][]{{"NUMBER", "NUMBER", "NUMBER"}, {"NUMBER", "NUMBER"}, {"NUMBER", "NUMBER", "NUMBER"}, {"NUMBER"}, {"NUMBER"}, {"NUMBER"}, {null, "NUMBER", null, "NUMBER"}, {null, null, null, null, "NUMBER"}, {"NUMBER", null, "NUMBER", null}};
    private static final String[][] numberNormed = new String[][]{{"100000.0", "100000.0", "100000.0"}, {"1300000.0", "1300000.0"}, {"1.0E10", "1.0E10", "1.0E10"}, {"3.625"}, {"-15.0"}, {"117.0 - 111.0"}, {null, "867.0", null, "5309.0"}, {null, null, null, null, "867.0 - 5309.0"}, {"801.0", null, "123.0", null}};
    private static final String[] timeStrings = new String[]{"the time was 10:20", "12:29 p.m.", "12:39 AM"};
    private static final String[][] timeAnswers = new String[][]{{null, null, null, "TIME"}, {"TIME", "TIME"}, {"TIME", "TIME"}};
    private static final String[][] timeNormed = new String[][]{{null, null, null, "T10:20"}, {"T12:29", "T12:29"}, {"T00:39", "T00:39"}};
    private static final String[] durationStrings = new String[]{"the past four days was very sunny", "it has been more than seven years", "it took one month"};
    private static final String[][] durationAnswers = new String[][]{{"DURATION", "DURATION", "DURATION", "DURATION", null, null, null}, {null, null, null, "DURATION", "DURATION", "DURATION", "DURATION"}, {null, null, "DURATION", "DURATION"}};
    private static final String[][] durationNormed = new String[][]{{"P4D", "P4D", "P4D", "P4D", null, null, null}, {null, null, null, "P7Y", "P7Y", "P7Y", "P7Y"}, {null, null, "P1M", "P1M"}};

    private static StanfordCoreNLP makeNumericPipeline() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, pos, number, qen");
        props.setProperty("customAnnotatorClass.number", "edu.stanford.nlp.pipeline.NumberAnnotator");
        props.setProperty("customAnnotatorClass.qen", "edu.stanford.nlp.pipeline.QuantifiableEntityNormalizingAnnotator");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        return pipeline;
    }

    private static void checkLabels(StanfordCoreNLP pipe, String text, String[] labels, String[] normed) {
        Pattern p;
        int i;
        Annotation doc = new Annotation(text);
        pipe.annotate(doc);
        NumberSequenceClassifierITest.assertTrue((doc.get(CoreAnnotations.SentencesAnnotation.class) != null ? 1 : 0) != 0);
        NumberSequenceClassifierITest.assertTrue((((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).size() > 0 ? 1 : 0) != 0);
        CoreMap sent = (CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        NumberSequenceClassifierITest.assertTrue((sent.get(CoreAnnotations.TokensAnnotation.class) != null ? 1 : 0) != 0);
        List tokens = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
        for (CoreLabel token : tokens) {
            System.out.println('\t' + token.word() + ' ' + token.tag() + ' ' + token.ner() + ' ' + (token.containsKey(CoreAnnotations.NumericCompositeTypeAnnotation.class) ? token.get(CoreAnnotations.NumericCompositeValueAnnotation.class) + " " : "") + (token.containsKey(TimeAnnotations.TimexAnnotation.class) ? token.get(TimeAnnotations.TimexAnnotation.class) + " " : ""));
        }
        NumberSequenceClassifierITest.assertTrue((tokens.size() == labels.length ? 1 : 0) != 0);
        for (i = 0; i < labels.length; ++i) {
            if (labels[i] == null) {
                NumberSequenceClassifierITest.assertTrue((((CoreLabel)tokens.get(i)).ner() == null ? 1 : 0) != 0);
                continue;
            }
            p = Pattern.compile(labels[i]);
            System.err.println("COMPARING NER " + labels[i] + " with " + ((CoreLabel)tokens.get(i)).ner());
            System.err.flush();
            NumberSequenceClassifierITest.assertTrue((String)("NER should not be null for token " + tokens.get(i) + " in sentence " + tokens), (((CoreLabel)tokens.get(i)).ner() != null ? 1 : 0) != 0);
            NumberSequenceClassifierITest.assertTrue((String)(((CoreLabel)tokens.get(i)).ner() + " does not match " + p + " for token " + tokens.get(i) + " in sentence " + tokens), (boolean)p.matcher(((CoreLabel)tokens.get(i)).ner()).matches());
        }
        if (normed != null) {
            NumberSequenceClassifierITest.assertTrue((tokens.size() == normed.length ? 1 : 0) != 0);
            for (i = 0; i < normed.length; ++i) {
                if (normed[i] == null) {
                    NumberSequenceClassifierITest.assertTrue((((CoreLabel)tokens.get(i)).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class) == null ? 1 : 0) != 0);
                    continue;
                }
                p = Pattern.compile(normed[i]);
                String n = (String)((CoreLabel)tokens.get(i)).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                String message = "COMPARING NORMED \"" + normed[i] + "\" with \"" + n + "\"";
                NumberSequenceClassifierITest.assertTrue((String)(message + "; latter should not be null"), (n != null ? 1 : 0) != 0);
                NumberSequenceClassifierITest.assertTrue((String)(message + "; latter should match"), (boolean)p.matcher(n).matches());
            }
        }
    }

    private static void run(String header, String[] texts, String[][] answers, String[][] normed) {
        StanfordCoreNLP pipe = NumberSequenceClassifierITest.makeNumericPipeline();
        for (int i = 0; i < texts.length; ++i) {
            System.out.println("Running test " + header + " for text: " + texts[i]);
            NumberSequenceClassifierITest.checkLabels(pipe, texts[i], answers[i], normed != null ? normed[i] : null);
        }
    }

    public void testMoney() {
        NumberSequenceClassifierITest.run("MONEY", moneyStrings, moneyAnswers, moneyNormed);
    }

    public void testOrdinal() {
        NumberSequenceClassifierITest.run("ORDINAL", ordinalStrings, ordinalAnswers, ordinalNormed);
    }

    public void testDate() {
        NumberSequenceClassifierITest.run("DATE", dateStrings, dateAnswers, dateNormed);
    }

    public void testNumber() {
        NumberSequenceClassifierITest.run("NUMBER", numberStrings, numberAnswers, numberNormed);
    }

    public void testTime() {
        NumberSequenceClassifierITest.run("TIME", timeStrings, timeAnswers, timeNormed);
    }

    public void testDuration() {
        NumberSequenceClassifierITest.run("DURATION", durationStrings, durationAnswers, durationNormed);
    }
}

