/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.util;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.Map;

public class FixLocation {
    private static Redwood.RedwoodChannels log = Redwood.channels(FixLocation.class);
    public static final BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    static String inputFilename = null;
    static String outputFilename = null;
    public static BufferedReader answers;
    private static Map<String, String> cache;

    private FixLocation() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            log.info("Input filename?");
            inputFilename = in.readLine();
        } else {
            inputFilename = args[0];
        }
        if (args.length < 2) {
            log.info("Output filename?");
            outputFilename = in.readLine();
        } else {
            outputFilename = args[1];
        }
        String[][] cols = FixLocation.readFile(inputFilename);
        FixLocation.fix(cols);
        FixLocation.print(cols);
    }

    public static String[][] readFile(String filename) throws Exception {
        String file = IOUtils.slurpFile(filename);
        String[] lines = file.split("\n");
        String[][] cols = new String[lines.length][];
        for (int i = 0; i < lines.length; ++i) {
            cols[i] = lines[i].split("\\s+");
        }
        return cols;
    }

    public static void fix(String[][] cols) throws Exception {
        for (int i = 1; i < cols.length - 1; ++i) {
            if (cols[i - 1].length < 2 || cols[i].length < 2 || cols[i + 1].length < 2) continue;
            String prevLabel = cols[i - 1][1];
            String curWord = cols[i][0];
            String nextLabel = cols[i + 1][1];
            if (!prevLabel.equals("LOCATION") || !nextLabel.equals("LOCATION") || !curWord.equals(",")) continue;
            FixLocation.query(cols, i);
        }
    }

    public static void query(String[][] cols, int pos) throws Exception {
        String pre = "";
        if (cols[pos - 1][0].matches("[-A-Z]*")) {
            cols[pos][1] = "LOCATION";
            return;
        }
        for (int i = pos - 1; i >= 0 && cols[i].length >= 2 && cols[i][1].equals("LOCATION"); --i) {
            pre = pre.equals("") ? cols[i][0] : cols[i][0] + " " + pre;
        }
        String post = "";
        for (int i = pos + 1; i < cols.length && cols[i].length >= 2 && cols[i][1].equals("LOCATION"); ++i) {
            post = post.equals("") ? cols[i][0] : post + " " + cols[i][0];
        }
        String ans = answers == null ? "" : answers.readLine();
        String loc = pre + "," + post + " ?";
        log.info(loc);
        if (ans.equals(loc)) {
            String response = answers.readLine();
            log.info(response);
            if (ans.equalsIgnoreCase("Y")) {
                cols[pos][1] = "LOCATION";
            }
        } else {
            ans = cache.get(loc);
            if (ans == null) {
                if (in.readLine().equalsIgnoreCase("Y")) {
                    cache.put(loc, "Y");
                    cols[pos][1] = "LOCATION";
                } else {
                    cache.put(loc, "N");
                }
            } else if (ans.equalsIgnoreCase("Y")) {
                cols[pos][1] = "LOCATION";
                log.info("Y");
            }
        }
    }

    public static void print(String[][] cols) throws Exception {
        BufferedWriter out2 = new BufferedWriter(new FileWriter(outputFilename));
        for (String[] col : cols) {
            if (col.length >= 2) {
                out2.write(col[0] + "\t" + col[1] + "\n");
                continue;
            }
            out2.write("\n");
        }
        out2.flush();
        out2.close();
    }

    static {
        try {
            answers = new BufferedReader(new FileReader("answers"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        cache = Generics.newHashMap();
    }
}

