/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.parsesegment;

import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.lexparser.ArabicTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.BiLexPCFGParser;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryGrammarExtractor;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.ExhaustiveDependencyParser;
import edu.stanford.nlp.parser.lexparser.ExhaustivePCFGParser;
import edu.stanford.nlp.parser.lexparser.Extractor;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.Item;
import edu.stanford.nlp.parser.lexparser.Lattice;
import edu.stanford.nlp.parser.lexparser.LatticeScorer;
import edu.stanford.nlp.parser.lexparser.LatticeXMLReader;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.ParentAnnotationStats;
import edu.stanford.nlp.parser.lexparser.TreeAnnotatorAndBinarizer;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class JointParsingModel {
    private static Redwood.RedwoodChannels log = Redwood.channels(JointParsingModel.class);
    private boolean VERBOSE = false;
    private static ExhaustivePCFGParser pparser;
    private static ExhaustiveDependencyParser dparser;
    private BiLexPCFGParser bparser;
    private Options op;
    private LexicalizedParser lp;
    private TreeTransformer debinarizer;
    private TreeTransformer subcategoryStripper;
    private TreePrint treePrint;
    private static List<CoreLabel> bestSegmentationB;
    private boolean serInput = false;
    private int maxSentLen = 5000;
    private static final int trainLengthLimit = 100000;

    public void setVerbose(boolean b) {
        this.VERBOSE = b;
        this.op.testOptions.verbose = b;
        this.op.trainOptions.printAnnotatedStateCounts = b;
        this.op.trainOptions.printAnnotatedRuleCounts = b;
    }

    public void setSerInput(boolean ser_input) {
        this.serInput = ser_input;
    }

    public void setMaxEvalSentLen(int maxSentLen) {
        this.maxSentLen = maxSentLen;
    }

    private void removeDeleteSplittersFromSplitters(TreebankLanguagePack tlp) {
        if (this.op.trainOptions.deleteSplitters != null) {
            ArrayList<String> deleted = new ArrayList<String>();
            for (String del : this.op.trainOptions.deleteSplitters) {
                String baseDel = tlp.basicCategory(del);
                boolean checkBasic = del.equals(baseDel);
                Iterator<String> it = this.op.trainOptions.splitters.iterator();
                while (it.hasNext()) {
                    String elem = it.next();
                    String baseElem = tlp.basicCategory(elem);
                    boolean delStr = checkBasic && baseElem.equals(baseDel) || elem.equals(del);
                    if (!delStr) continue;
                    it.remove();
                    deleted.add(elem);
                }
            }
            if (this.op.testOptions.verbose) {
                log.info("Removed from vertical splitters: " + deleted);
            }
        }
    }

    public List<Tree> getAnnotatedBinaryTreebankFromTreebank(Treebank trainTreebank) {
        TreebankLangParserParams tlpParams = this.op.tlpParams;
        TreebankLanguagePack tlp = tlpParams.treebankLanguagePack();
        if (this.VERBOSE) {
            log.info("\n\n" + trainTreebank.textualSummary(tlp));
        }
        log.info("Binarizing trees...");
        TreeAnnotatorAndBinarizer binarizer = new TreeAnnotatorAndBinarizer(tlpParams, this.op.forceCNF, !this.op.trainOptions.outsideFactor(), true, this.op);
        Timing.tick("done.");
        if (this.op.trainOptions.selectiveSplit) {
            this.op.trainOptions.splitters = ParentAnnotationStats.getSplitCategories(trainTreebank, this.op.trainOptions.tagSelectiveSplit, 0, this.op.trainOptions.selectiveSplitCutOff, this.op.trainOptions.tagSelectiveSplitCutOff, tlp);
            this.removeDeleteSplittersFromSplitters(tlp);
            if (this.op.testOptions.verbose) {
                ArrayList<String> list = new ArrayList<String>(this.op.trainOptions.splitters);
                Collections.sort(list);
                log.info("Parent split categories: " + list);
            }
        }
        if (this.op.trainOptions.hSelSplit) {
            int ptt = this.op.trainOptions.printTreeTransformations;
            this.op.trainOptions.printTreeTransformations = 0;
            binarizer.setDoSelectiveSplit(false);
            for (Tree tree : trainTreebank) {
                binarizer.transformTree(tree);
            }
            binarizer.setDoSelectiveSplit(true);
            this.op.trainOptions.printTreeTransformations = ptt;
        }
        ArrayList<Tree> binaryTrainTrees = new ArrayList<Tree>();
        for (Tree tree : trainTreebank) {
            if ((tree = binarizer.transformTree(tree)).yield().size() - 1 > 100000) continue;
            binaryTrainTrees.add(tree);
        }
        return binaryTrainTrees;
    }

    public LexicalizedParser getParserDataFromTreebank(Treebank trainTreebank) {
        log.info("Binarizing training trees...");
        List<Tree> binaryTrainTrees = this.getAnnotatedBinaryTreebankFromTreebank(trainTreebank);
        Timing.tick("done.");
        HashIndex<String> stateIndex = new HashIndex<String>();
        log.info("Extracting PCFG...");
        BinaryGrammarExtractor bgExtractor = new BinaryGrammarExtractor(this.op, stateIndex);
        Pair bgug = (Pair)bgExtractor.extract(binaryTrainTrees);
        BinaryGrammar bg = (BinaryGrammar)bgug.second;
        bg.splitRules();
        UnaryGrammar ug = (UnaryGrammar)bgug.first;
        ug.purgeRules();
        Timing.tick("done.");
        log.info("Extracting Lexicon...");
        HashIndex<String> wordIndex = new HashIndex<String>();
        HashIndex<String> tagIndex = new HashIndex<String>();
        Lexicon lex = this.op.tlpParams.lex(this.op, wordIndex, tagIndex);
        lex.initializeTraining(binaryTrainTrees.size());
        lex.train(binaryTrainTrees);
        lex.finishTraining();
        Timing.tick("done.");
        Extractor<DependencyGrammar> dgExtractor = this.op.tlpParams.dependencyGrammarExtractor(this.op, wordIndex, tagIndex);
        DependencyGrammar dg = null;
        if (this.op.doDep) {
            log.info("Extracting Dependencies...");
            dg = dgExtractor.extract(binaryTrainTrees);
            dg.setLexicon(lex);
            Timing.tick("done.");
        }
        log.info("Done extracting grammars and lexicon.");
        return new LexicalizedParser(lex, bg, ug, dg, stateIndex, wordIndex, tagIndex, this.op);
    }

    private void makeParsers() {
        if (this.lp == null) {
            throw new RuntimeException(this.getClass().getName() + ": Parser grammar does not exist");
        }
        pparser = new ExhaustivePCFGParser(this.lp.bg, this.lp.ug, this.lp.lex, this.op, this.lp.stateIndex, this.lp.wordIndex, this.lp.tagIndex);
        dparser = new ExhaustiveDependencyParser(this.lp.dg, this.lp.lex, this.op, this.lp.wordIndex, this.lp.tagIndex);
        this.bparser = new BiLexPCFGParser(new GenericLatticeScorer(), pparser, dparser, this.lp.bg, this.lp.ug, this.lp.dg, this.lp.lex, this.op, this.lp.stateIndex, this.lp.wordIndex, this.lp.tagIndex);
    }

    private boolean parse(InputStream inputStream) {
        LatticeXMLReader reader = new LatticeXMLReader();
        if (!reader.load(inputStream, this.serInput)) {
            System.err.printf("%s: Error loading input lattice xml from stdin%n", this.getClass().getName());
            return false;
        }
        System.err.printf("%s: Entering main parsing loop...%n", this.getClass().getName());
        int latticeNum = 0;
        int parseable = 0;
        int successes = 0;
        int fParseSucceeded = 0;
        for (Lattice lattice : reader) {
            if (lattice.getNumNodes() > this.op.testOptions.maxLength + 1) {
                System.err.printf("%s: Lattice %d too big! (%d nodes)%n", this.getClass().getName(), latticeNum, lattice.getNumNodes());
                ++latticeNum;
                continue;
            }
            ++parseable;
            try {
                Tree rawTree = null;
                if (this.op.doPCFG && pparser.parse(lattice)) {
                    rawTree = pparser.getBestParse();
                    bestSegmentationB = rawTree.yield(new ArrayList());
                    if (this.op.doDep && dparser.parse(bestSegmentationB)) {
                        System.err.printf("%s: Dependency parse succeeded!%n", this.getClass().getName());
                        if (this.bparser.parse(bestSegmentationB)) {
                            System.err.printf("%s: Factored parse succeeded!%n", this.getClass().getName());
                            rawTree = this.bparser.getBestParse();
                            ++fParseSucceeded;
                        }
                    } else {
                        System.out.printf("%s: Dependency parse failed. Backing off to PCFG...%n", this.getClass().getName());
                    }
                } else {
                    System.out.printf("%s: WARNING: parsing failed for lattice %d%n", this.getClass().getName(), latticeNum);
                }
                if (rawTree == null) {
                    System.out.printf("%s: WARNING: Could not extract best parse for lattice %d%n", this.getClass().getName(), latticeNum);
                } else {
                    Tree t = this.debinarizer.transformTree(rawTree);
                    t = this.subcategoryStripper.transformTree(t);
                    this.treePrint.printTree(t);
                    ++successes;
                }
            }
            catch (Exception e) {
                System.out.printf("%s: WARNING: Could not extract best parse for lattice %d%n", this.getClass().getName(), latticeNum);
                e.printStackTrace();
            }
            ++latticeNum;
        }
        log.info("===================================================================");
        log.info("===================================================================");
        log.info("Post mortem:");
        log.info("  Input:     " + latticeNum);
        log.info("  Parseable: " + parseable);
        log.info("  Parsed:    " + successes);
        log.info("  f_Parsed:  " + fParseSucceeded);
        log.info("  String %:  " + (double)((int)((double)successes * 10000.0 / (double)parseable)) / 100.0);
        return true;
    }

    public boolean run(File trainTreebankFile, File testTreebankFile, InputStream inputStream) {
        this.op = new Options();
        this.op.tlpParams = new ArabicTreebankParserParams();
        this.op.setOptions("-arabicFactored");
        this.op.testOptions.maxLength = this.maxSentLen;
        this.op.testOptions.MAX_ITEMS = 5000000;
        this.op.testOptions.outputFormatOptions = "removeTopBracket,includePunctuationDependencies";
        this.op.testOptions.maxSpanForTags = 80;
        this.treePrint = this.op.testOptions.treePrint(this.op.tlpParams);
        this.debinarizer = new Debinarizer(this.op.forceCNF, new CategoryWordTagFactory());
        this.subcategoryStripper = this.op.tlpParams.subcategoryStripper();
        Timing.startTime();
        DiskTreebank trainTreebank = this.op.tlpParams.diskTreebank();
        trainTreebank.loadPath(trainTreebankFile);
        this.lp = this.getParserDataFromTreebank(trainTreebank);
        this.makeParsers();
        if (this.VERBOSE) {
            this.op.display();
            String lexNumRules = pparser != null ? Integer.toString(this.lp.lex.numRules()) : "";
            log.info("Grammar\tStates\tTags\tWords\tUnaryR\tBinaryR\tTaggings");
            log.info("Grammar\t" + this.lp.stateIndex.size() + '\t' + this.lp.tagIndex.size() + '\t' + this.lp.wordIndex.size() + '\t' + (pparser != null ? Integer.valueOf(this.lp.ug.numRules()) : "") + '\t' + (pparser != null ? Integer.valueOf(this.lp.bg.numRules()) : "") + '\t' + lexNumRules);
            log.info("ParserPack is " + this.op.tlpParams.getClass().getName());
            log.info("Lexicon is " + this.lp.lex.getClass().getName());
        }
        return this.parse(inputStream);
    }

    private static class GenericLatticeScorer
    implements LatticeScorer {
        private GenericLatticeScorer() {
        }

        @Override
        public Item convertItemSpan(Item item) {
            if (bestSegmentationB == null || bestSegmentationB.isEmpty()) {
                throw new RuntimeException(this.getClass().getName() + ": No 1best segmentation available");
            }
            item.start = ((CoreLabel)bestSegmentationB.get(item.start)).beginPosition();
            item.end = ((CoreLabel)bestSegmentationB.get(item.end - 1)).endPosition();
            return item;
        }

        @Override
        public double oScore(Edge edge) {
            Edge latticeEdge = (Edge)this.convertItemSpan(new Edge(edge));
            double pOscore = pparser.oScore(latticeEdge);
            double dOscore = dparser.oScore(edge);
            return pOscore + dOscore;
        }

        @Override
        public double iScore(Edge edge) {
            Edge latticeEdge = (Edge)this.convertItemSpan(new Edge(edge));
            double pIscore = pparser.iScore(latticeEdge);
            double dIscore = dparser.iScore(edge);
            return pIscore + dIscore;
        }

        @Override
        public boolean oPossible(Hook hook) {
            Hook latticeHook = (Hook)this.convertItemSpan(new Hook(hook));
            return pparser.oPossible(latticeHook) && dparser.oPossible(hook);
        }

        @Override
        public boolean iPossible(Hook hook) {
            Hook latticeHook = (Hook)this.convertItemSpan(new Hook(hook));
            return pparser.iPossible(latticeHook) && dparser.iPossible(hook);
        }

        @Override
        public boolean parse(List<? extends HasWord> words) {
            throw new UnsupportedOperationException(this.getClass().getName() + ": Does not support parse operation.");
        }
    }
}

