/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.pipeline;

import edu.stanford.nlp.international.arabic.pipeline.ATBArabicDataset;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.arabic.ATBTreeUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class TaggedArabicDataset
extends ATBArabicDataset {
    private static Redwood.RedwoodChannels log = Redwood.channels(TaggedArabicDataset.class);
    private String wordTagDelim = "_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build() {
        if (this.options.containsKey("TAGDELIM")) {
            this.wordTagDelim = this.options.getProperty("TAGDELIM");
        }
        for (File path : this.pathsToData) {
            int prevSize = this.treebank.size();
            if (this.splitFilter == null) {
                this.treebank.loadPath(path, this.treeFileExtension, false);
            } else {
                this.treebank.loadPath(path, this.splitFilter);
            }
            this.toStringBuffer.append(String.format(" Loaded %d trees from %s\n", this.treebank.size() - prevSize, path.getPath()));
            prevSize = this.treebank.size();
        }
        PrintWriter outfile = null;
        PrintWriter flatFile = null;
        try {
            outfile = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFileName), "UTF-8")));
            flatFile = this.makeFlatFile ? new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.flatFileName), "UTF-8"))) : null;
            ArabicTreeTaggedNormalizer tv = new ArabicTreeTaggedNormalizer(outfile, flatFile);
            this.treebank.apply(tv);
            this.outputFileList.add(this.outFileName);
            if (this.makeFlatFile) {
                this.outputFileList.add(this.flatFileName);
            }
        }
        catch (UnsupportedEncodingException e) {
            System.err.printf("%s: Filesystem does not support UTF-8 output%n", this.getClass().getName());
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.err.printf("%s: Could not open %s for writing%n", this.getClass().getName(), this.outFileName);
        }
        finally {
            if (outfile != null) {
                outfile.close();
            }
            if (flatFile != null) {
                flatFile.close();
            }
        }
    }

    protected class ArabicTreeTaggedNormalizer
    extends ATBArabicDataset.ArabicRawTreeNormalizer {
        public ArabicTreeTaggedNormalizer(PrintWriter outFile, PrintWriter flatFile) {
            super(TaggedArabicDataset.this, outFile, flatFile);
        }

        @Override
        public void visitTree(Tree t) {
            if (t == null || t.value().equals("X")) {
                return;
            }
            t = t.prune(this.nullFilter, new LabeledScoredTreeFactory());
            for (Tree node : t) {
                if (!node.isPreTerminal()) continue;
                this.processPreterminal(node);
            }
            this.outfile.println(ATBTreeUtils.taggedStringFromTree(t, TaggedArabicDataset.this.removeEscapeTokens, TaggedArabicDataset.this.wordTagDelim));
            if (this.flatFile != null) {
                this.flatFile.println(ATBTreeUtils.flattenTree(t));
            }
        }
    }
}

