/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.process;

import edu.stanford.nlp.international.arabic.process.ArabicTokenizer;
import edu.stanford.nlp.international.arabic.process.IOBUtils;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.objectbank.LineIterator;
import edu.stanford.nlp.process.SerializableFunction;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class ArabicDocumentReaderAndWriter
implements DocumentReaderAndWriter<CoreLabel> {
    private static Redwood.RedwoodChannels log = Redwood.channels(ArabicDocumentReaderAndWriter.class);
    private static final long serialVersionUID = 3667837672769424178L;
    private final IteratorFromReaderFactory<List<CoreLabel>> factory;
    private final TokenizerFactory<CoreLabel> tf;
    private static final Character DEFAULT_SEG_MARKER = Character.valueOf('-');
    private final Character segMarker;
    private static final String tagDelimiter = "|||";
    private static final String rewriteDelimiter = ">>>";
    private final boolean inputHasTags;
    private final boolean inputHasDomainLabels;
    private final String inputDomain;
    private final boolean shouldStripRewrites;

    public ArabicDocumentReaderAndWriter(boolean hasSegMarkers) {
        this(hasSegMarkers, null);
    }

    public ArabicDocumentReaderAndWriter(boolean hasSegMarkers, TokenizerFactory<CoreLabel> tokFactory) {
        this(hasSegMarkers, false, tokFactory);
    }

    public ArabicDocumentReaderAndWriter(boolean hasSegMarkers, boolean hasTags, TokenizerFactory<CoreLabel> tokFactory) {
        this(hasSegMarkers, hasTags, false, "123", tokFactory);
    }

    public ArabicDocumentReaderAndWriter(boolean hasSegMarkers, boolean hasTags, boolean hasDomainLabels, String domain, TokenizerFactory<CoreLabel> tokFactory) {
        this(hasSegMarkers, hasTags, hasDomainLabels, domain, false, tokFactory);
    }

    public ArabicDocumentReaderAndWriter(boolean hasSegMarkers, boolean hasTags, boolean hasDomainLabels, String domain, boolean stripRewrites, TokenizerFactory<CoreLabel> tokFactory) {
        this.tf = tokFactory;
        this.inputHasTags = hasTags;
        this.inputHasDomainLabels = hasDomainLabels;
        this.inputDomain = domain;
        this.shouldStripRewrites = stripRewrites;
        this.segMarker = hasSegMarkers ? DEFAULT_SEG_MARKER : null;
        this.factory = LineIterator.getFactory(new SerializableFunction<String, List<CoreLabel>>(){
            private static final long serialVersionUID = 5243251505653686497L;

            @Override
            public List<CoreLabel> apply(String in) {
                List<CoreLabel> tokenList;
                String lineDomain = "";
                if (ArabicDocumentReaderAndWriter.this.inputHasDomainLabels) {
                    String[] domainAndData = in.split("\\s+", 2);
                    if (domainAndData.length < 2) {
                        log.info("Missing domain label or text: ");
                        log.info(in);
                    } else {
                        lineDomain = domainAndData[0];
                        in = domainAndData[1];
                    }
                } else {
                    lineDomain = ArabicDocumentReaderAndWriter.this.inputDomain;
                }
                if (ArabicDocumentReaderAndWriter.this.inputHasTags) {
                    String[] toks = in.split("\\s+");
                    ArrayList<CoreLabel> input = new ArrayList<CoreLabel>(toks.length);
                    String tagDelim = Pattern.quote(ArabicDocumentReaderAndWriter.tagDelimiter);
                    String rewDelim = Pattern.quote(ArabicDocumentReaderAndWriter.rewriteDelimiter);
                    for (String wordTag : toks) {
                        String raw;
                        String[] wordTagPair = wordTag.split(tagDelim);
                        assert (wordTagPair.length == 2);
                        String[] rewritePair = wordTagPair[0].split(rewDelim);
                        assert (rewritePair.length == 1 || rewritePair.length == 2);
                        String rewritten = raw = rewritePair[0];
                        if (rewritePair.length == 2) {
                            rewritten = rewritePair[1];
                        }
                        CoreLabel cl = new CoreLabel();
                        if (ArabicDocumentReaderAndWriter.this.tf != null) {
                            List lexListRaw = ArabicDocumentReaderAndWriter.this.tf.getTokenizer(new StringReader(raw)).tokenize();
                            List lexListRewritten = ArabicDocumentReaderAndWriter.this.tf.getTokenizer(new StringReader(rewritten)).tokenize();
                            if (lexListRewritten.size() != lexListRaw.size()) {
                                System.err.printf("%s: Different number of tokens in raw and rewritten: %s>>>%s%n", this.getClass().getName(), raw, rewritten);
                                lexListRewritten = lexListRaw;
                            }
                            if (lexListRaw.size() == 0) continue;
                            if (lexListRaw.size() == 1) {
                                raw = ((CoreLabel)lexListRaw.get(0)).value();
                                rewritten = ((CoreLabel)lexListRewritten.get(0)).value();
                            } else if (lexListRaw.size() > 1) {
                                String secondWord = ((CoreLabel)lexListRaw.get(1)).value();
                                if (secondWord.equals(String.valueOf(ArabicDocumentReaderAndWriter.this.segMarker))) {
                                    raw = ((CoreLabel)lexListRaw.get(0)).value() + ArabicDocumentReaderAndWriter.this.segMarker;
                                    rewritten = ((CoreLabel)lexListRewritten.get(0)).value() + ArabicDocumentReaderAndWriter.this.segMarker;
                                } else {
                                    System.err.printf("%s: Raw token generates multiple segments: %s%n", this.getClass().getName(), raw);
                                    raw = ((CoreLabel)lexListRaw.get(0)).value();
                                    rewritten = ((CoreLabel)lexListRewritten.get(0)).value();
                                }
                            }
                        }
                        cl.setValue(raw);
                        cl.setWord(raw);
                        cl.setTag(wordTagPair[1]);
                        cl.set(CoreAnnotations.DomainAnnotation.class, lineDomain);
                        cl.set(RewrittenArabicAnnotation.class, rewritten);
                        input.add(cl);
                    }
                    tokenList = IOBUtils.StringToIOB(input, ArabicDocumentReaderAndWriter.this.segMarker, true, ArabicDocumentReaderAndWriter.this.shouldStripRewrites);
                } else if (ArabicDocumentReaderAndWriter.this.tf == null) {
                    tokenList = IOBUtils.StringToIOB(in, ArabicDocumentReaderAndWriter.this.segMarker);
                } else {
                    List<CoreLabel> line = ArabicDocumentReaderAndWriter.this.tf.getTokenizer(new StringReader(in)).tokenize();
                    tokenList = IOBUtils.StringToIOB(line, ArabicDocumentReaderAndWriter.this.segMarker, false);
                }
                if (ArabicDocumentReaderAndWriter.this.inputHasDomainLabels && !ArabicDocumentReaderAndWriter.this.inputHasTags) {
                    IOBUtils.labelDomain(tokenList, lineDomain);
                } else if (!ArabicDocumentReaderAndWriter.this.inputHasDomainLabels) {
                    IOBUtils.labelDomain(tokenList, ArabicDocumentReaderAndWriter.this.inputDomain);
                }
                return tokenList;
            }
        });
    }

    @Override
    public void init(SeqClassifierFlags flags) {
    }

    @Override
    public Iterator<List<CoreLabel>> getIterator(Reader r) {
        return this.factory.getIterator(r);
    }

    @Override
    public void printAnswers(List<CoreLabel> doc, PrintWriter pw) {
        pw.println("Answer\tGoldAnswer\tCharacter");
        for (CoreLabel word : doc) {
            pw.printf("%s\t%s\t%s%n", word.get(CoreAnnotations.AnswerAnnotation.class), word.get(CoreAnnotations.GoldAnswerAnnotation.class), word.get(CoreAnnotations.CharAnnotation.class));
        }
    }

    public static void main(String[] args) throws IOException {
        String line;
        if (args.length != 1) {
            System.err.printf("Usage: java %s file > output%n", ArabicDocumentReaderAndWriter.class.getName());
            System.exit(-1);
        }
        String fileName = args[0];
        TokenizerFactory<CoreLabel> tokFactory = ArabicTokenizer.atbFactory();
        String atbVocOptions = "removeProMarker,removeMorphMarker";
        tokFactory.setOptions(atbVocOptions);
        BufferedReader reader = IOUtils.readerFromString(fileName);
        while ((line = reader.readLine()) != null) {
            String[] toks = line.split("\\s+");
            String delim = Pattern.quote(tagDelimiter);
            boolean isStart = true;
            for (String wordTag : toks) {
                String[] wordTagPair = wordTag.split(delim);
                assert (wordTagPair.length == 2);
                String word = wordTagPair[0];
                if (tokFactory != null) {
                    List<CoreLabel> lexList = tokFactory.getTokenizer(new StringReader(word)).tokenize();
                    if (lexList.size() == 0) continue;
                    if (lexList.size() == 1) {
                        word = lexList.get(0).value();
                    } else if (lexList.size() > 1) {
                        String secondWord = lexList.get(1).value();
                        if (secondWord.equals(String.valueOf(DEFAULT_SEG_MARKER))) {
                            word = lexList.get(0).value() + String.valueOf(DEFAULT_SEG_MARKER);
                        } else {
                            System.err.printf("%s: Raw token generates multiple segments: %s%n", ArabicDocumentReaderAndWriter.class.getName(), word);
                            word = lexList.get(0).value();
                        }
                    }
                }
                if (!isStart) {
                    System.out.print(" ");
                }
                System.out.print(word);
                isStart = false;
            }
            System.out.println();
        }
    }

    public static class RewrittenArabicAnnotation
    implements CoreAnnotation<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }
    }
}

