/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.french;

import edu.stanford.nlp.international.french.FrenchUnknownWordSignatures;
import junit.framework.TestCase;

public class FrenchUnknownWordSignaturesTest
extends TestCase {
    public void testHasPunc() {
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-hpunc", (String)FrenchUnknownWordSignatures.hasPunc("Yes!"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-hpunc", (String)FrenchUnknownWordSignatures.hasPunc("["));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-hpunc", (String)FrenchUnknownWordSignatures.hasPunc("40%"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.hasPunc("B"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-hpunc", (String)FrenchUnknownWordSignatures.hasPunc("BQ_BD"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.hasPunc("BQBD"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.hasPunc("0"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-hpunc", (String)FrenchUnknownWordSignatures.hasPunc("\\"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-hpunc", (String)FrenchUnknownWordSignatures.hasPunc("]aeiou"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-hpunc", (String)FrenchUnknownWordSignatures.hasPunc("]"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-hpunc", (String)FrenchUnknownWordSignatures.hasPunc("\u00f7"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.hasPunc("\u00f8"));
    }

    public void testIsPunc() {
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isPunc("Yes!"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-ipunc", (String)FrenchUnknownWordSignatures.isPunc("["));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isPunc("40%"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isPunc("B"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isPunc("BQ_BD"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isPunc("BQBD"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isPunc("0"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-ipunc", (String)FrenchUnknownWordSignatures.isPunc("\\"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isPunc("]aeiou"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-ipunc", (String)FrenchUnknownWordSignatures.isPunc("]"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-ipunc", (String)FrenchUnknownWordSignatures.isPunc("\u00f7"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isPunc("\u00f8"));
    }

    public void testIsAllCaps() {
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-allcap", (String)FrenchUnknownWordSignatures.isAllCaps("YO"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isAllCaps("\\\\"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isAllCaps("0D"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"", (String)FrenchUnknownWordSignatures.isAllCaps("\u00d7"));
        FrenchUnknownWordSignaturesTest.assertEquals((String)"-allcap", (String)FrenchUnknownWordSignatures.isAllCaps("\u00c0\u00c5\u00c6\u00cf\u00dc\u00dd\u00de"));
    }
}

