/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.french.scripts;

import edu.stanford.nlp.international.french.FrenchMorphoFeatureSpecification;
import edu.stanford.nlp.international.french.pipeline.FTBCorrector;
import edu.stanford.nlp.international.french.pipeline.MWEPreprocessor;
import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatures;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.french.FrenchXMLTreeReader;
import edu.stanford.nlp.trees.international.french.FrenchXMLTreeReaderFactory;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SplitCanditoTrees {
    private static Redwood.RedwoodChannels log = Redwood.channels(SplitCanditoTrees.class);
    private static final boolean LEMMAS_AS_LEAVES = false;
    private static final boolean ADD_MORPHO_TO_LEAVES = false;
    private static final boolean CC_TAGSET = true;
    private static final boolean MORFETTE_OUTPUT = false;
    private static int nTokens = 0;
    private static int nMorphAnalyses = 0;
    private static final Integer[] fSizes = new Integer[]{1235, 1235, 9881, 10000000};
    private static final String[] fNames = new String[]{"candito.test", "candito.dev", "candito.train", "candito.train.extended"};

    private SplitCanditoTrees() {
    }

    static List<String> readIds(String filename) throws IOException {
        String line;
        ArrayList<String> ids = new ArrayList<String>();
        BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "ISO8859_1"));
        while ((line = fin.readLine()) != null) {
            String[] pieces = line.split("\t");
            ids.add(pieces[0].trim());
        }
        return ids;
    }

    static Map<String, Tree> readTrees(String[] filenames) throws IOException {
        FrenchXMLTreeReaderFactory trf = new FrenchXMLTreeReaderFactory(false);
        Map<String, Tree> treeMap = Generics.newHashMap();
        for (String filename : filenames) {
            File file = new File(filename);
            String canonicalFilename = file.getName().substring(0, file.getName().lastIndexOf(46));
            FrenchXMLTreeReader tr = (FrenchXMLTreeReader)trf.newTreeReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO8859_1")));
            Tree t = null;
            int numTrees = 0;
            while ((t = tr.readTree()) != null) {
                String id = canonicalFilename + "-" + (String)((CoreLabel)t.label()).get(CoreAnnotations.SentenceIDAnnotation.class);
                treeMap.put(id, t);
                ++numTrees;
            }
            tr.close();
            System.err.printf("%s: %d trees%n", file.getName(), numTrees);
        }
        return treeMap;
    }

    static void preprocessMWEs(Map<String, Tree> treeMap) {
        TwoDimensionalCounter<String, String> labelTerm = new TwoDimensionalCounter<String, String>();
        TwoDimensionalCounter<String, String> termLabel = new TwoDimensionalCounter<String, String>();
        TwoDimensionalCounter<String, String> labelPreterm = new TwoDimensionalCounter<String, String>();
        TwoDimensionalCounter<String, String> pretermLabel = new TwoDimensionalCounter<String, String>();
        TwoDimensionalCounter<String, String> unigramTagger = new TwoDimensionalCounter<String, String>();
        for (Tree t : treeMap.values()) {
            MWEPreprocessor.countMWEStatistics(t, unigramTagger, labelPreterm, pretermLabel, labelTerm, termLabel);
        }
        for (Tree t : treeMap.values()) {
            MWEPreprocessor.traverseAndFix(t, pretermLabel, unigramTagger);
        }
    }

    public static void mungeLeaves(Tree tree, boolean lemmasAsLeaves, boolean addMorphoToLeaves) {
        ArrayList<Label> labels = tree.yield();
        for (Label label : labels) {
            ++nTokens;
            if (!(label instanceof CoreLabel)) {
                throw new IllegalArgumentException("Only works with CoreLabels trees");
            }
            CoreLabel coreLabel = (CoreLabel)label;
            String lemma = coreLabel.lemma();
            if (lemma == null) {
                lemma = coreLabel.word();
            } else if (lemma.equals("(")) {
                lemma = "-LRB-";
            } else if (lemma.equals(")")) {
                lemma = "-RRB-";
            }
            if (lemmasAsLeaves) {
                String escapedLemma = lemma;
                coreLabel.setWord(escapedLemma);
                coreLabel.setValue(escapedLemma);
                coreLabel.setLemma(lemma);
            }
            if (!addMorphoToLeaves) continue;
            String morphStr = coreLabel.originalText();
            if (morphStr == null || morphStr.equals("")) {
                morphStr = "XXX";
            } else {
                ++nMorphAnalyses;
            }
            if (morphStr.startsWith("PONCT")) {
                morphStr = "PUNC";
            }
            String newLeaf = String.format("%s%s%s%s%s", coreLabel.value(), "~#", lemma, "|||", morphStr);
            coreLabel.setValue(newLeaf);
            coreLabel.setWord(newLeaf);
        }
    }

    private static void replacePOSTags(Tree tree) {
        ArrayList<Label> yield = tree.yield();
        List<Label> preYield = tree.preTerminalYield();
        assert (yield.size() == preYield.size());
        FrenchMorphoFeatureSpecification spec = new FrenchMorphoFeatureSpecification();
        for (int i = 0; i < yield.size(); ++i) {
            MorphoFeatures feats;
            String morphStr = ((CoreLabel)yield.get(i)).originalText();
            if (morphStr == null || morphStr.equals("")) {
                morphStr = preYield.get(i).value();
                String subCat = ((CoreLabel)yield.get(i)).category();
                morphStr = subCat != null && subCat != "" ? morphStr + "-" + subCat + "--" : morphStr + "---";
            }
            if ((feats = ((MorphoFeatureSpecification)spec).strToFeatures(morphStr)).getAltTag() == null || feats.getAltTag().equals("")) continue;
            CoreLabel cl = (CoreLabel)preYield.get(i);
            cl.setValue(feats.getAltTag());
            cl.setTag(feats.getAltTag());
        }
    }

    public static void outputSplits(List<String> ids, Map<String, Tree> treeMap) throws IOException {
        LinkedList<Integer> fSizeQueue = new LinkedList<Integer>(Arrays.asList(fSizes));
        LinkedList<String> fNameQueue = new LinkedList<String>(Arrays.asList(fNames));
        TregexPattern pBadTree = TregexPattern.compile("@SENT <: @PUNC");
        TregexPattern pBadTree2 = TregexPattern.compile("@SENT <1 @PUNC <2 @PUNC !<3 __");
        FTBCorrector tt = new FTBCorrector();
        int size = (Integer)fSizeQueue.remove();
        String filename = (String)fNameQueue.remove();
        log.info("Outputing " + filename);
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8")));
        int outputCount = 0;
        for (String id : ids) {
            if (!treeMap.containsKey(id)) {
                log.info("Missing id: " + id);
                continue;
            }
            Tree tree = treeMap.get(id);
            TregexMatcher m = pBadTree.matcher(tree);
            TregexMatcher m2 = pBadTree2.matcher(tree);
            if (m.find() || m2.find()) {
                log.info("Discarding tree: " + tree.toString());
                continue;
            }
            Tree backupCopy = tree.deepCopy();
            if ((tree = tt.transformTree(tree)).firstChild().children().length == 0) {
                log.info("Saving tree: " + tree.toString());
                log.info("Backup: " + backupCopy.toString());
                tree = backupCopy;
            }
            SplitCanditoTrees.replacePOSTags(tree);
            writer.println(tree.toString());
            if (++outputCount != size) continue;
            outputCount = 0;
            size = (Integer)fSizeQueue.remove();
            filename = (String)fNameQueue.remove();
            log.info("Outputing " + filename);
            writer.close();
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8")));
        }
        writer.close();
    }

    private static String treeToMorfette(Tree tree) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Label> yield = tree.yield();
        List<Label> tagYield = tree.preTerminalYield();
        assert (yield.size() == tagYield.size());
        int listLen = yield.size();
        for (int i = 0; i < listLen; ++i) {
            String lemma;
            CoreLabel token = (CoreLabel)yield.get(i);
            CoreLabel tag = (CoreLabel)tagYield.get(i);
            String morphStr = token.originalText();
            if (morphStr == null || morphStr.equals("")) {
                morphStr = tag.value();
            }
            if ((lemma = token.lemma()) == null || lemma.equals("")) {
                lemma = token.value();
            }
            sb.append(String.format("%s %s %s%n", token.value(), lemma, morphStr));
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.printf("Usage: java %s id_file [xml files]%n", SplitCanditoTrees.class.getName());
            System.exit(-1);
        }
        List<String> ids = SplitCanditoTrees.readIds(args[0]);
        log.info("Read " + ids.size() + " ids");
        String[] newArgs = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            newArgs[i - 1] = args[i];
        }
        Map<String, Tree> treeMap = SplitCanditoTrees.readTrees(newArgs);
        log.info("Read " + treeMap.size() + " trees");
        SplitCanditoTrees.preprocessMWEs(treeMap);
        SplitCanditoTrees.outputSplits(ids, treeMap);
        if (nTokens != 0) {
            log.info("CORPUS STATISTICS");
            System.err.printf("#tokens:\t%d%n", nTokens);
            System.err.printf("#with morph:\t%d%n", nMorphAnalyses);
        }
    }
}

