/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish;

import edu.stanford.nlp.international.spanish.process.SpanishTokenizer;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import java.io.StringReader;
import java.util.List;
import junit.framework.TestCase;

public class SpanishTokenizerITest
extends TestCase {
    private final String[] spanishInputs = new String[]{"Esta es una oraci\u00f3n.", "\u00a1D\u00edmelo!", "Hazlo.", "Este es un c\u00edmbalo.", "Metelo.", "Sent\u00e9monos.", "Escrib\u00e1mosela.", "No comamos all\u00ed.", "Comamosla.", "sub-20", "un tel\u00e9fono (902.400.345).", "Port-au-Prince", "McLaren/Mercedes", "10/12", "4X4", "3G", "3g", "sp3", "12km", "12km/h", "Los hombres sentados est\u00e1n muy guapos.", "Hizo abrirlos.", "salos ) ( 1 de"};
    private final String[][] spanishGold = new String[][]{{"Esta", "es", "una", "oraci\u00f3n", "."}, {"\u00a1", "Di", "me", "lo", "!"}, {"Haz", "lo", "."}, {"Este", "es", "un", "c\u00edmbalo", "."}, {"Mete", "lo", "."}, {"Sentemos", "nos", "."}, {"Escribamos", "se", "la", "."}, {"No", "comamos", "all\u00ed", "."}, {"Comamos", "la", "."}, {"sub-20"}, {"un", "tel\u00e9fono", "=LRB=", "902.400.345", "=RRB=", "."}, {"Port", "-", "au", "-", "Prince"}, {"McLaren", "/", "Mercedes"}, {"10/12"}, {"4X4"}, {"3G"}, {"3g"}, {"sp3"}, {"12", "km"}, {"12", "km", "/", "h"}, {"Los", "hombres", "sentados", "est\u00e1n", "muy", "guapos", "."}, {"Hizo", "abrir", "los", "."}, {"salos", "=RRB=", "=LRB=", "1", "de"}};

    private static void runSpanish(TokenizerFactory<CoreLabel> tf, String[] inputs, String[][] gold) {
        for (int sent = 0; sent < inputs.length; ++sent) {
            Tokenizer<CoreLabel> spanishTokenizer = tf.getTokenizer(new StringReader(inputs[sent]));
            int i = 0;
            while (spanishTokenizer.hasNext()) {
                String w = spanishTokenizer.next().word();
                try {
                    SpanishTokenizerITest.assertEquals((String)"SpanishTokenizer problem", (String)gold[sent][i], (String)w);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                ++i;
            }
            SpanishTokenizerITest.assertEquals((String)"SpanishTokenizer num tokens problem", (int)i, (int)gold[sent].length);
        }
    }

    public void testSpanishTokenizerWord() {
        assert (this.spanishInputs.length == this.spanishGold.length);
        TokenizerFactory<CoreLabel> tf = SpanishTokenizer.ancoraFactory();
        tf.setOptions("");
        tf.setOptions("tokenizeNLs");
        SpanishTokenizerITest.runSpanish(tf, this.spanishInputs, this.spanishGold);
    }

    public void testSpanishTokenizerCoreNLP() {
        assert (this.spanishInputs.length == this.spanishGold.length);
        TokenizerFactory<CoreLabel> tf = SpanishTokenizer.coreLabelFactory();
        tf.setOptions("");
        tf.setOptions("invertible,ptb3Escaping=true,splitAll=true");
        SpanishTokenizerITest.runSpanish(tf, this.spanishInputs, this.spanishGold);
    }

    public void testOffsetsSpacing() {
        String text = "  La   combinaci\u00f3n conson\u00e1ntica ss es ajena a la\tortograf\u00eda    castellana:   \n\n traig\u00e1mosela, mand\u00e9moselos, escrib\u00e1mosela, compr\u00e9moselo.";
        TokenizerFactory<CoreLabel> tf = SpanishTokenizer.coreLabelFactory();
        tf.setOptions("");
        tf.setOptions("splitAll=true");
        Tokenizer<CoreLabel> spanishTokenizer = tf.getTokenizer(new StringReader(text));
        List<CoreLabel> tokens = spanishTokenizer.tokenize();
        System.err.println(tokens);
        SpanishTokenizerITest.assertEquals((int)27, (int)tokens.size());
        SpanishTokenizerITest.assertEquals((String)"Begin char offset", (int)2, (int)((Integer)tokens.get(0).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"End char offset", (int)4, (int)((Integer)tokens.get(0).get(CoreAnnotations.CharacterOffsetEndAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"La", (String)((String)tokens.get(0).get(CoreAnnotations.OriginalTextAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"escrib\u00e1mo", (String)((String)tokens.get(19).get(CoreAnnotations.OriginalTextAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"escribamos", (String)((String)tokens.get(19).get(CoreAnnotations.TextAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"Begin char offset", (int)108, (int)((Integer)tokens.get(19).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"End char offset", (int)117, (int)((Integer)tokens.get(19).get(CoreAnnotations.CharacterOffsetEndAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"se", (String)((String)tokens.get(20).get(CoreAnnotations.OriginalTextAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"se", (String)((String)tokens.get(20).get(CoreAnnotations.TextAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"Begin char offset", (int)117, (int)((Integer)tokens.get(20).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"End char offset", (int)119, (int)((Integer)tokens.get(20).get(CoreAnnotations.CharacterOffsetEndAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"la", (String)((String)tokens.get(21).get(CoreAnnotations.OriginalTextAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"la", (String)((String)tokens.get(21).get(CoreAnnotations.TextAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"Begin char offset", (int)119, (int)((Integer)tokens.get(21).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"End char offset", (int)121, (int)((Integer)tokens.get(21).get(CoreAnnotations.CharacterOffsetEndAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)",", (String)((String)tokens.get(22).get(CoreAnnotations.OriginalTextAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)",", (String)((String)tokens.get(22).get(CoreAnnotations.TextAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"Begin char offset", (int)121, (int)((Integer)tokens.get(22).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
        SpanishTokenizerITest.assertEquals((String)"End char offset", (int)122, (int)((Integer)tokens.get(22).get(CoreAnnotations.CharacterOffsetEndAnnotation.class)));
    }

    private void testOffset(String input, int[] beginOffsets, int[] endOffsets) {
        TokenizerFactory<CoreLabel> tf = SpanishTokenizer.ancoraFactory();
        Tokenizer<CoreLabel> tokenizer = tf.getTokenizer(new StringReader(input));
        List<CoreLabel> tokens = tokenizer.tokenize();
        SpanishTokenizerITest.assertEquals((String)("Number of tokens doesn't match reference '" + input + "'"), (int)beginOffsets.length, (int)tokens.size());
        for (int i = 0; i < beginOffsets.length; ++i) {
            SpanishTokenizerITest.assertEquals((String)("Char begin offset of word " + i + " deviates from reference '" + input + "'"), (int)beginOffsets[i], (int)tokens.get(i).beginPosition());
            SpanishTokenizerITest.assertEquals((String)("Char end offset of word " + i + " deviates from reference '" + input + "'"), (int)endOffsets[i], (int)tokens.get(i).endPosition());
        }
    }

    public void testCliticPronounOffset() {
        this.testOffset("tengo que decirte algo", new int[]{0, 6, 10, 15, 18}, new int[]{5, 9, 15, 17, 22});
    }

    public void testIr() {
        this.testOffset("tengo que irme ahora", new int[]{0, 6, 10, 12, 15}, new int[]{5, 9, 12, 14, 20});
    }

    public void testContractionOffsets() {
        this.testOffset("y del y", new int[]{0, 2, 3, 6}, new int[]{1, 3, 5, 7});
        this.testOffset("y al y", new int[]{0, 2, 3, 5}, new int[]{1, 3, 4, 6});
        this.testOffset("y conmigo y", new int[]{0, 2, 5, 10}, new int[]{1, 5, 9, 11});
    }

    public void testCompoundOffset() {
        this.testOffset("y abc-def y", new int[]{0, 2, 5, 6, 10}, new int[]{1, 5, 6, 9, 11});
        this.testOffset("y abc - def y", new int[]{0, 2, 6, 8, 12}, new int[]{1, 5, 7, 11, 13});
    }
}

