/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish.pipeline;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.international.spanish.SpanishXMLTreeReaderFactory;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AnCoraPOSStats {
    private static Redwood.RedwoodChannels log = Redwood.channels(AnCoraPOSStats.class);
    private final TwoDimensionalCounter<String, String> unigramTagger;
    private static final String ANCORA_ENCODING = "ISO8859_1";
    private List<File> fileList;
    private String outputPath;
    private static final String usage = String.format("Usage: java %s -o <output_path> file(s)%n%n", AnCoraPOSStats.class.getName());
    private static final Map<String, Integer> argOptionDefs = new HashMap<String, Integer>();

    public AnCoraPOSStats(List<File> fileList, String outputPath) {
        this.fileList = fileList;
        this.outputPath = outputPath;
        this.unigramTagger = new TwoDimensionalCounter();
    }

    public void process() throws IOException {
        SpanishXMLTreeReaderFactory trf = new SpanishXMLTreeReaderFactory();
        for (File file : this.fileList) {
            Tree t;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ANCORA_ENCODING));
            TreeReader tr = trf.newTreeReader(in);
            while ((t = tr.readTree()) != null) {
                List<CoreLabel> yield = t.taggedLabeledYield();
                for (CoreLabel leafLabel : yield) {
                    if (leafLabel.tag().equals("MW?")) continue;
                    this.unigramTagger.incrementCount(leafLabel.word(), leafLabel.tag());
                }
            }
        }
    }

    public TwoDimensionalCounter<String, String> getUnigramTagger() {
        return this.unigramTagger;
    }

    public static void main(String[] args) throws IOException {
        Properties options;
        String outputPath;
        if (args.length < 1) {
            log.info(usage);
            System.exit(1);
        }
        if ((outputPath = (options = StringUtils.argsToProperties(args, argOptionDefs)).getProperty("o")) == null) {
            throw new IllegalArgumentException("-o argument (output path for built tagger) is required");
        }
        String[] remainingArgs = options.getProperty("").split(" ");
        ArrayList<File> fileList = new ArrayList<File>();
        for (String arg : remainingArgs) {
            fileList.add(new File(arg));
        }
        AnCoraPOSStats stats = new AnCoraPOSStats(fileList, outputPath);
        stats.process();
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(outputPath));
        TwoDimensionalCounter<String, String> tagger = stats.getUnigramTagger();
        oos.writeObject(tagger);
        System.out.printf("Wrote tagger to %s%n", outputPath);
    }

    static {
        argOptionDefs.put("o", 1);
    }
}

