/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RecordIterator
implements Iterator<List<String>> {
    private static Redwood.RedwoodChannels log = Redwood.channels(RecordIterator.class);
    private static String WHITESPACE = "\\s+";
    private BufferedReader reader;
    private int fields;
    private boolean filter;
    private String delim = WHITESPACE;
    private List<String> nextResult;

    public RecordIterator(Reader reader, int fields, boolean filter, String delim) {
        this.reader = new BufferedReader(reader);
        this.fields = fields;
        this.filter = filter;
        this.delim = delim;
        if (delim == null) {
            this.delim = WHITESPACE;
        }
        this.advance();
    }

    public RecordIterator(String filename, int fields, boolean filter, String delim) throws FileNotFoundException {
        this(new FileReader(filename), fields, filter, delim);
    }

    public RecordIterator(InputStream in, int fields, boolean filter, String delim) {
        this(new InputStreamReader(in), fields, filter, delim);
    }

    public RecordIterator(String filename, int fields, boolean filter) throws FileNotFoundException {
        this(filename, fields, filter, WHITESPACE);
    }

    public RecordIterator(String filename, boolean filter) throws FileNotFoundException {
        this(filename, -1, filter, WHITESPACE);
    }

    public RecordIterator(String filename, int fields) throws FileNotFoundException {
        this(filename, fields, true, WHITESPACE);
    }

    public RecordIterator(String filename, String delim) throws FileNotFoundException {
        this(filename, 0, false, delim);
    }

    public RecordIterator(String filename) throws FileNotFoundException {
        this(filename, 0, false, WHITESPACE);
    }

    public RecordIterator(InputStream in) {
        this(in, 0, false, WHITESPACE);
    }

    @Override
    public boolean hasNext() {
        return this.nextResult != null;
    }

    @Override
    public List<String> next() {
        List<String> result = this.nextResult;
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static List<String> firstRecord(String filename, String delim) throws FileNotFoundException {
        RecordIterator it = new RecordIterator(filename, delim);
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    public static List<String> firstRecord(String filename) throws FileNotFoundException {
        return RecordIterator.firstRecord(filename, WHITESPACE);
    }

    public static int determineNumFields(String filename, String delim) throws FileNotFoundException {
        List<String> fields = RecordIterator.firstRecord(filename, delim);
        if (fields == null) {
            return -1;
        }
        return fields.size();
    }

    public static int determineNumFields(String filename) throws FileNotFoundException {
        return RecordIterator.determineNumFields(filename, WHITESPACE);
    }

    private void advance() {
        String[] tokens;
        this.nextResult = null;
        do {
            String line = null;
            try {
                line = this.reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (line == null) {
                return;
            }
            tokens = line.split(this.delim);
            if (this.fields >= 0) continue;
            this.fields = tokens.length;
        } while (this.filter && (tokens.length != this.fields || tokens.length == 1 && tokens[0].equals("")));
        this.nextResult = new ArrayList<String>();
        for (String token : tokens) {
            this.nextResult.add(token);
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        RecordIterator it = null;
        if (args.length > 0) {
            it = new RecordIterator(args[0]);
        } else {
            it = new RecordIterator(System.in);
            log.info("[Reading from stdin...]");
        }
        while (it != null && it.hasNext()) {
            Object record = it.next();
            Iterator iterator = record.iterator();
            while (iterator.hasNext()) {
                String field = (String)iterator.next();
                System.out.printf("[%-10s]", field);
            }
            System.out.println();
        }
    }
}

