/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.ling.WordTag;
import junit.framework.TestCase;

public class LabelsTest
extends TestCase {
    public void setUp() {
    }

    private static void internalValidation(String type, Label lab, String val) {
        LabelsTest.assertEquals((String)(type + " does not have value it was constructed with"), (String)lab.value(), (String)val);
        String newVal = "feijoa";
        lab.setValue(newVal);
        LabelsTest.assertEquals((String)(type + " does not have value set with setValue"), (String)newVal, (String)lab.value());
        lab.setValue(val);
        String out2 = lab.toString();
        Label lab3 = lab.labelFactory().newLabel(val);
        LabelsTest.assertEquals((String)(type + " made by label factory has diferent value"), (String)lab.value(), (String)lab3.value());
        lab3 = lab.labelFactory().newLabel(lab);
        LabelsTest.assertEquals((String)(type + " made from label factory is not equal"), (Object)lab, (Object)lab3);
        try {
            Label lab2 = lab.labelFactory().newLabelFromString(out2);
            LabelsTest.assertEquals((String)(type + " factory fromString and toString are not inverses"), (Object)lab, (Object)lab2);
            lab3.setFromString(out2);
            LabelsTest.assertEquals((String)(type + " setFromString and toString are not inverses"), (Object)lab, (Object)lab3);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static void validateHasTag(String type, HasTag lab, String tag) {
        LabelsTest.assertEquals((String)(type + " does not have tag it was constructed with"), (String)lab.tag(), (String)tag);
        String newVal = "feijoa";
        lab.setTag(newVal);
        LabelsTest.assertEquals((String)(type + " does not have tag set with setTag"), (String)newVal, (String)lab.tag());
        lab.setTag(tag);
    }

    public void testStringLabel() {
        String val = "octopus";
        StringLabel sl = new StringLabel(val);
        LabelsTest.internalValidation("StringLabel ", sl, val);
    }

    public void testWord() {
        String val = "octopus";
        Word sl = new Word(val);
        LabelsTest.internalValidation("Word ", sl, val);
    }

    public void testTaggedWord() {
        String val = "fish";
        TaggedWord sl = new TaggedWord(val);
        LabelsTest.internalValidation("TaggedWord", sl, val);
        String tag = "NN";
        sl = new TaggedWord(val, tag);
        LabelsTest.internalValidation("TaggedWord", sl, val);
        LabelsTest.validateHasTag("TaggedWord", sl, tag);
        TaggedWord tw2 = new TaggedWord(sl);
        LabelsTest.internalValidation("TaggedWord", tw2, val);
        LabelsTest.validateHasTag("TaggedWord", tw2, tag);
    }

    public void testWordTag() {
        String val = "fowl";
        WordTag sl = new WordTag(val);
        LabelsTest.internalValidation("WordTag", sl, val);
        String tag = "NN";
        sl = new WordTag(val, tag);
        LabelsTest.internalValidation("WordTag", sl, val);
        LabelsTest.validateHasTag("WordTag", sl, tag);
        WordTag wt2 = new WordTag(sl);
        LabelsTest.internalValidation("WordTag", wt2, val);
        LabelsTest.validateHasTag("WordTag", wt2, tag);
    }
}

