/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.simple.Sentence;
import java.util.ArrayList;
import junit.framework.TestCase;

public class SentenceTest
extends TestCase {
    private String[] words = new String[]{"This", "is", "a", "test", "."};
    private String[] tags = new String[]{"A", "B", "C", "D", "E"};
    private String expectedValueOnly = "This is a test .";
    private String expectedTagged = "This_A is_B a_C test_D ._E";
    private String separator = "_";

    public void setUp() {
        SentenceTest.assertEquals((int)this.words.length, (int)this.tags.length);
    }

    public void testCoreLabelListToString() {
        ArrayList<CoreLabel> clWords = new ArrayList<CoreLabel>();
        ArrayList<CoreLabel> clValues = new ArrayList<CoreLabel>();
        ArrayList<CoreLabel> clWordTags = new ArrayList<CoreLabel>();
        ArrayList<CoreLabel> clValueTags = new ArrayList<CoreLabel>();
        for (int i = 0; i < this.words.length; ++i) {
            CoreLabel cl = new CoreLabel();
            cl.setWord(this.words[i]);
            clWords.add(cl);
            cl = new CoreLabel();
            cl.setValue(this.words[i]);
            clValues.add(cl);
            cl = new CoreLabel();
            cl.setWord(this.words[i]);
            cl.setTag(this.tags[i]);
            clWordTags.add(cl);
            cl = new CoreLabel();
            cl.setValue(this.words[i]);
            cl.setTag(this.tags[i]);
            clValueTags.add(cl);
        }
        SentenceTest.assertEquals((String)this.expectedValueOnly, (String)SentenceUtils.listToString(clWords, true));
        SentenceTest.assertEquals((String)this.expectedValueOnly, (String)SentenceUtils.listToString(clValues, true));
        SentenceTest.assertEquals((String)this.expectedTagged, (String)SentenceUtils.listToString(clWordTags, false, this.separator));
        SentenceTest.assertEquals((String)this.expectedTagged, (String)SentenceUtils.listToString(clValueTags, false, this.separator));
    }

    public void testTaggedWordListToString() {
        ArrayList<TaggedWord> tagged = new ArrayList<TaggedWord>();
        for (int i = 0; i < this.words.length; ++i) {
            tagged.add(new TaggedWord(this.words[i], this.tags[i]));
        }
        SentenceTest.assertEquals((String)this.expectedValueOnly, (String)SentenceUtils.listToString(tagged, true));
        SentenceTest.assertEquals((String)this.expectedTagged, (String)SentenceUtils.listToString(tagged, false, this.separator));
    }

    public void testTokenizedSentenceSize() {
        byte[] textArray;
        String text = "one two three four five";
        byte[] sentenceArray = new Sentence(text).serialize().toByteArray();
        SentenceTest.assertTrue((sentenceArray.length < (textArray = text.getBytes()).length * 10 ? 1 : 0) != 0);
    }
}

