/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.tokensregex.CoreMapNodePatternTrigger;
import edu.stanford.nlp.ling.tokensregex.MultiPatternMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;

public class SequencePatternTriggerTest
extends TestCase {
    public void testSimpleTrigger() throws Exception {
        ArrayList<TokenSequencePattern> patterns = new ArrayList<TokenSequencePattern>();
        patterns.add(TokenSequencePattern.compile("which word should be matched"));
        MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap> trigger = new MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap>(new CoreMapNodePatternTrigger(patterns));
        Collection triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("one", "two", "three")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "should", "be", "matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
    }

    public void testOptionalTrigger() throws Exception {
        ArrayList<TokenSequencePattern> patterns = new ArrayList<TokenSequencePattern>();
        patterns.add(TokenSequencePattern.compile("which word should? be matched"));
        MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap> trigger = new MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap>(new CoreMapNodePatternTrigger(patterns));
        Collection triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("one", "two", "three")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("should")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "be")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "be", "matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "should", "be", "matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
    }

    public void testOptionalTrigger2() throws Exception {
        ArrayList<TokenSequencePattern> patterns = new ArrayList<TokenSequencePattern>();
        patterns.add(TokenSequencePattern.compile("which word should? be matched?"));
        MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap> trigger = new MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap>(new CoreMapNodePatternTrigger(patterns));
        Collection triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("one", "two", "three")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("matched")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("should")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "be")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "should", "be", "matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
    }

    public void testOptionalTrigger3() throws Exception {
        ArrayList<TokenSequencePattern> patterns = new ArrayList<TokenSequencePattern>();
        patterns.add(TokenSequencePattern.compile("which word ( should | would ) be matched?"));
        MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap> trigger = new MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap>(new CoreMapNodePatternTrigger(patterns));
        Collection triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("one", "two", "three")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("matched")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("should")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "be")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "should", "be", "matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
    }

    public void testOptionalTrigger4() throws Exception {
        ArrayList<TokenSequencePattern> patterns = new ArrayList<TokenSequencePattern>();
        patterns.add(TokenSequencePattern.compile("which word should? be matched{1,2}"));
        MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap> trigger = new MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap>(new CoreMapNodePatternTrigger(patterns));
        Collection triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("one", "two", "three")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("should")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "be")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "be", "matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "should", "be", "matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
    }

    public void testOptionalTrigger5() throws Exception {
        ArrayList<TokenSequencePattern> patterns = new ArrayList<TokenSequencePattern>();
        patterns.add(TokenSequencePattern.compile("which word should? be matched{1,8}"));
        MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap> trigger = new MultiPatternMatcher.BasicSequencePatternTrigger<CoreMap>(new CoreMapNodePatternTrigger(patterns));
        Collection triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("one", "two", "three")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("matched")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("should")));
        SequencePatternTriggerTest.assertEquals((int)0, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "be")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "be", "matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
        triggered = (Collection)trigger.apply((CoreMap)((Object)SentenceUtils.toCoreLabelList("which", "word", "should", "be", "matched")));
        SequencePatternTriggerTest.assertEquals((int)1, (int)triggered.size());
    }
}

