/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.CoreMapNodePattern;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.MultiCoreMapNodePattern;
import edu.stanford.nlp.ling.tokensregex.MultiPatternMatcher;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.NumberAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Timing;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class TokenSequenceMatcherITest
extends TestCase {
    private static AnnotationPipeline pipeline = null;
    private static final String testText = "the number were one, two and fifty.";
    private static final String testText1 = "Mellitus was the first Bishop of London, the third Archbishop of Canterbury, and a member of the Gregorian mission  sent to England to convert the Anglo-Saxons. He arrived in 601 AD, and was consecrated as Bishop of London in 604.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<TokenSequenceMatcherITest> clazz = TokenSequenceMatcherITest.class;
        synchronized (TokenSequenceMatcherITest.class) {
            if (pipeline == null) {
                pipeline = new AnnotationPipeline();
                pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
                pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
                pipeline.addAnnotator(new POSTaggerAnnotator(false));
                pipeline.addAnnotator(new NumberAnnotator(false, false));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static CoreMap createDocument(String text) {
        Annotation annotation = new Annotation(text);
        pipeline.annotate(annotation);
        return annotation;
    }

    private static SequencePattern.PatternExpr getSequencePatternExpr(String ... textRegex) {
        ArrayList<SequencePattern.PatternExpr> patterns = new ArrayList<SequencePattern.PatternExpr>(textRegex.length);
        for (String s : textRegex) {
            patterns.add(new SequencePattern.NodePatternExpr(CoreMapNodePattern.valueOf(s)));
        }
        return new SequencePattern.SequencePatternExpr(patterns);
    }

    private static SequencePattern.PatternExpr getOrPatternExpr(Pair<String, Object> ... textRegex) {
        ArrayList<SequencePattern.PatternExpr> patterns = new ArrayList<SequencePattern.PatternExpr>(textRegex.length);
        for (Pair<String, Object> p : textRegex) {
            SequencePattern.PatternExpr pe = new SequencePattern.NodePatternExpr(CoreMapNodePattern.valueOf(p.first()));
            if (p.second() != null) {
                pe = new SequencePattern.ValuePatternExpr(pe, p.second());
            }
            patterns.add(pe);
        }
        return new SequencePattern.OrPatternExpr(patterns);
    }

    private static SequencePattern.PatternExpr getNodePatternExpr(String textRegex) {
        return new SequencePattern.NodePatternExpr(CoreMapNodePattern.valueOf(textRegex));
    }

    public void testTokenSequenceMatcherValue() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText);
        TokenSequencePattern p = TokenSequencePattern.compile(TokenSequenceMatcherITest.getOrPatternExpr(new Pair<String, Integer>("one", 1), new Pair<String, Object>("two", null), new Pair<String, Integer>("fifty", 50)));
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"one", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((Object)1, (Object)m.groupValue());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"two", (String)m.group());
        TokenSequenceMatcherITest.assertNull((Object)m.groupValue());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"fifty", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((Object)50, (Object)m.groupValue());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherBeginEnd() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText);
        TokenSequencePattern p = TokenSequencePattern.compile("^ [] []");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"the number", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[] [] $");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"fifty.", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("^ [] [] $");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("/^number$/");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"number", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcher1() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile(TokenSequenceMatcherITest.getSequencePatternExpr("Archbishop", "of", "Canterbury"));
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        m.reset();
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        m.reset();
        match = m.matches();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(new SequencePattern.OrPatternExpr(TokenSequenceMatcherITest.getSequencePatternExpr("Archbishop", "of", "Canterbury"), TokenSequenceMatcherITest.getSequencePatternExpr("Bishop", "of", "London")));
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop of London", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop of London", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(new SequencePattern.SequencePatternExpr(SequencePattern.SEQ_BEGIN_PATTERN_EXPR, TokenSequenceMatcherITest.getSequencePatternExpr("Archbishop", "of", "Canterbury")));
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(new SequencePattern.SequencePatternExpr(SequencePattern.SEQ_BEGIN_PATTERN_EXPR, TokenSequenceMatcherITest.getSequencePatternExpr("Mellitus", "was", "the")));
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was the", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(new SequencePattern.SequencePatternExpr(TokenSequenceMatcherITest.getSequencePatternExpr("Archbishop", "of", "Canterbury"), SequencePattern.SEQ_END_PATTERN_EXPR));
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(new SequencePattern.SequencePatternExpr(TokenSequenceMatcherITest.getSequencePatternExpr("London", "in", "604", "."), SequencePattern.SEQ_END_PATTERN_EXPR));
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"London in 604.", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcher2() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile(TokenSequenceMatcherITest.getSequencePatternExpr(".*", ".*", "of", ".*"));
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop of Canterbury", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(new SequencePattern.SequencePatternExpr(new SequencePattern.GroupPatternExpr(TokenSequenceMatcherITest.getSequencePatternExpr(".*", ".*")), TokenSequenceMatcherITest.getNodePatternExpr("of"), new SequencePattern.GroupPatternExpr(TokenSequenceMatcherITest.getSequencePatternExpr(".*"))));
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Canterbury", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"a member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcher3() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile(new SequencePattern.SequencePatternExpr(new SequencePattern.GroupPatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getSequencePatternExpr("[A-Za-z]+"), 1, 2)), TokenSequenceMatcherITest.getNodePatternExpr("of"), new SequencePattern.GroupPatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getSequencePatternExpr("[A-Za-z]+"), 1, 3))));
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Canterbury", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the Gregorian mission", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"a member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the Gregorian mission", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London in", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London in", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(new SequencePattern.SequencePatternExpr(new SequencePattern.GroupPatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getNodePatternExpr("[A-Za-z]+"), 2, 2)), TokenSequenceMatcherITest.getNodePatternExpr("of"), new SequencePattern.GroupPatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getNodePatternExpr("[A-Za-z]+"), 1, 3, false))));
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Canterbury", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"a member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherConj() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile(new SequencePattern.AndPatternExpr(new SequencePattern.SequencePatternExpr(new SequencePattern.GroupPatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getNodePatternExpr("[A-Za-z]+"), 2, 2)), TokenSequenceMatcherITest.getNodePatternExpr("of"), new SequencePattern.GroupPatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getNodePatternExpr("[A-Za-z]+"), 1, 3, false))), new SequencePattern.SequencePatternExpr(new SequencePattern.GroupPatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getNodePatternExpr(".*"), 0, -1)), TokenSequenceMatcherITest.getNodePatternExpr("Bishop"), new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getNodePatternExpr(".*"), 0, -1))));
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"first", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London in", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London in", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"as", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(new SequencePattern.AndPatternExpr(new SequencePattern.SequencePatternExpr(new SequencePattern.GroupPatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getNodePatternExpr("[A-Za-z]+"), 2, 2)), TokenSequenceMatcherITest.getNodePatternExpr("of"), new SequencePattern.GroupPatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getNodePatternExpr("[A-Za-z]+"), 1, 3, false))), new SequencePattern.SequencePatternExpr(new SequencePattern.GroupPatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getNodePatternExpr(".*"), 0, -1)), TokenSequenceMatcherITest.getNodePatternExpr("Bishop"), new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getNodePatternExpr(".*"), 0, -1, false))));
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"first", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"as", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("(?: (/[A-Za-z]+/{2,2}) /of/ (/[A-Za-z]+/{1,3}?) ) & (?: (/.*/*) /Bishop/ /.*/*? )");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"first", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"as", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherConj2() throws IOException {
        String content = "The cat is sleeping on the floor.";
        String greedyPattern = "(?: ([]* cat []*) & ([]* sleeping []*))";
        TokenizerFactory<CoreLabel> tf = PTBTokenizer.factory(new CoreLabelTokenFactory(), "");
        List<CoreLabel> tokens = tf.getTokenizer(new StringReader(content)).tokenize();
        TokenSequencePattern seqPattern = TokenSequencePattern.compile(greedyPattern);
        SequenceMatcher matcher = seqPattern.getMatcher(tokens);
        boolean entireMatch = matcher.matches();
        TokenSequenceMatcherITest.assertTrue((boolean)entireMatch);
        boolean match = matcher.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"The cat is sleeping on the floor.", (String)matcher.group());
        String reluctantPattern = "(?: ([]*? cat []*?) & ([]*? sleeping []*?))";
        TokenSequencePattern seqPattern2 = TokenSequencePattern.compile(reluctantPattern);
        SequenceMatcher matcher2 = seqPattern2.getMatcher(tokens);
        match = matcher2.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"The cat is sleeping", (String)matcher2.group());
    }

    public void testTokenSequenceMatcherConjAll() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile("(?: (/[A-Za-z]+/{1,2}) /of/ (/[A-Za-z]+/{1,3}?) ) & (?: (/.*/*) /Bishop/ /.*/*? )");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        m.setFindType(SequenceMatcher.FindType.FIND_ALL);
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"first", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"as", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London in", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London in", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"as", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop of London in", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London in", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherAll() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile("(/[A-Za-z]+/{1,2}) /of/ (/[A-Za-z]+/{1,3}?) ");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        m.setFindType(SequenceMatcher.FindType.FIND_ALL);
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Canterbury", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Canterbury", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"a member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the Gregorian", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"a member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the Gregorian", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the Gregorian mission", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"a member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the Gregorian mission", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"member of the", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"member of the Gregorian", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the Gregorian", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"member of the Gregorian mission", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the Gregorian mission", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London in", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London in", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop of London in", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London in", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherAll2() throws IOException {
        String text = "DATE1 PROD1 PRICE1 PROD2 PRICE2 PROD3 PRICE3 DATE2 PROD4 PRICE4 PROD5 PRICE5 PROD6 PRICE6";
        CoreMap doc = TokenSequenceMatcherITest.createDocument(text);
        TokenSequencePattern p = TokenSequencePattern.compile("(/DATE.*/) (?: /PROD.*/ /PRICE.*/)* (/PROD.*/) (/PRICE.*/)");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        m.setFindType(SequenceMatcher.FindType.FIND_ALL);
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"DATE1", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"PROD3", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"PRICE3", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"DATE1", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"PROD2", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"PRICE2", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"DATE1", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"PROD1", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"PRICE1", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"DATE2", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"PROD6", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"PRICE6", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"DATE2", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"PROD5", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"PRICE5", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"DATE2", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"PROD4", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"PRICE4", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherNonOverlapping() throws IOException {
        String text = "DATE1 PROD1 PRICE1 PROD2 PRICE2 PROD3 PRICE3 DATE2 PROD4 PRICE4 PROD5 PRICE5 PROD6 PRICE6";
        CoreMap doc = TokenSequenceMatcherITest.createDocument(text);
        TokenSequencePattern p = TokenSequencePattern.compile("(/DATE.*/) ((/PROD.*/ /PRICE.*/)+)");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"DATE1", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"PROD1 PRICE1 PROD2 PRICE2 PROD3 PRICE3", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"PROD3 PRICE3", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"DATE2", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"PROD4 PRICE4 PROD5 PRICE5 PROD6 PRICE6", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"PROD6 PRICE6", (String)m.group(3));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcher4() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getSequencePatternExpr("[A-Za-z]+"), 1, -1));
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was the first Bishop of London", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"the third Archbishop of Canterbury", (String)m.group());
        p = TokenSequencePattern.compile(new SequencePattern.SequencePatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getSequencePatternExpr("[A-Za-z]+"), 0, -1), TokenSequenceMatcherITest.getSequencePatternExpr("Mellitus", "was")));
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(new SequencePattern.SequencePatternExpr(new SequencePattern.RepeatPatternExpr(TokenSequenceMatcherITest.getSequencePatternExpr("[A-Za-z]+"), 1, -1), TokenSequenceMatcherITest.getSequencePatternExpr("Mellitus", "was")));
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcher5() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile(" [ { word:\"Archbishop\" } ]  [ { word:\"of\" } ]  [ { word:\"Canterbury\" } ]");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        m.reset();
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        m.reset();
        match = m.matches();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(" [ \"Archbishop\" ]  [ \"of\"  ]  [ \"Canterbury\"  ]");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        m.reset();
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        m.reset();
        match = m.matches();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(" [ \"Archbishop\"] [\"of\"] [\"Canterbury\"] |  [ \"Bishop\" ] [ \"of\" ]  [ \"London\" ] ");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop of London", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Bishop of London", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcher6() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile("[ /.*/ ] [ /.*/ ] [/of/] [/.*/]");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop of Canterbury", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("([ /.*/ ] [ /.*/ ]) [/of/] ([/.*/])");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Canterbury", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"a member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcher7() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile(" ( [ /[A-Za-z]+/ ]{1,2} )  [ /of/ ] ( [ /[A-Za-z]+/ ]{1,3} )");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Canterbury", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the Gregorian mission", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"a member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the Gregorian mission", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London in", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London in", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile(" ( [ /[A-Za-z]+/ ]{2,2} )  [ /of/ ] ( [ /[A-Za-z]+/ ]{1,3}? )");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"third Archbishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Canterbury", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"a member", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"the", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(2));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcher8() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile("[ /[A-Za-z]+/ ]*");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was the first Bishop of London", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"the third Archbishop of Canterbury", (String)m.group());
        p = TokenSequencePattern.compile("[ /[A-Za-z]+/ ]*  [\"Mellitus\"] [ \"was\"]");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ /[A-Za-z]+/ ]+  [\"Mellitus\"] [ \"was\"]");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcher9() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile("(?$contextprev /.*/) (?$test [{tag:NNP} & /.*/]) (?$contextnext [/.*/])");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"first", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"of", (String)m.group(3));
        TokenSequenceMatcherITest.assertEquals((String)"first", (String)m.group("$contextprev"));
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group("$test"));
        TokenSequenceMatcherITest.assertEquals((String)"of", (String)m.group("$contextnext"));
        TokenSequenceMatcherITest.assertEquals((String)"first", (String)m.group(" $contextprev"));
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group("$test "));
        TokenSequenceMatcherITest.assertEquals(null, (String)m.group("$contex tnext"));
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.start("$contextprev"));
        TokenSequenceMatcherITest.assertEquals((int)4, (int)m.end("$contextprev"));
        TokenSequenceMatcherITest.assertEquals((int)4, (int)m.start("$test"));
        TokenSequenceMatcherITest.assertEquals((int)5, (int)m.end("$test"));
        TokenSequenceMatcherITest.assertEquals((int)5, (int)m.start("$contextnext"));
        TokenSequenceMatcherITest.assertEquals((int)6, (int)m.end("$contextnext"));
    }

    public void testTokenSequenceMatcher10() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument("the number is five or 5 or 5.0 or but not 5x or -5 or 5L.");
        TokenSequencePattern p = TokenSequencePattern.compile("(five|5|5x|5.0|-5|5L)");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"five", (String)m.group(1));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"5", (String)m.group(1));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"5.0", (String)m.group(1));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"5x", (String)m.group(1));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"-5", (String)m.group(1));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"5L", (String)m.group(1));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceOptimizeOrString() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument("atropine we need to have many many words here but we don't sweating");
        TokenSequencePattern p = TokenSequencePattern.compile("(?$dt \"atropine\") []{0,15} (?$se  \"social\" \"avoidant\" \"behaviour\"|\"dysuria\"|\"hyperglycaemia\"| \"mental\" \"disorder\"|\"vertigo\"|\"flutter\"| \"chest\" \"pain\"| \"elevated\" \"blood\" \"pressure\"|\"mania\"| \"rash\" \"erythematous\"|\"manic\"| \"papular\" \"rash\"|\"death\"| \"atrial\" \"arrhythmia\"| \"dry\" \"eyes\"| \"loss\" \"of\" \"libido\"| \"rash\" \"papular\"|\"hypersensitivity\"| \"blood\" \"pressure\" \"increased\"|\"dyspepsia\"| \"accommodation\" \"disorder\"| \"reflexes\" \"increased\"|\"lesions\"|\"asthenia\"| \"gastrointestinal\" \"pain\"|\"excitement\"| \"breast\" \"feeding\"|\"hypokalaemia\"| \"cerebellar\" \"syndrome\"|\"nervousness\"| \"pulmonary\" \"oedema\"| \"inspiratory\" \"stridor\"| \"taste\" \"altered\"|\"paranoia\"| \"psychotic\" \"disorder\"| \"open\" \"angle\" \"glaucoma\"|\"photophobia\"| \"dry\" \"eye\"|\"osteoarthritis\"| \"keratoconjunctivitis\" \"sicca\"| \"haemoglobin\" \"increased\"| \"ventricular\" \"extrasystoles\"|\"hallucinations\"|\"conjunctivitis\"|\"paralysis\"| \"qrs\" \"complex\"|\"anxiety\"| \"conjunctival\" \"disorder\"|\"coma\"|\"strabismus\"|\"thirst\"|\"para\"| \"sicca\" \"syndrome\"| \"atrioventricular\" \"dissociation\"|\"desquamation\"|\"crusting\"| \"abdominal\" \"distension\"|\"blindness\"|\"hypotension\"|\"dermatitis\"| \"sinus\" \"tachycardia\"| \"abdominal\" \"distention\"| \"lacrimation\" \"decreased\"|\"sicca\"| \"paralytic\" \"ileus\"| \"urinary\" \"hesitation\"|\"withdrawn\"| \"erectile\" \"dysfunction\"|\"keratoconjunctivitis\"|\"anaphylaxis\"| \"psychiatric\" \"disorders\"| \"altered\" \"taste\"|\"somnolence\"|\"extrasystoles\"|\"ageusia\"| \"intraocular\" \"pressure\" \"increased\"| \"left\" \"ventricular\" \"failure\"|\"impotence\"|\"drowsiness\"|\"conjunctiva\"| \"delayed\" \"gastric\" \"emptying\"| \"gastrointestinal\" \"sounds\" \"abnormal\"| \"qt\" \"prolonged\"| \"supraventricular\" \"tachycardia\"|\"weakness\"|\"hypertonia\"| \"confusional\" \"state\"|\"anhidrosis\"|\"myopia\"|\"dyspnoea\"| \"speech\" \"impairment\" \"nos\"| \"rash\" \"maculo\" \"papular\"|\"petechiae\"|\"tachypnea\"| \"acute\" \"angle\" \"closure\" \"glaucoma\"| \"gastrooesophageal\" \"reflux\" \"disease\"|\"hypokalemia\"| \"left\" \"heart\" \"failure\"| \"myocardial\" \"infarction\"| \"site\" \"reaction\"| \"ventricular\" \"fibrillation\"|\"fibrillation\"| \"maculopapular\" \"rash\"| \"impaired\" \"gastric\" \"emptying\"|\"amnesia\"| \"labored\" \"respirations\"| \"decreased\" \"lacrimation\"|\"mydriasis\"|\"headache\"| \"dry\" \"mouth\"|\"scab\"| \"cardiac\" \"syncope\"| \"visual\" \"acuity\" \"reduced\"|\"tension\"| \"blurred\" \"vision\"| \"bloated\" \"feeling\"| \"labored\" \"breathing\"| \"stridor\" \"inspiratory\"| \"skin\" \"exfoliation\"| \"memory\" \"loss\"|\"syncope\"| \"rash\" \"scarlatiniform\"|\"hyperpyrexia\"| \"cardiac\" \"flutter\"|\"heartburn\"| \"bowel\" \"sounds\" \"decreased\"|\"blepharitis\"|\"tachycardia\"| \"excessive\" \"thirst\"|\"confusion\"| \"rash\" \"macular\"| \"taste\" \"loss\"| \"respiratory\" \"failure\"|\"hesitancy\"|\"dysmetria\"|\"disorientation\"| \"decreased\" \"hemoglobin\"| \"atrial\" \"fibrillation\"| \"urinary\" \"retention\"| \"dry\" \"skin\"|\"dehydration\"|\"hyponatraemia\"|\"dysgeusia\"|\"disorder\"| \"increased\" \"intraocular\" \"pressure\"| \"speech\" \"disorder\"| \"feeling\" \"abnormal\"|\"pain\"| \"anaphylactic\" \"shock\"|\"hallucination\"| \"abdominal\" \"pain\"| \"junctional\" \"tachycardia\"| \"bun\" \"increased\"| \"ventricular\" \"flutter\"| \"scarlatiniform\" \"rash\"|\"agitation\"| \"feeling\" \"hot\"|\"hyponatremia\"| \"decreased\" \"bowel\" \"sounds\"|\"cyanosis\"|\"dysarthria\"| \"heat\" \"intolerance\"|\"hyperglycemia\"|\"reflux\"| \"angle\" \"closure\" \"glaucoma\"| \"electrocardiogram\" \"qt\" \"prolonged\"| \"vision\" \"blurred\"| \"blood\" \"urea\" \"increased\"|\"dizziness\"|\"arrhythmia\"|\"erythema\"|\"vomiting\"| \"difficulty\" \"in\" \"micturition\"|\"infarction\"|\"laryngospasm\"|\"hypoglycaemia\"|\"hypoglycemia\"| \"elevated\" \"hemoglobin\"| \"skin\" \"warm\"| \"ventricular\" \"arrhythmia\"|\"dissociation\"| \"warm\" \"skin\"| \"follicular\" \"conjunctivitis\"|\"urticaria\"|\"fatigue\"| \"cardiac\" \"fibrillation\"| \"decreased\" \"sweating\"| \"decreased\" \"visual\" \"acuity\"|\"lethargy\"| \"acute\" \"angle\" \"closure\" \"glaucoma\"| \"nodal\" \"rhythm\"|\"borborygmi\"|\"hyperreflexia\"| \"respiratory\" \"depression\"|\"diarrhea\"|\"leukocytosis\"| \"speech\" \"disturbance\"|\"ataxia\"|\"cycloplegia\"|\"tachypnoea\"|\"eczema\"| \"supraventricular\" \"extrasystoles\"|\"ileus\"| \"cardiac\" \"arrest\"| \"ventricular\" \"tachycardia\"|\"laryngitis\"|\"delirium\"|\"lactation\"|\"glaucoma\"|\"obstruction\"|\"hypohidrosis\"|\"parity\"|\"palpitations\"| \"temperature\" \"intolerance\"|\"constipation\"|\"cyclophoria\"| \"acute\" \"coronary\" \"syndrome\"| \"arrhythmia\" \"supraventricular\"|\"arrest\"|\"lesion\"|\"nausea\"| \"sweating\" \"decreased\"|\"keratitis\"|\"dyskinesia\"| \"pulmonary\" \"function\" \"test\" \"decreased\"|\"stridor\"|\"swelling\"|\"dysphagia\"| \"haemoglobin\" \"decreased\"|\"diarrhoea\"| \"ileus\" \"paralytic\"|\"clonus\"|\"insomnia\"| \"electrocardiogram\" \"qrs\" \"complex\"| \"nasal\" \"congestion\"| \"nasal\" \"dryness\"|\"sweating\"|\"rash\"| \"nodal\" \"arrhythmia\"|\"irritability\"|\"hyperhidrosis\"| \"ventricular\" \"failure\")");
        Timing timing = new Timing();
        timing.start();
        for (int i = 0; i < 100; ++i) {
            SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
            boolean match = m.find();
            TokenSequenceMatcherITest.assertTrue((boolean)match);
            TokenSequenceMatcherITest.assertEquals((String)"atropine we need to have many many words here but we don't sweating", (String)m.group(0));
            match = m.find();
            TokenSequenceMatcherITest.assertFalse((boolean)match);
        }
        timing.stop("testTokenSequenceOptimizeOrString matched");
        CoreMap docNoMatch = TokenSequenceMatcherITest.createDocument("atropine we need to have many many words here but we don't, many many many words but still no match");
        timing.start();
        for (int i = 0; i < 100; ++i) {
            SequenceMatcher m = p.getMatcher((List)docNoMatch.get(CoreAnnotations.TokensAnnotation.class));
            boolean match = m.find();
            TokenSequenceMatcherITest.assertFalse((boolean)match);
        }
        timing.stop("testTokenSequenceOptimizeOrString no match");
    }

    public void testMultiplePatterns() throws IOException {
        TokenSequencePattern p1 = TokenSequencePattern.compile("(?$dt \"atropine\") []{0,15} (?$se  \"social\" \"avoidant\" \"behaviour\"|\"dysuria\"|\"hyperglycaemia\"| \"mental\" \"disorder\"|\"vertigo\"|\"flutter\"| \"chest\" \"pain\"| \"elevated\" \"blood\" \"pressure\"|\"mania\"| \"rash\" \"erythematous\"|\"manic\"| \"papular\" \"rash\"|\"death\"| \"atrial\" \"arrhythmia\"| \"dry\" \"eyes\"| \"loss\" \"of\" \"libido\"| \"rash\" \"papular\"|\"hypersensitivity\"| \"blood\" \"pressure\" \"increased\"|\"dyspepsia\"| \"accommodation\" \"disorder\"| \"reflexes\" \"increased\"|\"lesions\"|\"asthenia\"| \"gastrointestinal\" \"pain\"|\"excitement\"| \"breast\" \"feeding\"|\"hypokalaemia\"| \"cerebellar\" \"syndrome\"|\"nervousness\"| \"pulmonary\" \"oedema\"| \"inspiratory\" \"stridor\"| \"taste\" \"altered\"|\"paranoia\"| \"psychotic\" \"disorder\"| \"open\" \"angle\" \"glaucoma\"|\"photophobia\"| \"dry\" \"eye\"|\"osteoarthritis\"| \"keratoconjunctivitis\" \"sicca\"| \"haemoglobin\" \"increased\"| \"ventricular\" \"extrasystoles\"|\"hallucinations\"|\"conjunctivitis\"|\"paralysis\"| \"qrs\" \"complex\"|\"anxiety\"| \"conjunctival\" \"disorder\"|\"coma\"|\"strabismus\"|\"thirst\"|\"para\"| \"sicca\" \"syndrome\"| \"atrioventricular\" \"dissociation\"|\"desquamation\"|\"crusting\"| \"abdominal\" \"distension\"|\"blindness\"|\"hypotension\"|\"dermatitis\"| \"sinus\" \"tachycardia\"| \"abdominal\" \"distention\"| \"lacrimation\" \"decreased\"|\"sicca\"| \"paralytic\" \"ileus\"| \"urinary\" \"hesitation\"|\"withdrawn\"| \"erectile\" \"dysfunction\"|\"keratoconjunctivitis\"|\"anaphylaxis\"| \"psychiatric\" \"disorders\"| \"altered\" \"taste\"|\"somnolence\"|\"extrasystoles\"|\"ageusia\"| \"intraocular\" \"pressure\" \"increased\"| \"left\" \"ventricular\" \"failure\"|\"impotence\"|\"drowsiness\"|\"conjunctiva\"| \"delayed\" \"gastric\" \"emptying\"| \"gastrointestinal\" \"sounds\" \"abnormal\"| \"qt\" \"prolonged\"| \"supraventricular\" \"tachycardia\"|\"weakness\"|\"hypertonia\"| \"confusional\" \"state\"|\"anhidrosis\"|\"myopia\"|\"dyspnoea\"| \"speech\" \"impairment\" \"nos\"| \"rash\" \"maculo\" \"papular\"|\"petechiae\"|\"tachypnea\"| \"acute\" \"angle\" \"closure\" \"glaucoma\"| \"gastrooesophageal\" \"reflux\" \"disease\"|\"hypokalemia\"| \"left\" \"heart\" \"failure\"| \"myocardial\" \"infarction\"| \"site\" \"reaction\"| \"ventricular\" \"fibrillation\"|\"fibrillation\"| \"maculopapular\" \"rash\"| \"impaired\" \"gastric\" \"emptying\"|\"amnesia\"| \"labored\" \"respirations\"| \"decreased\" \"lacrimation\"|\"mydriasis\"|\"headache\"| \"dry\" \"mouth\"|\"scab\"| \"cardiac\" \"syncope\"| \"visual\" \"acuity\" \"reduced\"|\"tension\"| \"blurred\" \"vision\"| \"bloated\" \"feeling\"| \"labored\" \"breathing\"| \"stridor\" \"inspiratory\"| \"skin\" \"exfoliation\"| \"memory\" \"loss\"|\"syncope\"| \"rash\" \"scarlatiniform\"|\"hyperpyrexia\"| \"cardiac\" \"flutter\"|\"heartburn\"| \"bowel\" \"sounds\" \"decreased\"|\"blepharitis\"|\"tachycardia\"| \"excessive\" \"thirst\"|\"confusion\"| \"rash\" \"macular\"| \"taste\" \"loss\"| \"respiratory\" \"failure\"|\"hesitancy\"|\"dysmetria\"|\"disorientation\"| \"decreased\" \"hemoglobin\"| \"atrial\" \"fibrillation\"| \"urinary\" \"retention\"| \"dry\" \"skin\"|\"dehydration\"|\"hyponatraemia\"|\"dysgeusia\"|\"disorder\"| \"increased\" \"intraocular\" \"pressure\"| \"speech\" \"disorder\"| \"feeling\" \"abnormal\"|\"pain\"| \"anaphylactic\" \"shock\"|\"hallucination\"| \"abdominal\" \"pain\"| \"junctional\" \"tachycardia\"| \"bun\" \"increased\"| \"ventricular\" \"flutter\"| \"scarlatiniform\" \"rash\"|\"agitation\"| \"feeling\" \"hot\"|\"hyponatremia\"| \"decreased\" \"bowel\" \"sounds\"|\"cyanosis\"|\"dysarthria\"| \"heat\" \"intolerance\"|\"hyperglycemia\"|\"reflux\"| \"angle\" \"closure\" \"glaucoma\"| \"electrocardiogram\" \"qt\" \"prolonged\"| \"vision\" \"blurred\"| \"blood\" \"urea\" \"increased\"|\"dizziness\"|\"arrhythmia\"|\"erythema\"|\"vomiting\"| \"difficulty\" \"in\" \"micturition\"|\"infarction\"|\"laryngospasm\"|\"hypoglycaemia\"|\"hypoglycemia\"| \"elevated\" \"hemoglobin\"| \"skin\" \"warm\"| \"ventricular\" \"arrhythmia\"|\"dissociation\"| \"warm\" \"skin\"| \"follicular\" \"conjunctivitis\"|\"urticaria\"|\"fatigue\"| \"cardiac\" \"fibrillation\"| \"decreased\" \"sweating\"| \"decreased\" \"visual\" \"acuity\"|\"lethargy\"| \"acute\" \"angle\" \"closure\" \"glaucoma\"| \"nodal\" \"rhythm\"|\"borborygmi\"|\"hyperreflexia\"| \"respiratory\" \"depression\"|\"diarrhea\"|\"leukocytosis\"| \"speech\" \"disturbance\"|\"ataxia\"|\"cycloplegia\"|\"tachypnoea\"|\"eczema\"| \"supraventricular\" \"extrasystoles\"|\"ileus\"| \"cardiac\" \"arrest\"| \"ventricular\" \"tachycardia\"|\"laryngitis\"|\"delirium\"|\"lactation\"|\"glaucoma\"|\"obstruction\"|\"hypohidrosis\"|\"parity\"|\"palpitations\"| \"temperature\" \"intolerance\"|\"constipation\"|\"cyclophoria\"| \"acute\" \"coronary\" \"syndrome\"| \"arrhythmia\" \"supraventricular\"|\"arrest\"|\"lesion\"|\"nausea\"| \"sweating\" \"decreased\"|\"keratitis\"|\"dyskinesia\"| \"pulmonary\" \"function\" \"test\" \"decreased\"|\"stridor\"|\"swelling\"|\"dysphagia\"| \"haemoglobin\" \"decreased\"|\"diarrhoea\"| \"ileus\" \"paralytic\"|\"clonus\"|\"insomnia\"| \"electrocardiogram\" \"qrs\" \"complex\"| \"nasal\" \"congestion\"| \"nasal\" \"dryness\"|\"sweating\"|\"rash\"| \"nodal\" \"arrhythmia\"|\"irritability\"|\"hyperhidrosis\"| \"ventricular\" \"failure\")");
        TokenSequencePattern p2 = TokenSequencePattern.compile("(?$dt \"disease\") []{0,15} (?$se  \"social\" \"avoidant\" \"behaviour\"|\"dysuria\"|\"hyperglycaemia\"| \"mental\" \"disorder\"|\"vertigo\"|\"flutter\"| \"chest\" \"pain\"| \"elevated\" \"blood\" \"pressure\"|\"mania\"| \"rash\" \"erythematous\"|\"manic\"| \"papular\" \"rash\"|\"death\"| \"atrial\" \"arrhythmia\"| \"dry\" \"eyes\"| \"loss\" \"of\" \"libido\"| \"rash\" \"papular\"|\"hypersensitivity\"| \"blood\" \"pressure\" \"increased\"|\"dyspepsia\"| \"accommodation\" \"disorder\"| \"reflexes\" \"increased\"|\"lesions\"|\"asthenia\"| \"gastrointestinal\" \"pain\"|\"excitement\"| \"breast\" \"feeding\"|\"hypokalaemia\"| \"cerebellar\" \"syndrome\"|\"nervousness\"| \"pulmonary\" \"oedema\"| \"inspiratory\" \"stridor\"| \"taste\" \"altered\"|\"paranoia\"| \"psychotic\" \"disorder\"| \"open\" \"angle\" \"glaucoma\"|\"photophobia\"| \"dry\" \"eye\"|\"osteoarthritis\"| \"keratoconjunctivitis\" \"sicca\"| \"haemoglobin\" \"increased\"| \"ventricular\" \"extrasystoles\"|\"hallucinations\"|\"conjunctivitis\"|\"paralysis\"| \"qrs\" \"complex\"|\"anxiety\"| \"conjunctival\" \"disorder\"|\"coma\"|\"strabismus\"|\"thirst\"|\"para\"| \"sicca\" \"syndrome\"| \"atrioventricular\" \"dissociation\"|\"desquamation\"|\"crusting\"| \"abdominal\" \"distension\"|\"blindness\"|\"hypotension\"|\"dermatitis\"| \"sinus\" \"tachycardia\"| \"abdominal\" \"distention\"| \"lacrimation\" \"decreased\"|\"sicca\"| \"paralytic\" \"ileus\"| \"urinary\" \"hesitation\"|\"withdrawn\"| \"erectile\" \"dysfunction\"|\"keratoconjunctivitis\"|\"anaphylaxis\"| \"psychiatric\" \"disorders\"| \"altered\" \"taste\"|\"somnolence\"|\"extrasystoles\"|\"ageusia\"| \"intraocular\" \"pressure\" \"increased\"| \"left\" \"ventricular\" \"failure\"|\"impotence\"|\"drowsiness\"|\"conjunctiva\"| \"delayed\" \"gastric\" \"emptying\"| \"gastrointestinal\" \"sounds\" \"abnormal\"| \"qt\" \"prolonged\"| \"supraventricular\" \"tachycardia\"|\"weakness\"|\"hypertonia\"| \"confusional\" \"state\"|\"anhidrosis\"|\"myopia\"|\"dyspnoea\"| \"speech\" \"impairment\" \"nos\"| \"rash\" \"maculo\" \"papular\"|\"petechiae\"|\"tachypnea\"| \"acute\" \"angle\" \"closure\" \"glaucoma\"| \"gastrooesophageal\" \"reflux\" \"disease\"|\"hypokalemia\"| \"left\" \"heart\" \"failure\"| \"myocardial\" \"infarction\"| \"site\" \"reaction\"| \"ventricular\" \"fibrillation\"|\"fibrillation\"| \"maculopapular\" \"rash\"| \"impaired\" \"gastric\" \"emptying\"|\"amnesia\"| \"labored\" \"respirations\"| \"decreased\" \"lacrimation\"|\"mydriasis\"|\"headache\"| \"dry\" \"mouth\"|\"scab\"| \"cardiac\" \"syncope\"| \"visual\" \"acuity\" \"reduced\"|\"tension\"| \"blurred\" \"vision\"| \"bloated\" \"feeling\"| \"labored\" \"breathing\"| \"stridor\" \"inspiratory\"| \"skin\" \"exfoliation\"| \"memory\" \"loss\"|\"syncope\"| \"rash\" \"scarlatiniform\"|\"hyperpyrexia\"| \"cardiac\" \"flutter\"|\"heartburn\"| \"bowel\" \"sounds\" \"decreased\"|\"blepharitis\"|\"tachycardia\"| \"excessive\" \"thirst\"|\"confusion\"| \"rash\" \"macular\"| \"taste\" \"loss\"| \"respiratory\" \"failure\"|\"hesitancy\"|\"dysmetria\"|\"disorientation\"| \"decreased\" \"hemoglobin\"| \"atrial\" \"fibrillation\"| \"urinary\" \"retention\"| \"dry\" \"skin\"|\"dehydration\"|\"hyponatraemia\"|\"dysgeusia\"|\"disorder\"| \"increased\" \"intraocular\" \"pressure\"| \"speech\" \"disorder\"| \"feeling\" \"abnormal\"|\"pain\"| \"anaphylactic\" \"shock\"|\"hallucination\"| \"abdominal\" \"pain\"| \"junctional\" \"tachycardia\"| \"bun\" \"increased\"| \"ventricular\" \"flutter\"| \"scarlatiniform\" \"rash\"|\"agitation\"| \"feeling\" \"hot\"|\"hyponatremia\"| \"decreased\" \"bowel\" \"sounds\"|\"cyanosis\"|\"dysarthria\"| \"heat\" \"intolerance\"|\"hyperglycemia\"|\"reflux\"| \"angle\" \"closure\" \"glaucoma\"| \"electrocardiogram\" \"qt\" \"prolonged\"| \"vision\" \"blurred\"| \"blood\" \"urea\" \"increased\"|\"dizziness\"|\"arrhythmia\"|\"erythema\"|\"vomiting\"| \"difficulty\" \"in\" \"micturition\"|\"infarction\"|\"laryngospasm\"|\"hypoglycaemia\"|\"hypoglycemia\"| \"elevated\" \"hemoglobin\"| \"skin\" \"warm\"| \"ventricular\" \"arrhythmia\"|\"dissociation\"| \"warm\" \"skin\"| \"follicular\" \"conjunctivitis\"|\"urticaria\"|\"fatigue\"| \"cardiac\" \"fibrillation\"| \"decreased\" \"sweating\"| \"decreased\" \"visual\" \"acuity\"|\"lethargy\"| \"acute\" \"angle\" \"closure\" \"glaucoma\"| \"nodal\" \"rhythm\"|\"borborygmi\"|\"hyperreflexia\"| \"respiratory\" \"depression\"|\"diarrhea\"|\"leukocytosis\"| \"speech\" \"disturbance\"|\"ataxia\"|\"cycloplegia\"|\"tachypnoea\"|\"eczema\"| \"supraventricular\" \"extrasystoles\"|\"ileus\"| \"cardiac\" \"arrest\"| \"ventricular\" \"tachycardia\"|\"laryngitis\"|\"delirium\"|\"lactation\"|\"glaucoma\"|\"obstruction\"|\"hypohidrosis\"|\"parity\"|\"palpitations\"| \"temperature\" \"intolerance\"|\"constipation\"|\"cyclophoria\"| \"acute\" \"coronary\" \"syndrome\"| \"arrhythmia\" \"supraventricular\"|\"arrest\"|\"lesion\"|\"nausea\"| \"sweating\" \"decreased\"|\"keratitis\"|\"dyskinesia\"| \"pulmonary\" \"function\" \"test\" \"decreased\"|\"stridor\"|\"swelling\"|\"dysphagia\"| \"haemoglobin\" \"decreased\"|\"diarrhoea\"| \"ileus\" \"paralytic\"|\"clonus\"|\"insomnia\"| \"electrocardiogram\" \"qrs\" \"complex\"| \"nasal\" \"congestion\"| \"nasal\" \"dryness\"|\"sweating\"|\"rash\"| \"nodal\" \"arrhythmia\"|\"irritability\"|\"hyperhidrosis\"| \"ventricular\" \"failure\")");
        CoreMap doc = TokenSequenceMatcherITest.createDocument("atropine we need to have many many words here but we don't sweating");
        MultiPatternMatcher<CoreMap> multiPatternMatcher = TokenSequencePattern.getMultiPatternMatcher(p1, p2);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("atropine we need to have many many words here but we don't sweating");
        Iterator expectedIter = expected.iterator();
        Iterable<SequenceMatchResult<CoreMap>> matches = multiPatternMatcher.findAllNonOverlappingMatchesPerPattern((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        for (SequenceMatchResult<CoreMap> match : matches) {
            TokenSequenceMatcherITest.assertEquals((String)((String)expectedIter.next()), (String)match.group());
        }
        TokenSequenceMatcherITest.assertFalse((boolean)expectedIter.hasNext());
    }

    public void testTokenSequenceMatcherPosNNP() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p = TokenSequencePattern.compile("[ { tag:\"NNP\" } ]+");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus", (String)m.group());
        p = TokenSequencePattern.compile("[ { tag:\"NNP\" } ] [ /is|was/ ] []*? [ { tag:\"NNP\" } ]+ ");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was the first Bishop", (String)m.group());
        TokenSequencePattern nnpPattern = TokenSequencePattern.compile("[ { tag:\"NNP\" } ]");
        Env env = TokenSequencePattern.getNewEnv();
        env.bind("$NNP", nnpPattern);
        p = TokenSequencePattern.compile(env, " $NNP [ /is|was/ ] []*? $NNP+ [ \"of\" ] $NNP+ ");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was the first Bishop of London", (String)m.group());
        p = TokenSequencePattern.compile(env, " ($NNP) /is|was/ []*? ($NNP)+ \"of\" ($NNP)+ ");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was the first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(3));
        nnpPattern = TokenSequencePattern.compile(" ( [ { tag:\"NNP\" } ] )");
        env.bind("$NNP", nnpPattern);
        p = TokenSequencePattern.compile(env, " $NNP /is|was/ []*? $NNP+ \"of\" $NNP+ ");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was the first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(3));
        nnpPattern = TokenSequencePattern.compile(" ( [ tag:\"NNP\" ] )");
        env.bind("$NNP", nnpPattern);
        p = TokenSequencePattern.compile(env, " $NNP /is|was/ []*? $NNP+ \"of\" $NNP+ ");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was the first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(3));
        nnpPattern = TokenSequencePattern.compile(" ( [ pos:\"NNP\" ] )");
        env.bind("$NNP", nnpPattern);
        p = TokenSequencePattern.compile(env, " $NNP /is|was/ []*? $NNP+ \"of\" $NNP+ ");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)3, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus was the first Bishop of London", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"Mellitus", (String)m.group(1));
        TokenSequenceMatcherITest.assertEquals((String)"Bishop", (String)m.group(2));
        TokenSequenceMatcherITest.assertEquals((String)"London", (String)m.group(3));
    }

    public void testTokenSequenceMatcherNumber() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument("It happened on January 3, 2002");
        TokenSequencePattern p = TokenSequencePattern.compile("[ { word::IS_NUM } ]+");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"3", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"2002", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ { word>=2002 } ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"2002", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ { word>2002 } ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ word > 2002 | word==2002 ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"2002", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ word>2002 & word==2002 ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ { word>2000 } ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"2002", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ { word<=2002 } ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"3", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"2002", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ { word<2002 } ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"3", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ { word==2002 } ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"2002", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ { ner:DATE } ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"January 3, 2002", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ { ner::NOT_NIL } ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"January 3, 2002", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ { ner::IS_NIL } ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"It happened on", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ {{ word=~/2002/ }} ]+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"2002", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherNested() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument("A A A B B B B B B C C");
        TokenSequencePattern p = TokenSequencePattern.compile("( /B/+ )+");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"B B B B B B", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"B B B B B B", (String)m.group(1));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherAAs() throws IOException {
        StringBuilder s = new StringBuilder();
        for (int i = 1; i <= 10; ++i) {
            s.append("A ");
            CoreMap doc = TokenSequenceMatcherITest.createDocument(s.toString());
            TokenSequencePattern p = TokenSequencePattern.compile("(A?){" + i + "} " + "A" + "{" + i + "}");
            SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
            boolean match = m.matches();
            TokenSequenceMatcherITest.assertTrue((boolean)match);
        }
    }

    public void _testTokenSequenceFindsWildcard() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument("word1 word2");
        TokenSequencePattern p = TokenSequencePattern.compile("[]{2}|[]");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"word1 word2", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[]|[]{2}");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"word1 word2", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[]{2}");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"word1 word2", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatchesWildcard() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument("word1 word2");
        TokenSequencePattern p = TokenSequencePattern.compile("[]{2}|[]");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean matches = m.matches();
        TokenSequenceMatcherITest.assertTrue((boolean)matches);
        p = TokenSequencePattern.compile("[]|[]{2}");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        matches = m.matches();
        TokenSequenceMatcherITest.assertTrue((boolean)matches);
        p = TokenSequencePattern.compile("[]{1,2}");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        matches = m.matches();
        TokenSequenceMatcherITest.assertTrue((boolean)matches);
    }

    public void testTokenSequenceMatcherABs() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument("A A A A A A A B A A B A C A E A A A A A A A A A A A B A A A");
        TokenSequencePattern p = TokenSequencePattern.compile("/A/+ B");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A A A A A B", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A B", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A A A A A A A A A B", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("(/A/+ B)+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A A A A A B A A B", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A A A A A A A A A B", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("( A+ ( /B/+ )? )*");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A A A A A B A A B A", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)2, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A A A A A A A A A B A A A", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("(/A/+ /B/+ )+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A A A A A B A A B", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A A A A A A A A A B", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("(/A/+ /C/? /A/* )+");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A A A A A", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A C A", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A A A A A A A A A", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherMultiNodePattern() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument("blah four-years blah blah four - years");
        CoreMapNodePattern nodePattern = CoreMapNodePattern.valueOf("four\\s*-?\\s*years");
        SequencePattern.MultiNodePatternExpr expr = new SequencePattern.MultiNodePatternExpr(new MultiCoreMapNodePattern(nodePattern));
        TokenSequencePattern p = TokenSequencePattern.compile(expr);
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"four-years", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"four - years", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("(?m) /four\\s*-?\\s*years/");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"four-years", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"four - years", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("(?m){2,3} /four\\s*-?\\s*years/");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"four - years", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("(?m){1,2} /four\\s*-?\\s*years/");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"four-years", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("(?m){1,3} /four\\s*-?\\s*years/ ==> &annotate( { ner=YEAR } )");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"four-years", (String)m.group());
        p.getAction().apply(m, 0);
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"four - years", (String)m.group());
        SequenceMatchResult res = p.getAction().apply(m, 0);
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("[ { ner:YEAR } ]+");
        m = p.getMatcher(res.elements());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"four-years", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)0, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"four - years", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherMultiNodePattern2() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument("Replace the lamp with model wss.32dc55c3e945384dbc5e533ab711fd24");
        TokenSequencePattern p = TokenSequencePattern.compile("/model/ ((?m){1,4}/\\w+\\.\\w+/)");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"model wss.32dc55c3e945384dbc5e533ab711fd24", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"wss.32dc55c3e945384dbc5e533ab711fd24", (String)m.group(1));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
        p = TokenSequencePattern.compile("/model/ ((?m){1,4}?/\\w+\\.\\w+/)");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"model wss.32", (String)m.group());
        TokenSequenceMatcherITest.assertEquals((String)"wss.32", (String)m.group(1));
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testTokenSequenceMatcherBackRef() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument("A A A A A A A B A A B A C A E A A A A A A A A A A A B A A A");
        TokenSequencePattern p = TokenSequencePattern.compile("(/A/+) B \\1");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A B A A", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
        TokenSequenceMatcherITest.assertEquals((int)1, (int)m.groupCount());
        TokenSequenceMatcherITest.assertEquals((String)"A A A B A A A", (String)m.group());
        match = m.find();
        TokenSequenceMatcherITest.assertFalse((boolean)match);
    }

    public void testMultiPatternMatcher() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        TokenSequencePattern p1 = TokenSequencePattern.compile("/Archbishop/ /of/ /Canterbury/");
        p1.setPriority(1.0);
        TokenSequencePattern p2 = TokenSequencePattern.compile("/[a-zA-Z]+/{1,2}  /of/ /[a-zA-Z]+/+");
        MultiPatternMatcher m = new MultiPatternMatcher(p2, p1);
        List matched = m.findNonOverlapping((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        TokenSequenceMatcherITest.assertEquals((int)4, (int)matched.size());
        TokenSequenceMatcherITest.assertEquals((String)"first Bishop of London", (String)matched.get(0).group());
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)matched.get(1).group());
        TokenSequenceMatcherITest.assertEquals((String)"a member of the Gregorian mission sent to England to convert the", (String)matched.get(2).group());
        TokenSequenceMatcherITest.assertEquals((String)"as Bishop of London in", (String)matched.get(3).group());
    }

    public void testStringPatternMatchCaseInsensitive() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        Env env = TokenSequencePattern.getNewEnv();
        env.setDefaultStringPatternFlags(2);
        TokenSequencePattern p = TokenSequencePattern.compile(env, "/archbishop/ /of/ /canterbury/");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        TokenSequenceMatcherITest.assertTrue((boolean)m.find());
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertFalse((boolean)m.find());
        p = TokenSequencePattern.compile(env, "/ARCHBISHOP/ /OF/ /CANTERBURY/");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        TokenSequenceMatcherITest.assertTrue((boolean)m.find());
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertFalse((boolean)m.find());
    }

    public void testStringMatchCaseInsensitive() throws IOException {
        CoreMap doc = TokenSequenceMatcherITest.createDocument(testText1);
        Env env = TokenSequencePattern.getNewEnv();
        env.setDefaultStringMatchFlags(2);
        TokenSequencePattern p = TokenSequencePattern.compile(env, "archbishop of canterbury");
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        TokenSequenceMatcherITest.assertTrue((boolean)m.find());
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertFalse((boolean)m.find());
        p = TokenSequencePattern.compile(env, "ARCHBISHOP OF CANTERBURY");
        m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        TokenSequenceMatcherITest.assertTrue((boolean)m.find());
        TokenSequenceMatcherITest.assertEquals((String)"Archbishop of Canterbury", (String)m.group());
        TokenSequenceMatcherITest.assertFalse((boolean)m.find());
    }

    public void testCompile() {
        String s = "(?$se \"matching\" \"this\"|\"don't\")";
        CoreMap doc = TokenSequenceMatcherITest.createDocument("does this do matching this");
        TokenSequencePattern p = TokenSequencePattern.compile(s);
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
    }

    public void testBindingCompile() {
        Env env = TokenSequencePattern.getNewEnv();
        env.bind("wordname", CoreAnnotations.TextAnnotation.class);
        String s = "[wordname:\"name\"]{1,2}";
        TokenSequencePattern p = TokenSequencePattern.compile(env, s);
    }

    public void testCaseInsensitive1() {
        Env env = TokenSequencePattern.getNewEnv();
        env.setDefaultStringPatternFlags(2);
        env.setDefaultStringMatchFlags(2);
        String s = "for /President/";
        CoreMap doc = TokenSequenceMatcherITest.createDocument("for president");
        TokenSequencePattern p = TokenSequencePattern.compile(env, s);
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
    }

    public void testCaseInsensitive2() {
        Env env = TokenSequencePattern.getNewEnv();
        env.setDefaultStringPatternFlags(2);
        env.setDefaultStringMatchFlags(2);
        String s = "for president";
        CoreMap doc = TokenSequenceMatcherITest.createDocument("for President");
        TokenSequencePattern p = TokenSequencePattern.compile(env, s);
        SequenceMatcher m = p.getMatcher((List)doc.get(CoreAnnotations.TokensAnnotation.class));
        boolean match = m.find();
        TokenSequenceMatcherITest.assertTrue((boolean)match);
    }
}

